/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.LockUtil;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.NodeBasedLockManager;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PessimisticNodeBasedLockManager
extends NodeBasedLockManager {
    private static final Log log = LogFactory.getLog(PessimisticNodeBasedLockManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private CommandsFactory commandsFactory;

    @Inject
    private void injectCommandsFactory(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    public boolean lockPessimistically(InvocationContext ctx, Fqn fqn, LockType lockType, boolean createIfNotExists, boolean zeroLockTimeout, boolean acquireWriteLockOnParent, boolean reverseRemoveCheck, List<NodeSPI> createdNodes, boolean skipNotification) throws InterruptedException {
        boolean created;
        if (fqn == null || this.configuration.getIsolationLevel() == IsolationLevel.NONE || ctx.isLockingSuppressed()) {
            return false;
        }
        long timeout = zeroLockTimeout ? 0L : ctx.getContextLockAcquisitionTimeout(this.lockAcquisitionTimeout);
        long cutoffTime = System.currentTimeMillis() + timeout;
        boolean firstTry = true;
        do {
            if (!firstTry && System.currentTimeMillis() > cutoffTime) {
                throw new TimeoutException("Unable to acquire lock on Fqn " + fqn + " after " + timeout + " millis");
            }
            created = this.lock(ctx, fqn, lockType, createIfNotExists, timeout, acquireWriteLockOnParent, reverseRemoveCheck, createdNodes, skipNotification);
            firstTry = false;
        } while (createIfNotExists && this.dataContainer.peek(fqn, false, false) == null);
        return created;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean lock(InvocationContext ctx, Fqn fqn, LockType lockType, boolean createIfNotExists, long timeout, boolean acquireWriteLockOnParent, boolean reverseRemoveCheck, List<NodeSPI> createdNodes, boolean skipNotification) throws TimeoutException, LockingException, InterruptedException {
        Object owner;
        Thread currentThread = Thread.currentThread();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        boolean created = false;
        if (gtx != null) {
            TransactionTable.assertTransactionValid(ctx);
        }
        Object object = owner = gtx != null ? gtx : currentThread;
        if (trace) {
            log.trace((Object)("Attempting to lock node " + fqn + " for owner " + owner));
        }
        long expiryTime = System.currentTimeMillis() + timeout;
        NodeSPI currentNode = this.rootNode;
        NodeSPI parent = null;
        Object childName = null;
        int currentIndex = -1;
        int targetFqnSize = fqn.size();
        while (true) {
            if (currentNode == null) {
                if (!createIfNotExists) {
                    if (!trace) return false;
                    log.trace((Object)("failed to find or create child " + childName + " of node " + parent));
                    return false;
                }
                currentNode = parent.addChildDirect((Object)childName, !skipNotification);
                created = true;
                if (trace) {
                    log.trace((Object)("Child node was null, so created child node " + childName));
                }
                if (createdNodes != null) {
                    createdNodes.add(currentNode);
                }
            } else if (!currentNode.isValid() && createIfNotExists) {
                currentNode.setValid(true, false);
            }
            LockType lockTypeRequired = LockType.READ;
            if (created || this.writeLockNeeded(ctx, lockType, currentIndex, acquireWriteLockOnParent, createIfNotExists, fqn, currentNode)) {
                lockTypeRequired = LockType.WRITE;
            }
            Fqn currentNodeFqn = currentNode.getFqn();
            this.acquireNodeLock(ctx, currentNode, owner, gtx, lockTypeRequired, timeout);
            LockUtil.manageReverseRemove(ctx, currentNode, reverseRemoveCheck, createdNodes, this.commandsFactory);
            NodeSPI repeek = this.dataContainer.peek(currentNodeFqn, true, true);
            if (currentNode != repeek) {
                if (trace) {
                    log.trace((Object)"Was waiting for and obtained a lock on a node that doesn't exist anymore!  Attempting lock acquisition again.");
                }
                currentNode.getLock().releaseAll(owner);
                if (parent == null || this.dataContainer.peek(parent.getFqn(), true, true) == null) {
                    if (trace) {
                        log.trace((Object)"Parent has been deleted again.  Go through the lock method all over again.");
                    }
                    currentNode = this.rootNode;
                    currentIndex = -1;
                    parent = null;
                    continue;
                }
                currentNode = parent;
                --currentIndex;
                parent = null;
                if (System.currentTimeMillis() > expiryTime) {
                    throw new TimeoutException("Unable to acquire lock on child node " + Fqn.fromRelativeElements(currentNode.getFqn(), childName) + " after " + timeout + " millis.");
                }
                if (!trace) continue;
                log.trace((Object)("Moving one level up, current node is :" + currentNode));
                continue;
            }
            if (++currentIndex == targetFqnSize) {
                return created;
            }
            if (!fqn.isChildOrEquals(currentNode.getFqn())) {
                String message = "currentNode instance changed the FQN(" + currentNode.getFqn() + ") and do not match the FQN on which we want to acquire lock(" + fqn + ")";
                log.trace((Object)message);
                throw new LockingException(message);
            }
            parent = currentNode;
            childName = fqn.get(currentIndex);
            currentNode = currentNode.getChildDirect((Object)childName);
        }
    }

    private boolean writeLockNeeded(InvocationContext ctx, LockType lockType, int currentNodeIndex, boolean acquireWriteLockOnParent, boolean createIfNotExists, Fqn targetFqn, NodeSPI currentNode) {
        boolean isTargetNode;
        int treeNodeSize = targetFqn.size();
        boolean bl = isTargetNode = currentNodeIndex == treeNodeSize - 1;
        if (isTargetNode && ctx.getOptionOverrides().isForceWriteLock()) {
            return true;
        }
        if (currentNode.isLockForChildInsertRemove()) {
            if (acquireWriteLockOnParent && currentNodeIndex == treeNodeSize - 2) {
                return true;
            }
            if (!isTargetNode && this.dataContainer.peek(targetFqn.getAncestor(currentNodeIndex + 2), false, false) == null) {
                return createIfNotExists;
            }
        }
        return lockType == LockType.WRITE && isTargetNode;
    }

    private void acquireNodeLock(InvocationContext ctx, NodeSPI node, Object owner, GlobalTransaction gtx, LockType lockType, long lockTimeout) throws LockingException, TimeoutException, InterruptedException {
        NodeLock lock = node.getLock();
        boolean acquired = lock.acquire(owner, lockTimeout, lockType);
        if (acquired) {
            if (gtx != null) {
                ctx.getTransactionEntry().addLock(lock);
            } else {
                ctx.addInvocationLockAcquired(lock);
            }
        }
    }
}

