/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.marshall.AbstractMarshaller;
import org.jboss.cache.marshall.InactiveRegionException;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.marshall.RegionalizedMethodCall;
import org.jboss.cache.marshall.RegionalizedReturnValue;
import org.jboss.cache.marshall.UnmarshalledReferences;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.util.MapCopy;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;
import org.jgroups.stack.IpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMarshaller200
extends AbstractMarshaller {
    protected static final int MAGICNUMBER_METHODCALL = 1;
    protected static final int MAGICNUMBER_FQN = 2;
    protected static final int MAGICNUMBER_GTX = 3;
    protected static final int MAGICNUMBER_IPADDRESS = 4;
    protected static final int MAGICNUMBER_ARRAY_LIST = 5;
    protected static final int MAGICNUMBER_INTEGER = 6;
    protected static final int MAGICNUMBER_LONG = 7;
    protected static final int MAGICNUMBER_BOOLEAN = 8;
    protected static final int MAGICNUMBER_STRING = 9;
    protected static final int MAGICNUMBER_DEFAULT_DATA_VERSION = 10;
    protected static final int MAGICNUMBER_LINKED_LIST = 11;
    protected static final int MAGICNUMBER_HASH_MAP = 12;
    protected static final int MAGICNUMBER_TREE_MAP = 13;
    protected static final int MAGICNUMBER_HASH_SET = 14;
    protected static final int MAGICNUMBER_TREE_SET = 15;
    protected static final int MAGICNUMBER_NODEDATA_MARKER = 16;
    protected static final int MAGICNUMBER_NODEDATA_EXCEPTION_MARKER = 17;
    protected static final int MAGICNUMBER_NODEDATA = 18;
    protected static final int MAGICNUMBER_GRAVITATERESULT = 19;
    protected static final int MAGICNUMBER_SHORT = 20;
    protected static final int MAGICNUMBER_MAPCOPY = 21;
    protected static final int MAGICNUMBER_MARSHALLEDVALUE = 22;
    protected static final int MAGICNUMBER_NULL = 99;
    protected static final int MAGICNUMBER_SERIALIZABLE = 100;
    protected static final int MAGICNUMBER_REF = 101;
    protected static final InactiveRegionException IRE = new InactiveRegionException("Cannot unmarshall to an inactive region");
    protected CommandsFactory commandsFactory;

    public CacheMarshaller200() {
        this.initLogger();
        this.useRefs = true;
    }

    @Inject
    public void injectCommandsFactory(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Override
    public void objectToObjectStream(Object o, ObjectOutputStream out) throws Exception {
        if (this.useRegionBasedMarshalling) {
            Fqn region = null;
            if (o instanceof RegionalizedReturnValue) {
                RegionalizedReturnValue rrv = (RegionalizedReturnValue)o;
                region = rrv.region;
                o = rrv.returnValue;
            } else if (o instanceof ReplicableCommand) {
                ReplicableCommand marshallableCommand = (ReplicableCommand)o;
                region = this.extractFqnRegion(marshallableCommand);
            }
            if (this.trace) {
                this.log.trace((Object)("Region based call.  Using region " + region));
            }
            this.objectToObjectStream(o, out, region);
        } else {
            this.objectToObjectStream(o, out, null);
        }
    }

    @Override
    public RegionalizedMethodCall regionalizedMethodCallFromObjectStream(ObjectInputStream in) throws Exception {
        Object[] retVal = this.objectFromObjectStreamRegionBased(in);
        RegionalizedMethodCall rmc = new RegionalizedMethodCall();
        rmc.command = (ReplicableCommand)retVal[0];
        rmc.region = (Fqn)retVal[1];
        return rmc;
    }

    @Override
    public Object objectFromObjectStream(ObjectInputStream in) throws Exception {
        if (this.useRegionBasedMarshalling) {
            return this.objectFromObjectStreamRegionBased(in)[0];
        }
        UnmarshalledReferences refMap = this.useRefs ? new UnmarshalledReferences() : null;
        Object retValue = this.unmarshallObject(in, this.defaultClassLoader, refMap, false);
        if (this.trace) {
            this.log.trace((Object)("Unmarshalled object " + retValue));
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectToObjectStream(Object o, ObjectOutputStream out, Fqn region) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("Marshalling object " + o));
        }
        HashMap<Object, Integer> refMap = this.useRefs ? new HashMap<Object, Integer>() : null;
        ClassLoader toUse = this.defaultClassLoader;
        Thread current = Thread.currentThread();
        ClassLoader old = current.getContextClassLoader();
        if (old != null) {
            toUse = old;
        }
        try {
            if (this.useRegionBasedMarshalling) {
                if (this.trace) {
                    this.log.trace((Object)("Writing region " + region + " to stream"));
                }
                Region r = null;
                if (region != null) {
                    r = this.regionManager.getRegion(region, false);
                }
                if (r != null && r.getClassLoader() != null) {
                    toUse = r.getClassLoader();
                }
                current.setContextClassLoader(toUse);
                this.marshallObject(region, out, refMap);
            } else {
                current.setContextClassLoader(toUse);
            }
            this.marshallObject(o, out, refMap);
        }
        finally {
            current.setContextClassLoader(old);
        }
    }

    protected Object[] objectFromObjectStreamRegionBased(ObjectInputStream in) throws Exception {
        UnmarshalledReferences refMap = this.useRefs ? new UnmarshalledReferences() : null;
        Object o = this.unmarshallObject(in, refMap);
        Fqn regionFqn = null;
        if (o == null) {
            this.log.trace((Object)"Unmarshalled region as null.  Not using a context class loader to unmarshall.");
        } else {
            regionFqn = (Fqn)o;
        }
        if (this.trace) {
            this.log.trace((Object)("Unmarshalled regionFqn " + regionFqn + " from stream"));
        }
        Region region = null;
        Object[] retValue = new Object[]{null, null};
        if (regionFqn != null) {
            region = this.findRegion(regionFqn);
        }
        if (region == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Region does not exist for Fqn " + regionFqn + " - not using a context classloader."));
            }
            retValue[0] = this.unmarshallObject(in, this.defaultClassLoader, refMap, false);
        } else {
            retValue[0] = this.unmarshallObject(in, region.getClassLoader(), refMap, true);
            retValue[1] = regionFqn;
        }
        if (this.trace) {
            this.log.trace((Object)("Unmarshalled object " + retValue[0] + " with region " + retValue[1]));
        }
        return retValue;
    }

    private Region findRegion(Fqn fqn) throws InactiveRegionException {
        Region region = this.getRegion(fqn);
        if (region != null) {
            Region.Status status = region.getStatus();
            if (status == Region.Status.INACTIVATING || status == Region.Status.INACTIVE) {
                if (this.log.isDebugEnabled()) {
                    throw new InactiveRegionException("Cannot unmarshall message for region " + fqn + ". This region is inactive.");
                }
                throw IRE;
            }
        } else if (this.defaultInactive) {
            if (this.log.isDebugEnabled()) {
                throw new InactiveRegionException("Cannot unmarshall message for region " + fqn + ". By default region " + fqn + " is inactive.");
            }
            throw IRE;
        }
        return region;
    }

    private Fqn extractFqnRegion(ReplicableCommand cmd) throws Exception {
        Fqn fqn = this.extractFqn(cmd);
        Region r = this.getRegion(fqn);
        return r == null ? null : r.getFqn();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void marshallObject(Object o, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        if (o == null) {
            out.writeByte(99);
            return;
        } else if (this.useRefs && refMap.containsKey(o)) {
            out.writeByte(101);
            this.writeReference(out, refMap.get(o));
            return;
        } else if (o instanceof ReplicableCommand) {
            ReplicableCommand command = (ReplicableCommand)o;
            if (command.getCommandId() <= -1) throw new IllegalArgumentException("MethodCall does not have a valid method id.  Was this method call created with MethodCallFactory?");
            out.writeByte(1);
            this.marshallCommand(command, out, refMap);
            return;
        } else {
            if (o instanceof MethodCall) {
                throw new IllegalArgumentException("Usage of a legacy MethodCall object!!");
            }
            if (o instanceof MarshalledValue) {
                out.writeByte(22);
                ((MarshalledValue)o).writeExternal(out);
                return;
            } else if (o instanceof Fqn) {
                out.writeByte(2);
                if (this.useRefs) {
                    this.writeReference(out, this.createReference(o, refMap));
                }
                this.marshallFqn((Fqn)o, out, refMap);
                return;
            } else if (o instanceof GlobalTransaction) {
                out.writeByte(3);
                if (this.useRefs) {
                    this.writeReference(out, this.createReference(o, refMap));
                }
                this.marshallGlobalTransaction((GlobalTransaction)o, out, refMap);
                return;
            } else if (o instanceof IpAddress) {
                out.writeByte(4);
                this.marshallIpAddress((IpAddress)o, out);
                return;
            } else if (o instanceof DefaultDataVersion) {
                out.writeByte(10);
                this.marshallDefaultDataVersion((DefaultDataVersion)o, out);
                return;
            } else if (o.getClass().equals(ArrayList.class)) {
                out.writeByte(5);
                this.marshallCollection((Collection)o, out, refMap);
                return;
            } else if (o.getClass().equals(LinkedList.class)) {
                out.writeByte(11);
                this.marshallCollection((Collection)o, out, refMap);
                return;
            } else if (o.getClass().equals(HashMap.class)) {
                out.writeByte(12);
                this.marshallMap((Map)o, out, refMap);
                return;
            } else if (o.getClass().equals(TreeMap.class)) {
                out.writeByte(13);
                this.marshallMap((Map)o, out, refMap);
                return;
            } else if (o.getClass().equals(MapCopy.class)) {
                out.writeByte(21);
                this.marshallMap((Map)o, out, refMap);
                return;
            } else if (o.getClass().equals(HashSet.class)) {
                out.writeByte(14);
                this.marshallCollection((Collection)o, out, refMap);
                return;
            } else if (o.getClass().equals(TreeSet.class)) {
                out.writeByte(15);
                this.marshallCollection((Collection)o, out, refMap);
                return;
            } else if (o instanceof Boolean) {
                out.writeByte(8);
                out.writeBoolean((Boolean)o);
                return;
            } else if (o instanceof Integer) {
                out.writeByte(6);
                out.writeInt((Integer)o);
                return;
            } else if (o instanceof Long) {
                out.writeByte(7);
                out.writeLong((Long)o);
                return;
            } else if (o instanceof Short) {
                out.writeByte(20);
                out.writeShort(((Short)o).shortValue());
                return;
            } else if (o instanceof String) {
                out.writeByte(9);
                if (this.useRefs) {
                    this.writeReference(out, this.createReference(o, refMap));
                }
                this.marshallString((String)o, out);
                return;
            } else if (o instanceof NodeDataMarker) {
                out.writeByte(16);
                ((Externalizable)o).writeExternal(out);
                return;
            } else if (o instanceof NodeDataExceptionMarker) {
                out.writeByte(17);
                ((Externalizable)o).writeExternal(out);
                return;
            } else if (o instanceof NodeData) {
                out.writeByte(18);
                ((Externalizable)o).writeExternal(out);
                return;
            } else if (o instanceof GravitateResult) {
                out.writeByte(19);
                this.marshallGravitateResult((GravitateResult)o, out, refMap);
                return;
            } else {
                if (!(o instanceof Serializable)) throw new Exception("Don't know how to marshall object of type " + o.getClass());
                if (this.trace) {
                    this.log.trace((Object)("Warning: using object serialization for " + o.getClass()));
                }
                out.writeByte(100);
                if (this.useRefs) {
                    this.writeReference(out, this.createReference(o, refMap));
                }
                out.writeObject(o);
            }
        }
    }

    private void marshallGravitateResult(GravitateResult gravitateResult, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        this.marshallObject(gravitateResult.isDataFound(), out, refMap);
        if (gravitateResult.isDataFound()) {
            this.marshallObject(gravitateResult.getNodeData(), out, refMap);
            this.marshallObject(gravitateResult.getBuddyBackupFqn(), out, refMap);
        }
    }

    private int createReference(Object o, Map<Object, Integer> refMap) {
        int reference = refMap.size();
        refMap.put(o, reference);
        return reference;
    }

    protected void marshallString(String s, ObjectOutputStream out) throws Exception {
        out.writeObject(s);
    }

    private void marshallCommand(ReplicableCommand command, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        out.writeShort(command.getCommandId());
        Object[] args = command.getParameters();
        int numArgs = args == null ? 0 : args.length;
        out.writeByte(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            this.marshallObject(args[i], out, refMap);
        }
    }

    private void marshallGlobalTransaction(GlobalTransaction globalTransaction, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        out.writeLong(globalTransaction.getId());
        this.marshallObject(globalTransaction.getAddress(), out, refMap);
    }

    protected void marshallFqn(Fqn fqn, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        boolean isRoot = fqn.isRoot();
        out.writeBoolean(isRoot);
        if (!isRoot) {
            out.writeShort(fqn.size());
            for (Object o : fqn.peekElements()) {
                this.marshallObject(o, out, refMap);
            }
        }
    }

    private void marshallIpAddress(IpAddress ipAddress, ObjectOutputStream out) throws Exception {
        ipAddress.writeExternal((ObjectOutput)out);
    }

    private void marshallCollection(Collection c, ObjectOutputStream out, Map refMap) throws Exception {
        this.writeUnsignedInt(out, c.size());
        for (Object o : c) {
            this.marshallObject(o, out, refMap);
        }
    }

    private void marshallMap(Map map, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        int mapSize = map.size();
        this.writeUnsignedInt(out, mapSize);
        if (mapSize == 0) {
            return;
        }
        for (Map.Entry me : map.entrySet()) {
            this.marshallObject(me.getKey(), out, refMap);
            this.marshallObject(me.getValue(), out, refMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshallObject(ObjectInputStream in, ClassLoader loader, UnmarshalledReferences refMap, boolean overrideContextClassloaderOnThread) throws Exception {
        if (loader == null) {
            return this.unmarshallObject(in, refMap);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader old = currentThread.getContextClassLoader();
        try {
            if (overrideContextClassloaderOnThread || old == null) {
                currentThread.setContextClassLoader(loader);
            }
            Object object = this.unmarshallObject(in, refMap);
            return object;
        }
        finally {
            if (overrideContextClassloaderOnThread || old == null) {
                currentThread.setContextClassLoader(old);
            }
        }
    }

    protected Object unmarshallObject(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        byte magicNumber = in.readByte();
        int reference = 0;
        switch (magicNumber) {
            case 99: {
                return null;
            }
            case 101: {
                if (!this.useRefs) break;
                reference = this.readReference(in);
                return refMap.getReferencedObject(reference);
            }
            case 100: {
                if (this.useRefs) {
                    reference = this.readReference(in);
                }
                Object retVal = in.readObject();
                if (this.useRefs) {
                    refMap.putReferencedObject(reference, retVal);
                }
                return retVal;
            }
            case 22: {
                MarshalledValue mv = new MarshalledValue();
                mv.readExternal(in);
                return mv;
            }
            case 1: {
                ReplicableCommand retVal = this.unmarshallCommand(in, refMap);
                return retVal;
            }
            case 2: {
                if (this.useRefs) {
                    reference = this.readReference(in);
                }
                Fqn retVal = this.unmarshallFqn(in, refMap);
                if (this.useRefs) {
                    refMap.putReferencedObject(reference, retVal);
                }
                return retVal;
            }
            case 3: {
                if (this.useRefs) {
                    reference = this.readReference(in);
                }
                GlobalTransaction retVal = this.unmarshallGlobalTransaction(in, refMap);
                if (this.useRefs) {
                    refMap.putReferencedObject(reference, retVal);
                }
                return retVal;
            }
            case 4: {
                IpAddress retVal = this.unmarshallIpAddress(in);
                return retVal;
            }
            case 10: {
                DefaultDataVersion retVal = this.unmarshallDefaultDataVersion(in);
                return retVal;
            }
            case 5: {
                return this.unmarshallArrayList(in, refMap);
            }
            case 11: {
                return this.unmarshallLinkedList(in, refMap);
            }
            case 12: {
                return this.unmarshallHashMap(in, refMap);
            }
            case 13: {
                return this.unmarshallTreeMap(in, refMap);
            }
            case 14: {
                return this.unmarshallHashSet(in, refMap);
            }
            case 15: {
                return this.unmarshallTreeSet(in, refMap);
            }
            case 21: {
                return this.unmarshallMapCopy(in, refMap);
            }
            case 8: {
                return in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return in.readInt();
            }
            case 7: {
                return in.readLong();
            }
            case 20: {
                return in.readShort();
            }
            case 9: {
                if (this.useRefs) {
                    reference = this.readReference(in);
                }
                String retVal = this.unmarshallString(in);
                if (this.useRefs) {
                    refMap.putReferencedObject(reference, retVal);
                }
                return retVal;
            }
            case 16: {
                NodeDataMarker retVal = new NodeDataMarker();
                retVal.readExternal(in);
                return retVal;
            }
            case 17: {
                NodeDataExceptionMarker retVal = new NodeDataExceptionMarker();
                retVal.readExternal(in);
                return retVal;
            }
            case 18: {
                NodeData retVal = new NodeData();
                retVal.readExternal(in);
                return retVal;
            }
            case 19: {
                return this.unmarshallGravitateResult(in, refMap);
            }
            default: {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("Unknown Magic Number " + magicNumber));
                }
                throw new Exception("Unknown magic number " + magicNumber);
            }
        }
        throw new Exception("Unknown magic number " + magicNumber);
    }

    private GravitateResult unmarshallGravitateResult(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        Boolean found = (Boolean)this.unmarshallObject(in, refMap);
        if (found.booleanValue()) {
            List stuff = (List)this.unmarshallObject(in, refMap);
            Fqn fqn = (Fqn)this.unmarshallObject(in, refMap);
            return GravitateResult.subtreeResult(stuff, fqn);
        }
        return GravitateResult.noDataFound();
    }

    protected String unmarshallString(ObjectInputStream in) throws Exception {
        return (String)in.readObject();
    }

    private ReplicableCommand unmarshallCommand(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        short methodId = in.readShort();
        int numArgs = in.readByte();
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = this.unmarshallObject(in, refMap);
            }
        }
        return this.commandsFactory.fromStream(methodId, args);
    }

    private GlobalTransaction unmarshallGlobalTransaction(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        GlobalTransaction gtx = new GlobalTransaction();
        long id = in.readLong();
        Object address = this.unmarshallObject(in, refMap);
        gtx.setId(id);
        gtx.setAddress((Address)address);
        return gtx;
    }

    protected Fqn unmarshallFqn(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        Fqn fqn;
        boolean isRoot = in.readBoolean();
        if (!isRoot) {
            int numElements = in.readShort();
            ArrayList<Object> elements = new ArrayList<Object>(numElements);
            for (int i = 0; i < numElements; ++i) {
                elements.add(this.unmarshallObject(in, refMap));
            }
            fqn = Fqn.fromList(elements);
        } else {
            fqn = Fqn.ROOT;
        }
        return fqn;
    }

    private IpAddress unmarshallIpAddress(ObjectInputStream in) throws Exception {
        IpAddress ipAddress = new IpAddress();
        ipAddress.readExternal((ObjectInput)in);
        return ipAddress;
    }

    private List unmarshallArrayList(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        int listSize = this.readUnsignedInt(in);
        ArrayList list = new ArrayList(listSize);
        this.populateFromStream(in, refMap, list, listSize);
        return list;
    }

    private List unmarshallLinkedList(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        LinkedList list = new LinkedList();
        this.populateFromStream(in, refMap, list, this.readUnsignedInt(in));
        return list;
    }

    private Map unmarshallHashMap(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        HashMap map = new HashMap();
        this.populateFromStream(in, refMap, map);
        return map;
    }

    private Map unmarshallMapCopy(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        Map m = this.unmarshallHashMap(in, refMap);
        return new MapCopy(m);
    }

    private Map unmarshallTreeMap(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        TreeMap map = new TreeMap();
        this.populateFromStream(in, refMap, map);
        return map;
    }

    private Set unmarshallHashSet(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        HashSet set = new HashSet();
        this.populateFromStream(in, refMap, set);
        return set;
    }

    private Set unmarshallTreeSet(ObjectInputStream in, UnmarshalledReferences refMap) throws Exception {
        TreeSet set = new TreeSet();
        this.populateFromStream(in, refMap, set);
        return set;
    }

    private void populateFromStream(ObjectInputStream in, UnmarshalledReferences refMap, Map mapToPopulate) throws Exception {
        int size = this.readUnsignedInt(in);
        for (int i = 0; i < size; ++i) {
            mapToPopulate.put(this.unmarshallObject(in, refMap), this.unmarshallObject(in, refMap));
        }
    }

    private void populateFromStream(ObjectInputStream in, UnmarshalledReferences refMap, Set setToPopulate) throws Exception {
        int size = this.readUnsignedInt(in);
        for (int i = 0; i < size; ++i) {
            setToPopulate.add(this.unmarshallObject(in, refMap));
        }
    }

    private void populateFromStream(ObjectInputStream in, UnmarshalledReferences refMap, List listToPopulate, int listSize) throws Exception {
        for (int i = 0; i < listSize; ++i) {
            listToPopulate.add(this.unmarshallObject(in, refMap));
        }
    }

    protected void marshallDefaultDataVersion(DefaultDataVersion ddv, ObjectOutputStream out) throws Exception {
        this.writeUnsignedLong(out, ddv.getRawVersion());
    }

    protected DefaultDataVersion unmarshallDefaultDataVersion(ObjectInputStream in) throws Exception {
        return new DefaultDataVersion(this.readUnsignedLong(in));
    }

    protected int readReference(ObjectInputStream in) throws IOException {
        return in.readShort();
    }

    protected void writeReference(ObjectOutputStream out, int reference) throws IOException {
        out.writeShort(reference);
    }

    protected int readUnsignedInt(ObjectInputStream in) throws IOException {
        return in.readInt();
    }

    protected void writeUnsignedInt(ObjectOutputStream out, int i) throws IOException {
        out.writeInt(i);
    }

    protected long readUnsignedLong(ObjectInputStream in) throws IOException {
        return in.readLong();
    }

    protected void writeUnsignedLong(ObjectOutputStream out, long i) throws IOException {
        out.writeLong(i);
    }
}

