/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.pojo.test;

import java.util.Date;

/**
 * Can represent both software or devices (e.g., sensor).
 * <p>This object is used to illustrate the pojo cache capability of PojoCache. Note the absence of <code>Serializable</code>
 * interface.</p>
 *
 * @author <a href="mailto:ben.wang@jboss.com">Ben Wang</a>
 */
// We are using JDK1.5 annotation.
@org.jboss.cache.pojo.annotation.Replicable
public class NetworkElement
{
   // Unique id
   int id_;
   // Element type
   int type_;
   String name_;
   int status_;
   Date startDate_;
   NetworkNode parentNode_;

   public int getId()
   {
      return id_;
   }

   public void setId(int id)
   {
      id_ = id;
   }

   public int getType()
   {
      return type_;
   }

   public void setType(int type)
   {
      type_ = type;
   }

   public String getName()
   {
      return name_;
   }

   public void setName(String name)
   {
      name_ = name;
   }

   public int getStatus()
   {
      return status_;
   }

   public void setStatus(int status)
   {
      status_ = status;
   }

   public Date getStartDate()
   {
      return startDate_;
   }

   public void setStartDate(Date startDate)
   {
      startDate_ = startDate;
   }

   public NetworkNode getParentNode()
   {
      return parentNode_;
   }

   public void setParentNode(NetworkNode parentNode)
   {
      parentNode_ = parentNode;
   }

   public String toString()
   {
      StringBuffer sb = new StringBuffer();
      sb.append(" name= ").append(getName()).append(" status= ").append(getStatus());
      sb.append(" parentNode= ").append(getParentNode().getName());
      return sb.toString();
   }

}
