/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.util;

import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class MethodCallTest 
{
   Log log_ = LogFactory.getLog(MethodCallTest.class);


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log_.info("setUp() ....");
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
   }

//   public void testDummy() {}

   public void testBasic() throws Throwable
   {
      Integer i = 1;
      Method method = Foo.class.getDeclaredMethod("setFoo",
              new Class[]{Integer.class});

      Object[] args = new Object[]{i};
      Foo foo = new Foo();
      MethodCall mc = new MethodCall(method, args, foo);

      mc.invoke();
   }




   public static class Foo
   {
      Integer i;

      public void setFoo(Integer i)
      {
         this.i = i;
      }

      public Integer getFoo()
      {
         return i;
      }
   }
}
