/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.SortedEvictionQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSizeQueue
implements SortedEvictionQueue {
    private Map<Fqn, NodeEntry> nodeMap = new HashMap<Fqn, NodeEntry>();
    private LinkedList<NodeEntry> evictionList = new LinkedList();
    private Comparator<NodeEntry> comparator = new MaxElementComparator();
    private Set<NodeEntry> removalQueue = new HashSet<NodeEntry>();
    private int numElements = 0;

    protected ElementSizeQueue() {
    }

    @Override
    public void resortEvictionQueue() {
        Collections.sort(this.evictionList, this.comparator);
    }

    @Override
    public NodeEntry getFirstNodeEntry() {
        try {
            NodeEntry ne;
            while ((ne = this.evictionList.getFirst()) != null && this.removalQueue.contains(ne)) {
                this.evictionList.removeFirst();
                this.removalQueue.remove(ne);
            }
            return ne;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public NodeEntry getNodeEntry(Fqn fqn) {
        return this.nodeMap.get(fqn);
    }

    @Override
    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    @Override
    public boolean containsNodeEntry(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        return this.getNodeEntry(fqn) != null;
    }

    @Override
    public void removeNodeEntry(NodeEntry entry) {
        NodeEntry ne = this.nodeMap.remove(entry.getFqn());
        if (ne != null) {
            this.removalQueue.add(ne);
            this.numElements -= ne.getNumberOfElements();
        }
    }

    @Override
    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            Fqn fqn = entry.getFqn();
            entry.queue = this;
            this.nodeMap.put(fqn, entry);
            this.evictionList.add(entry);
            this.numElements += entry.getNumberOfElements();
        }
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodeMap.size();
    }

    @Override
    public int getNumberOfElements() {
        return this.numElements;
    }

    @Override
    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    @Override
    public void clear() {
        this.nodeMap.clear();
        this.evictionList.clear();
        this.removalQueue.clear();
        this.numElements = 0;
    }

    protected final List<NodeEntry> getEvictionList() {
        return this.evictionList;
    }

    protected final Set<NodeEntry> getRemovalQueue() {
        return this.removalQueue;
    }

    protected final void prune() {
        Iterator it = this.evictionList.iterator();
        while (it.hasNext() && this.removalQueue.size() > 0) {
            if (!this.removalQueue.remove(it.next())) continue;
            it.remove();
        }
    }

    @Override
    public Iterator<NodeEntry> iterate() {
        return this.evictionList.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MaxElementComparator
    implements Comparator<NodeEntry> {
        protected MaxElementComparator() {
        }

        @Override
        public int compare(NodeEntry ne1, NodeEntry ne2) {
            int neNumElements2;
            if (ne1.equals(ne2)) {
                return 0;
            }
            int neNumElements = ne1.getNumberOfElements();
            if (neNumElements > (neNumElements2 = ne2.getNumberOfElements())) {
                return -1;
            }
            if (neNumElements < neNumElements2) {
                return 1;
            }
            if (neNumElements == neNumElements2) {
                return 0;
            }
            throw new RuntimeException("Should never reach this condition");
        }
    }
}

