/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.eviction.EvictionPolicyConfigBase;
import org.jboss.cache.eviction.LRUPolicy;

public class LRUConfiguration
extends EvictionPolicyConfigBase {
    private static final long serialVersionUID = -3426716488271559729L;
    @Dynamic
    private int timeToLiveSeconds;
    @Dynamic
    private int maxAgeSeconds;

    public LRUConfiguration() {
        this.setTimeToLiveSeconds(-1);
    }

    protected void setEvictionPolicyClassName() {
        this.setEvictionPolicyClass(LRUPolicy.class.getName());
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public void setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.testImmutability("timeToLiveSeconds");
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public void setMaxAgeSeconds(int maxAgeSeconds) {
        this.testImmutability("maxAgeSeconds");
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public void validate() throws ConfigurationException {
        if (this.timeToLiveSeconds < 0) {
            throw new ConfigurationException("timeToLiveSeconds must be configured to a value greater than or equal to 0");
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("LRUConfiguration: timeToLiveSeconds = ").append(this.getTimeToLiveSeconds()).append(" maxAgeSeconds =");
        str.append(this.getMaxAgeSeconds()).append(" maxNodes =").append(this.getMaxNodes());
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LRUConfiguration && super.equals(obj)) {
            LRUConfiguration other = (LRUConfiguration)obj;
            return this.maxAgeSeconds == other.maxAgeSeconds && this.timeToLiveSeconds == other.timeToLiveSeconds;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxAgeSeconds;
        result = 31 * result + this.timeToLiveSeconds;
        return result;
    }

    public void reset() {
        super.reset();
        this.setTimeToLiveSeconds(-1);
    }

    public LRUConfiguration clone() throws CloneNotSupportedException {
        return (LRUConfiguration)super.clone();
    }
}

