/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.AbstractVisitor;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.ActivationInterceptorMBean;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivationInterceptor
extends CacheLoaderInterceptor
implements ActivationInterceptorMBean {
    protected TransactionManager txMgr = null;
    private long activations = 0L;
    ActivationModificationsBuilder builder;
    protected ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    protected static final Object NULL = new Object();

    public ActivationInterceptor() {
        this.isActivation = true;
        this.useCacheStore = false;
    }

    @Inject
    public void injectTransactionManager(TransactionManager txMgr) {
        this.txMgr = txMgr;
    }

    @Start
    public void createModificationsBuilder() {
        this.builder = new ActivationModificationsBuilder();
    }

    @Override
    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        Object returnValue = super.visitClearDataCommand(ctx, command);
        if (this.trace) {
            this.log.trace((Object)"This is a remove data operation; removing the data from the loader, no activation processing needed.");
        }
        this.loader.removeData(command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        Object returnValue = super.visitRemoveNodeCommand(ctx, command);
        if (this.trace) {
            this.log.trace((Object)"This is a remove operation; removing the node from the loader, no activation processing needed.");
        }
        this.loader.remove(command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        Object returnValue = super.visitGetChildrenNamesCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        Object returnValue = super.visitGetKeysCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        Object returnValue = super.visitGetNodeCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object returnValue = super.visitGetKeyValueCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = super.visitPutKeyValueCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        Object returnValue = super.visitPutDataMapCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        Object returnValue = super.visitRemoveKeyCommand(ctx, command);
        this.removeNodeFromCacheLoader(ctx, command.getFqn());
        return returnValue;
    }

    @Override
    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        Object returnValue = super.visitMoveCommand(ctx, command);
        if (this.trace) {
            this.log.trace((Object)"This is a move operation; removing the FROM node from the loader, no activation processing needed.");
        }
        this.loader.remove(command.getFqn());
        this.removeNodeFromCacheLoader(ctx, command.getFqn().getParent());
        this.removeNodeFromCacheLoader(ctx, command.getTo());
        return returnValue;
    }

    private void removeNodeFromCacheLoader(InvocationContext ctx, Fqn fqn) throws Throwable {
        NodeSPI n = this.dataContainer.peek(fqn, true, false);
        if (n != null && n.isDataLoaded() && this.loader.exists(fqn)) {
            if (!n.getChildrenDirect().isEmpty()) {
                boolean result = ActivationInterceptor.childrenLoaded(n);
                if (result) {
                    this.log.debug((Object)"children all initialized");
                    this.remove(fqn);
                }
            } else if (this.loaderNoChildren(fqn)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("no children " + n));
                }
                this.remove(fqn);
            }
        }
    }

    private static boolean childrenLoaded(NodeSPI<?, ?> node) {
        if (!node.isChildrenLoaded()) {
            return false;
        }
        for (NodeSPI<?, ?> child : node.getChildrenDirect()) {
            if (child.isDataLoaded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (this.inTransaction()) {
            this.prepareCacheLoader(ctx);
        }
        return retval;
    }

    private boolean inTransaction() throws SystemException {
        return this.txMgr != null && this.txMgr.getTransaction() != null;
    }

    @Override
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (this.inTransaction()) {
            this.prepareCacheLoader(ctx);
        }
        return retval;
    }

    private void remove(Fqn fqn) throws Exception {
        this.loader.remove(fqn);
        if (this.getStatisticsEnabled()) {
            ++this.activations;
        }
    }

    private boolean loaderNoChildren(Fqn fqn) {
        try {
            Set<?> childrenNames = this.loader.getChildrenNames(fqn);
            return childrenNames == null;
        }
        catch (Exception e) {
            this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
            return false;
        }
    }

    @Override
    public long getActivations() {
        return this.activations;
    }

    @Override
    public void resetStatistics() {
        super.resetStatistics();
        this.activations = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        Map<String, Object> retval = super.dumpStatistics();
        if (retval == null) {
            retval = new HashMap<String, Object>();
        }
        retval.put("Activations", this.activations);
        return retval;
    }

    private void prepareCacheLoader(InvocationContext ctx) throws Throwable {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        TransactionEntry entry = ctx.getTransactionEntry();
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        ArrayList<Modification> cacheLoaderModifications = new ArrayList<Modification>();
        this.builder.visitCollection(ctx, entry.getModifications());
        if (cacheLoaderModifications.size() > 0) {
            this.loader.prepare(gtx, cacheLoaderModifications, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ActivationModificationsBuilder
    extends AbstractVisitor {
        private List<Modification> cacheLoaderModifications = new ArrayList<Modification>();
        private int txActs = 0;

        @Override
        public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand removeNodeCommand) throws Throwable {
            Modification mod = new Modification(Modification.ModificationType.REMOVE_NODE, removeNodeCommand.getFqn());
            this.cacheLoaderModifications.add(mod);
            return null;
        }

        @Override
        public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
            Fqn fqn = command.getFqn();
            this.handlePutCommand(ctx, fqn);
            return null;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            Fqn fqn = command.getFqn();
            this.handlePutCommand(ctx, fqn);
            return null;
        }

        private void handlePutCommand(InvocationContext ctx, Fqn fqn) throws Exception {
            NodeSPI n;
            if (fqn != null && ActivationInterceptor.this.dataContainer.peek(fqn, false, false) != null && ActivationInterceptor.this.loader.exists(fqn) && (n = ActivationInterceptor.this.dataContainer.peek(fqn, true, false)) != null && n.isDataLoaded()) {
                boolean result = ActivationInterceptor.childrenLoaded(n);
                if (!n.getChildrenDirect().isEmpty() && result) {
                    this.addRemoveMod(ctx, this.cacheLoaderModifications, fqn, n.getDataDirect());
                    ++this.txActs;
                } else if (this.loaderNoChildren(fqn)) {
                    this.addRemoveMod(ctx, this.cacheLoaderModifications, fqn, n.getDataDirect());
                    ++this.txActs;
                }
            }
        }

        private boolean loaderNoChildren(Fqn fqn) throws Exception {
            return ActivationInterceptor.this.loader.getChildrenNames(fqn) != null;
        }

        private void addRemoveMod(InvocationContext ctx, List<Modification> l, Fqn fqn, Map data) {
            Modification mod = new Modification(Modification.ModificationType.REMOVE_NODE, fqn);
            l.add(mod);
            ActivationInterceptor.this.notifier.notifyNodeActivated(fqn, false, data, ctx);
        }

        public List<Modification> getCacheLoaderModifications() {
            return this.cacheLoaderModifications;
        }

        public int getTxActs() {
            return this.txActs;
        }
    }
}

