/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.ReversibleCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;

public class CallInterceptor
extends CommandInterceptor {
    private TransactionTable transactionTable;
    private boolean cacheLoadingEnabled;

    @Inject
    public void injectDependencies(TransactionTable transactionTable) {
        this.transactionTable = transactionTable;
    }

    @Start
    public void startInterceptor() {
        this.cacheLoadingEnabled = this.configuration.getCacheLoaderConfig() != null && this.configuration.getCacheLoaderConfig().getFirstCacheLoaderConfig() != null;
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace((Object)"Suppressing invocation of method handlePrepareCommand.");
        }
        return null;
    }

    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace((Object)"Suppressing invocation of method handleOptimisticPrepareCommand.");
        }
        return null;
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace((Object)"Suppressing invocation of method handleCommitCommand.");
        }
        return null;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace((Object)"Suppressing invocation of method handleRollbackCommand.");
        }
        return null;
    }

    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace((Object)("Executing command: " + command + "."));
        }
        return this.invokeCommand(ctx, command);
    }

    private Object invokeCommand(InvocationContext ctx, ReplicableCommand command) throws Throwable {
        Object retval;
        try {
            retval = command.perform(ctx);
        }
        catch (Throwable t) {
            Transaction tx = ctx.getTransaction();
            if (ctx.isValidTransaction()) {
                tx.setRollbackOnly();
            }
            throw t;
        }
        return retval;
    }

    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    private Object handleAlterCacheMethod(InvocationContext ctx, ReversibleCommand command) throws Throwable {
        Object result = this.invokeCommand(ctx, command);
        if (ctx.isValidTransaction() && !this.configuration.isNodeLockingOptimistic()) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            if (gtx == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("didn't find GlobalTransaction for " + ctx.getTransaction() + "; won't add modification to transaction list"));
                }
            } else {
                ctx.getTransactionEntry().addModification(command);
            }
        }
        return result;
    }
}

