/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlHelper {
    private static final Log log = LogFactory.getLog(XmlHelper.class);
    public static final String ROOT = "mbean";
    public static final String ATTR = "attribute";
    public static final String CONFIG_ATTR = "config";
    public static final String NAME = "name";

    public static String getTagContents(Element elem, String value, String elementName, String attributeName) {
        NodeList list = elem.getElementsByTagName(elementName);
        for (int s = 0; s < list.getLength(); ++s) {
            Element element;
            String name;
            Node node = list.item(s);
            if (node.getNodeType() != 1 || !(name = (element = (Element)node).getAttribute(attributeName)).equals(value)) continue;
            return XmlHelper.getElementContent(element, true);
        }
        return null;
    }

    public static String getAttributeValue(Element elem, String elementName, String attributeName) {
        NodeList list = elem.getElementsByTagName(elementName);
        for (int s = 0; s < list.getLength(); ++s) {
            Node node = list.item(s);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String value = element.getAttribute(attributeName);
            return value == null ? null : StringPropertyReplacer.replaceProperties((String)value);
        }
        return null;
    }

    public static Element getConfigSubElement(Element element) {
        return XmlHelper.getSubElement(element, CONFIG_ATTR);
    }

    public static Element getSubElement(Element element, String subElementName) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !subElementName.equals(((Element)node).getTagName())) continue;
            return (Element)node;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSubElement(): Does not exist for " + subElementName));
        }
        return null;
    }

    public static String getElementContent(Element element, boolean trim) {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            attributeText = attributeText + StringPropertyReplacer.replaceProperties((String)((Text)n).getData());
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        return attributeText;
    }

    public static String readStringContents(Element element, String elementName) {
        NodeList nodes = element.getElementsByTagName(elementName);
        if (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            Element ne = (Element)node;
            NodeList nl2 = ne.getChildNodes();
            Node node2 = nl2.item(0);
            if (node2 != null) {
                String value = node2.getNodeValue();
                if (value == null) {
                    return "";
                }
                return StringPropertyReplacer.replaceProperties((String)value.trim());
            }
            return "";
        }
        return "";
    }

    public static String escapeBackslashes(String value) {
        StringBuilder buf = new StringBuilder(value);
        for (int looper = 0; looper < buf.length(); ++looper) {
            char curr = buf.charAt(looper);
            char next = '\u0000';
            if (looper + 1 < buf.length()) {
                next = buf.charAt(looper + 1);
            }
            if (curr != '\\') continue;
            if (next != '\\') {
                buf.insert(looper, '\\');
            }
            ++looper;
        }
        return buf.toString();
    }

    public static Properties readPropertiesContents(Element element, String elementName) throws IOException {
        String stringContents = XmlHelper.readStringContents(element, elementName);
        if (stringContents == null) {
            return new Properties();
        }
        stringContents = XmlHelper.escapeBackslashes(stringContents);
        ByteArrayInputStream is = new ByteArrayInputStream(stringContents.trim().getBytes("ISO8859_1"));
        Properties properties = new Properties();
        properties.load(is);
        is.close();
        return properties;
    }

    public static boolean readBooleanContents(Element element, String elementName) {
        return XmlHelper.readBooleanContents(element, elementName, false);
    }

    public static boolean readBooleanContents(Element element, String elementName, boolean defaultValue) {
        String val = XmlHelper.readStringContents(element, elementName);
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false")) {
            return Boolean.valueOf(val);
        }
        return defaultValue;
    }

    public static Element stringToElement(String xml) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("utf8"));
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = builder.parse(bais);
        bais.close();
        return d.getDocumentElement();
    }

    public static Element getDocumentRoot(InputStream is) {
        try {
            InputSource xmlInp = new InputSource(is);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = docBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse(xmlInp);
            Element root = doc.getDocumentElement();
            root.normalize();
            return root;
        }
        catch (SAXParseException err) {
            log.error((Object)"Configurator SAXParse error", (Throwable)err);
        }
        catch (SAXException e) {
            log.error((Object)"Configurator SAX error", (Throwable)e);
        }
        catch (Exception pce) {
            log.error((Object)"Configurator general error", (Throwable)pce);
        }
        return null;
    }

    public static boolean readBooleanAttribute(Element elem, String elementName, String attributeName, boolean defaultValue) {
        String val = XmlHelper.getAttributeValue(elem, elementName, attributeName);
        if (val != null && (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false"))) {
            return Boolean.valueOf(val);
        }
        return defaultValue;
    }
}

