/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class BuddyGroupAssignmentTest
extends BuddyReplicationTestsBase {
    private Log log = LogFactory.getLog(BuddyGroupAssignmentTest.class);
    BuddyFqnTransformer fqnTransformer = new BuddyFqnTransformer();

    public void testSingleBuddy() throws Exception {
        this.log.debug((Object)"Running testSingleBuddy");
        this.caches = this.createCaches(3, false);
        System.out.println("*** Testing cache 0:");
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(1), true);
        System.out.println("*** Testing cache 1:");
        this.assertIsBuddy((Cache)this.caches.get(1), (Cache)this.caches.get(2), true);
        System.out.println("*** Testing cache 2:");
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(0), true);
        System.out.println("Cache 0 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(0))));
        System.out.println("Cache 1 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(1))));
        System.out.println("Cache 2 = " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(2))));
    }

    public void test2Buddies() throws Exception {
        this.log.debug((Object)"Running test2Buddies");
        this.caches = this.createCaches(2, 3, false);
        TestingUtil.blockUntilViewsReceived(5000L, this.caches.toArray(new Cache[0]));
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(1), false);
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(2), false);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((Cache)this.caches.get(1), (Cache)this.caches.get(2), false);
        this.assertIsBuddy((Cache)this.caches.get(1), (Cache)this.caches.get(0), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(1), false);
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(0), false);
    }

    public void testRemovalFromClusterSingleBuddy() throws Exception {
        this.log.debug((Object)"Running testRemovalFromClusterSingleBuddy");
        this.caches = this.createCaches(3, false);
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(1), true);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((Cache)this.caches.get(1), (Cache)this.caches.get(2), true);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(0), true);
        ((CacheSPI)this.caches.get(1)).stop();
        this.caches.set(1, null);
        TestingUtil.sleepThread(this.getSleepTimeout());
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(2), true);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(0), true);
        System.out.println("*** Completed successfully ***");
        this.assertNoLocks(this.caches);
    }

    public void testRemovalFromCluster2Buddies() throws Exception {
        this.log.debug((Object)"Running testRemovalFromCluster2Buddies");
        this.caches = this.createCaches(2, 4, false);
        this.assertNoLocks(this.caches);
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(1), false);
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(2), false);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((Cache)this.caches.get(1), (Cache)this.caches.get(2), false);
        this.assertIsBuddy((Cache)this.caches.get(1), (Cache)this.caches.get(3), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(3), false);
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(0), false);
        System.out.println("*** Testing cache 3");
        this.assertIsBuddy((Cache)this.caches.get(3), (Cache)this.caches.get(0), false);
        this.assertIsBuddy((Cache)this.caches.get(3), (Cache)this.caches.get(1), false);
        ((CacheSPI)this.caches.get(1)).stop();
        this.caches.set(1, null);
        TestingUtil.sleepThread(this.getSleepTimeout());
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(2), false);
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(3), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(3), false);
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(0), false);
        System.out.println("*** Testing cache 3");
        this.assertIsBuddy((Cache)this.caches.get(3), (Cache)this.caches.get(0), false);
        this.assertIsBuddy((Cache)this.caches.get(3), (Cache)this.caches.get(2), false);
        this.assertNoLocks(this.caches);
    }

    public void testAddingNewCaches() throws Exception {
        this.log.debug((Object)"Running testAddingNewCaches");
        this.caches = this.createCaches(2, false);
        ((CacheSPI)this.caches.get(0)).put("/cache0", (Object)"k", (Object)"v");
        ((CacheSPI)this.caches.get(1)).put("/cache1", (Object)"k", (Object)"v");
        System.out.println("*** Testing cache 0:");
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(1), true);
        System.out.println("*** Testing cache 1:");
        this.assertIsBuddy((Cache)this.caches.get(1), (Cache)this.caches.get(0), true);
        assert (((CacheSPI)this.caches.get(0)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) == null) : "Should not have backup region for self";
        assert (((CacheSPI)this.caches.get(0)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) == null) : "Should not have backup region for self";
        this.caches.add(this.createCache(1, null));
        TestingUtil.blockUntilViewsReceived(60000, this.caches);
        System.out.println("*** Testing cache 0:");
        this.assertIsBuddy((Cache)this.caches.get(0), (Cache)this.caches.get(1), true);
        System.out.println("*** Testing cache 1:");
        this.assertIsBuddy((Cache)this.caches.get(1), (Cache)this.caches.get(2), true);
        System.out.println("*** Testing cache 2:");
        this.assertIsBuddy((Cache)this.caches.get(2), (Cache)this.caches.get(0), true);
        System.out.println("0 Lock info: " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(0))));
        System.out.println("1 Lock info: " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(1))));
        System.out.println("2 Lock info: " + CachePrinter.printCacheLockingInfo((Cache)((Cache)this.caches.get(2))));
        assert (((CacheSPI)this.caches.get(0)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) == null) : "Should not have backup region for self";
        assert (((CacheSPI)this.caches.get(0)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) == null) : "Should have backup region for non-buddy";
        assert (((CacheSPI)this.caches.get(0)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(2)).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) == null) : "Should not have backup region for self";
        assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(2)).getLocalAddress()), false) == null) : "Should not have backup region for non-buddy";
        assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) == null) : "Should not have backup region for non-buddy";
        assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) != null) : "Should have backup region for buddy";
        assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(2)).getLocalAddress()), false) == null) : "Should not have backup region for self";
        assert (((CacheSPI)this.caches.get(2)).peek(Fqn.fromString((String)"/cache0"), false) == null) : "Unnecessary state should not have been transferred!";
        assert (((CacheSPI)this.caches.get(2)).peek(Fqn.fromString((String)"/cache1"), false) == null) : "Unnecessary state should not have been transferred!";
        assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(1)).getLocalAddress(), Fqn.fromString((String)"/cache1")), false) != null) : "Backup state should have transferred!";
    }
}

