/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import java.util.ArrayList;
import java.util.Collections;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.mock.MockNodesFixture;
import org.jboss.cache.mock.NodeSpiMock;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class GravitateDataCommandTest {
    GravitateDataCommand command;
    DataContainer containerMock;
    CacheSPI spiMock;
    IMocksControl control;
    Fqn fqn = Fqn.fromString((String)"/dummy");
    InvocationContext ctx;
    BuddyFqnTransformer fqnTransformer = new BuddyFqnTransformer();

    @BeforeMethod
    public void setUp() {
        this.control = EasyMock.createStrictControl();
        this.containerMock = (DataContainer)this.control.createMock(DataContainer.class);
        this.spiMock = (CacheSPI)this.control.createMock(CacheSPI.class);
        this.command = new GravitateDataCommand(this.fqn, true, (Address)new IpAddress());
        this.command.initialize(this.containerMock, this.spiMock, new BuddyFqnTransformer());
        this.ctx = new InvocationContext();
    }

    public void testNonexistentNode() {
        this.command.setSearchSubtrees(false);
        EasyMock.expect((Object)this.spiMock.getNode(this.fqn)).andReturn(null);
        this.control.replay();
        assert (GravitateResult.noDataFound().equals(this.command.perform(this.ctx)));
    }

    public void testExistentNodeInTheCache() {
        MockNodesFixture nodes = new MockNodesFixture();
        this.command.setSearchSubtrees(false);
        EasyMock.expect((Object)this.spiMock.getNode(this.fqn)).andReturn((Object)nodes.adfNode);
        ArrayList arrayList = new ArrayList();
        EasyMock.expect((Object)this.containerMock.buildNodeData(Collections.EMPTY_LIST, (NodeSPI)nodes.adfNode)).andReturn(arrayList);
        this.control.replay();
        GravitateResult result = (GravitateResult)this.command.perform(this.ctx);
        this.control.verify();
        assert (result != null);
        assert (result.getNodeData() == arrayList);
    }

    public void testNodeDoesExistsInBackupAndNoDead() {
        MockNodesFixture nodes = new MockNodesFixture();
        EasyMock.expect((Object)this.spiMock.getNode(this.fqn)).andReturn(null);
        EasyMock.expect((Object)this.containerMock.peek(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)).andReturn((Object)nodes.abNode);
        Fqn firstSearch = Fqn.fromString((String)(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN + "/c/dummy"));
        EasyMock.expect((Object)this.spiMock.getNode(firstSearch)).andReturn((Object)nodes.abcNode);
        ArrayList listReference = new ArrayList();
        EasyMock.expect((Object)this.containerMock.buildNodeData(Collections.EMPTY_LIST, (NodeSPI)nodes.abcNode)).andReturn(listReference);
        this.control.replay();
        GravitateResult result = (GravitateResult)this.command.perform(this.ctx);
        assert (result.getNodeData() == listReference);
        this.control.verify();
    }

    public void testNodeDoesNotExistsInBackupAndNoDead() {
        MockNodesFixture nodes = new MockNodesFixture();
        EasyMock.expect((Object)this.spiMock.getNode(this.fqn)).andReturn(null);
        EasyMock.expect((Object)this.containerMock.peek(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)).andReturn((Object)nodes.adfNode);
        this.control.checkOrder(false);
        Fqn firstSearch = Fqn.fromString((String)(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN + "/g/dummy"));
        EasyMock.expect((Object)this.spiMock.getNode(firstSearch)).andReturn(null);
        Fqn secondSearch = Fqn.fromString((String)(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN + "/h/dummy"));
        EasyMock.expect((Object)this.spiMock.getNode(secondSearch)).andReturn(null);
        this.control.checkOrder(true);
        this.control.replay();
        assert (GravitateResult.noDataFound().equals(this.command.perform(this.ctx)));
        this.control.verify();
    }

    public void testDeadBeackup() throws Exception {
        NodeSpiMock root = new NodeSpiMock(Fqn.ROOT);
        IpAddress firstAddress = new IpAddress("127.0.0.1", 1234);
        NodeSpiMock firstDeadNode = (NodeSpiMock)root.addChildDirect(this.fqnTransformer.getDeadBackupRoot((Address)firstAddress));
        firstDeadNode.addChildDirect(Fqn.fromElements((Object[])new Integer[]{0}));
        firstDeadNode.addChildDirect(Fqn.fromElements((Object[])new Integer[]{1}));
        firstDeadNode.addChildDirect(Fqn.fromElements((Object[])new Integer[]{2}));
        IpAddress secondAddress = new IpAddress("127.0.0.1", 4321);
        NodeSpiMock secondDeadNode = (NodeSpiMock)root.addChildDirect(this.fqnTransformer.getDeadBackupRoot((Address)secondAddress));
        secondDeadNode.addChildDirect(Fqn.fromElements((Object[])new Integer[]{0}));
        EasyMock.expect((Object)this.spiMock.getNode(this.fqn)).andReturn(null);
        NodeSPI buddyBackupRoot = (NodeSPI)root.getChild(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN);
        EasyMock.expect((Object)this.containerMock.peek(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)).andReturn((Object)buddyBackupRoot);
        this.control.checkOrder(false);
        EasyMock.expect((Object)this.spiMock.getChildrenNames(firstDeadNode.getFqn())).andReturn((Object)firstDeadNode.getChildrenNames());
        Object fqnElement = this.fqn.getLastElement();
        EasyMock.expect((Object)this.spiMock.peek(Fqn.fromRelativeElements((Fqn)firstDeadNode.getFqn(), (Object[])new Object[]{0, fqnElement}), false)).andReturn(null);
        EasyMock.expect((Object)this.spiMock.peek(Fqn.fromRelativeElements((Fqn)firstDeadNode.getFqn(), (Object[])new Object[]{1, fqnElement}), false)).andReturn(null);
        EasyMock.expect((Object)this.spiMock.peek(Fqn.fromRelativeElements((Fqn)firstDeadNode.getFqn(), (Object[])new Object[]{2, fqnElement}), false)).andReturn(null);
        EasyMock.expect((Object)this.spiMock.getChildrenNames(secondDeadNode.getFqn())).andReturn((Object)secondDeadNode.getChildrenNames());
        EasyMock.expect((Object)this.spiMock.peek(Fqn.fromRelativeElements((Fqn)secondDeadNode.getFqn(), (Object[])new Object[]{0, fqnElement}), false)).andReturn(null);
        this.control.checkOrder(true);
        this.control.replay();
        assert (GravitateResult.noDataFound().equals(this.command.perform(this.ctx)));
        this.control.verify();
    }
}

