/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.Calendar;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jboss.cache.lock.NonBlockingWriterLock;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false)
public class NonBlockingWriterLockTest {
    static final NonBlockingWriterLock lock_ = new NonBlockingWriterLock();
    static long SLEEP_MSECS = 500L;
    Vector<Object> lockResult = new Vector();
    int NO_MORE_OP = 0;
    int INVOKE_READ = 1;
    int INVOKE_WRITE = 2;
    int INVOKE_UPGRADE = 3;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        NonBlockingWriterLockTest.logX("\n");
        NonBlockingWriterLockTest.log("Setting up test case ...");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        NonBlockingWriterLockTest.log("Tearing down test case ...");
    }

    private static void log(String str) {
        System.out.println(Thread.currentThread() + ": " + Calendar.getInstance().getTime() + " : " + str);
    }

    private static void logX(String str) {
        NonBlockingWriterLockTest.log(str);
    }

    protected Thread readThread(final String caseNum, final String name, final long msecs, final long sleepSecs, final String errMsg, final int secondOP) {
        return new Thread(name){

            public void run() {
                Lock rlock = lock_.readLock();
                try {
                    if (!rlock.tryLock(msecs, TimeUnit.MILLISECONDS)) {
                        NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting read lock failed!\n");
                        String str = caseNum + "-" + name + "-RL-0";
                        NonBlockingWriterLockTest.this.postLockingResult(str);
                        return;
                    }
                    NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting read lock succeeded!\n");
                    String str = caseNum + "-" + name + "-RL-1";
                    NonBlockingWriterLockTest.this.postLockingResult(str);
                    TestingUtil.sleepThread(sleepSecs);
                    if (secondOP == NonBlockingWriterLockTest.this.INVOKE_READ) {
                        NonBlockingWriterLockTest.this.acquireReadLock(caseNum, name, msecs, errMsg);
                    } else if (secondOP == NonBlockingWriterLockTest.this.INVOKE_WRITE) {
                        NonBlockingWriterLockTest.this.acquireWriteLock(caseNum, name, msecs, errMsg);
                    } else if (secondOP == NonBlockingWriterLockTest.this.INVOKE_UPGRADE) {
                        NonBlockingWriterLockTest.this.acquireUpgradeLock(caseNum, name, msecs, errMsg);
                    }
                    rlock.unlock();
                    NonBlockingWriterLockTest.logX(caseNum + "-" + name + " releasing read lock.\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    protected Thread writeThread(final String caseNum, final String name, final long msecs, final long sleepSecs, final String errMsg, final int secondOP) {
        return new Thread(name){

            public void run() {
                try {
                    Lock wlock = lock_.writeLock();
                    if (!wlock.tryLock(msecs, TimeUnit.MILLISECONDS)) {
                        NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting write lock failed!\n");
                        String str = caseNum + "-" + name + "-WL-0";
                        NonBlockingWriterLockTest.this.postLockingResult(str);
                        return;
                    }
                    NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting write lock succeeded!\n");
                    String str = caseNum + "-" + name + "-WL-1";
                    NonBlockingWriterLockTest.this.postLockingResult(str);
                    TestingUtil.sleepThread(sleepSecs);
                    if (secondOP == NonBlockingWriterLockTest.this.INVOKE_READ) {
                        NonBlockingWriterLockTest.this.acquireReadLock(caseNum, name, msecs, errMsg);
                    } else if (secondOP == NonBlockingWriterLockTest.this.INVOKE_WRITE) {
                        NonBlockingWriterLockTest.this.acquireWriteLock(caseNum, name, msecs, errMsg);
                    } else if (secondOP == NonBlockingWriterLockTest.this.INVOKE_UPGRADE) {
                        NonBlockingWriterLockTest.this.acquireUpgradeLock(caseNum, name, msecs, errMsg);
                    }
                    wlock.unlock();
                    NonBlockingWriterLockTest.logX(caseNum + "-" + name + " releasing write lock.\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    protected Thread upgradeThread(final String caseNum, final String name, final long msecs, String errMsg) {
        return new Thread(name){

            public void run() {
                try {
                    Lock rlock = lock_.readLock();
                    Lock wlock = null;
                    if (!rlock.tryLock(msecs, TimeUnit.MILLISECONDS)) {
                        NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting read lock failed!\n");
                        String str = caseNum + "-" + name + "-RL-0";
                        NonBlockingWriterLockTest.this.postLockingResult(str);
                        return;
                    }
                    NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting read lock succeeded (upgrade later)!\n");
                    TestingUtil.sleepThread(SLEEP_MSECS / 2L);
                    String str = caseNum + "-" + name + "-UL-";
                    wlock = lock_.upgradeLockAttempt(msecs);
                    if (wlock == null) {
                        NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting upgrade lock failed!\n");
                        str = str + "0";
                    } else {
                        NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting upgrade lock succeeded!\n");
                        str = str + "1";
                    }
                    NonBlockingWriterLockTest.this.postLockingResult(str);
                    TestingUtil.sleepThread(SLEEP_MSECS);
                    if (wlock != null) {
                        wlock.unlock();
                        NonBlockingWriterLockTest.logX(caseNum + "-" + name + " releasing upgrade lock.\n");
                    }
                    rlock.unlock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    protected void acquireReadLock(String caseNum, String name, long msecs, String errMsg) {
        try {
            Lock rlock = lock_.readLock();
            if (!rlock.tryLock(msecs, TimeUnit.MILLISECONDS)) {
                NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting read lock failed!\n");
                String str = caseNum + "-" + name + "-RL-0";
                this.postLockingResult(str);
                return;
            }
            NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting read lock succeeded!\n");
            String str = caseNum + "-" + name + "-RL-1";
            this.postLockingResult(str);
            TestingUtil.sleepThread(SLEEP_MSECS);
            rlock.unlock();
            NonBlockingWriterLockTest.logX(caseNum + "-" + name + " releasing read lock.\n");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void acquireWriteLock(String caseNum, String name, long msecs, String errMsg) {
        try {
            Lock wlock = lock_.writeLock();
            if (!wlock.tryLock(msecs, TimeUnit.MILLISECONDS)) {
                NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting write lock failed!\n");
                String str = caseNum + "-" + name + "-WL-0";
                this.postLockingResult(str);
                return;
            }
            NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting write lock succeeded!\n");
            String str = caseNum + "-" + name + "-WL-1";
            this.postLockingResult(str);
            TestingUtil.sleepThread(SLEEP_MSECS);
            wlock.unlock();
            NonBlockingWriterLockTest.logX(caseNum + "-" + name + " releasing write lock.\n");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void acquireUpgradeLock(String caseNum, String name, long msecs, String errMsg) {
        try {
            Lock ulock = null;
            ulock = lock_.upgradeLockAttempt(msecs);
            if (ulock == null) {
                NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting upgrade lock failed!\n");
                String str = caseNum + "-" + name + "-UL-0";
                this.postLockingResult(str);
                return;
            }
            NonBlockingWriterLockTest.logX(caseNum + "-" + name + " requesting upgrade lock succeeded!\n");
            String str = caseNum + "-" + name + "-UL-1";
            this.postLockingResult(str);
            TestingUtil.sleepThread(SLEEP_MSECS);
            ulock.unlock();
            NonBlockingWriterLockTest.logX(caseNum + "-" + name + " releasing upgrade lock.\n");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected synchronized void cleanLockingResult() {
        this.lockResult.removeAllElements();
    }

    protected synchronized void postLockingResult(Object obj) {
        NonBlockingWriterLockTest.logX("  Added *" + obj + "* to the result vector\n");
        this.lockResult.addElement(obj);
    }

    protected synchronized boolean checkLockingResult(String expected) {
        boolean rc = false;
        for (int i = 0; i < this.lockResult.size(); ++i) {
            Object ele = this.lockResult.elementAt(i);
            String str = (String)ele;
            if (!expected.equals(str)) continue;
            rc = true;
            break;
        }
        if (rc) {
            NonBlockingWriterLockTest.logX("  Searching for *" + expected + "* SUCCEEDED.\n");
        } else {
            NonBlockingWriterLockTest.logX("  Searching for *" + expected + "* FAILED.\n");
        }
        return rc;
    }

    public void testWriteWithMultipleReaders() throws Exception {
        String caseNum = "10";
        Thread t1 = this.readThread(caseNum, "t1", 0L, SLEEP_MSECS * 2L, "1st read lock attempt failed", this.NO_MORE_OP);
        Thread t2 = this.readThread(caseNum, "t2", 0L, SLEEP_MSECS, "2nd read lock attempt failed", this.INVOKE_WRITE);
        t1.start();
        t2.start();
        t1.join(3000L);
        t2.join(3000L);
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-RL-1") && this.checkLockingResult(caseNum + "-t2-RL-1") && this.checkLockingResult(caseNum + "-t2-WL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
        if (t1.isAlive() || t2.isAlive()) {
            AssertJUnit.fail((String)"Possible deadlock resulted in testRead.");
        }
    }

    public void testUpgradeWithMultipleReadersOn1() throws Exception {
        String caseNum = "11";
        Thread t1 = this.readThread(caseNum, "t1", 0L, SLEEP_MSECS, "1st read lock attempt failed", this.INVOKE_WRITE);
        Thread t2 = this.readThread(caseNum, "t2", 0L, SLEEP_MSECS * 2L, "2nd read lock attempt failed", this.NO_MORE_OP);
        t1.start();
        t2.start();
        t1.join(3000L);
        t2.join(3000L);
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-RL-1") && this.checkLockingResult(caseNum + "-t2-RL-1") && this.checkLockingResult(caseNum + "-t1-WL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
        if (t1.isAlive() || t2.isAlive()) {
            AssertJUnit.fail((String)"Possible deadlock resulted in testRead.");
        }
    }

    public void testUpgradeReadLock() throws Exception {
        String caseNum = "2";
        Thread t1 = this.readThread(caseNum, "t1", 0L, SLEEP_MSECS, "1st read lock attempt failed", this.INVOKE_UPGRADE);
        t1.start();
        t1.join(3000L);
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-RL-1") && this.checkLockingResult(caseNum + "-t1-UL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
    }

    public void testReadThenWrite() throws Exception {
        String caseNum = "3";
        this.acquireReadLock(caseNum, "t1", 0L, "1st read lock attempt failed");
        this.acquireWriteLock(caseNum, "t1.1", 0L, "2nd write lock attempt failed");
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-RL-1") && this.checkLockingResult(caseNum + "-t1.1-WL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
    }

    public void testWriteThenRead() throws Exception {
        String caseNum = "5";
        this.acquireWriteLock(caseNum, "t1", 0L, "1st write lock attempt failed");
        this.acquireReadLock(caseNum, "t1.1", 0L, "2nd read lock attempt failed");
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-WL-1") && this.checkLockingResult(caseNum + "-t1.1-RL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
    }

    public void testMultipleReadlock() throws Exception {
        String caseNum = "6";
        Thread t1 = this.readThread(caseNum, "t1", 0L, SLEEP_MSECS, "1st read lock attempt failed", this.NO_MORE_OP);
        Thread t2 = this.readThread(caseNum, "t2", 0L, SLEEP_MSECS, "2nd read lock attempt failed", this.NO_MORE_OP);
        t1.start();
        t2.start();
        t1.join(3000L);
        t2.join(3000L);
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-RL-1") && this.checkLockingResult(caseNum + "-t2-RL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
        if (t1.isAlive() || t2.isAlive()) {
            AssertJUnit.fail((String)"Possible deadlock resulted in testRead.");
        }
    }

    public void testWriteWithExistingReader() throws Exception {
        String caseNum = "8";
        Thread t1 = this.readThread(caseNum, "t1", 0L, SLEEP_MSECS, "1st write lock attempt failed", this.NO_MORE_OP);
        Thread t2 = this.writeThread(caseNum, "t2", 0L, SLEEP_MSECS, "2nd read lock attempt failed", this.NO_MORE_OP);
        t1.start();
        t2.start();
        t1.join(3000L);
        t2.join(3000L);
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-RL-1") && this.checkLockingResult(caseNum + "-t2-WL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
        if (t1.isAlive() || t2.isAlive()) {
            AssertJUnit.fail((String)"Possible deadlock resulted in testRead.");
        }
    }

    public void testReadWithExistingWriter() throws Exception {
        String caseNum = "13";
        Thread t1 = this.writeThread(caseNum, "t1", 0L, SLEEP_MSECS, "1st write lock attempt failed", this.NO_MORE_OP);
        Thread t2 = this.readThread(caseNum, "t2", 0L, SLEEP_MSECS, "2nd read lock attempt failed", this.NO_MORE_OP);
        t1.start();
        t2.start();
        t1.join(3000L);
        t2.join(3000L);
        assert (this.checkLockingResult(caseNum + "-t1-WL-1"));
        assert (this.checkLockingResult(caseNum + "-t2-RL-0"));
        this.cleanLockingResult();
        if (t1.isAlive() || t2.isAlive()) {
            AssertJUnit.fail((String)"Possible deadlock resulted in testRead.");
        }
    }

    public void testMultipleWritelocks() throws Exception {
        String caseNum = "14";
        Thread t1 = this.writeThread(caseNum, "t1", 0L, SLEEP_MSECS, "1st write lock attempt failed", this.NO_MORE_OP);
        Thread t2 = this.writeThread(caseNum, "t2", 0L, SLEEP_MSECS, "2nd write lock attempt failed", this.NO_MORE_OP);
        t1.start();
        t2.start();
        t1.join(3000L);
        t2.join(3000L);
        assert (this.checkLockingResult(caseNum + "-t1-WL-1"));
        assert (this.checkLockingResult(caseNum + "-t2-WL-0"));
        this.cleanLockingResult();
        if (t1.isAlive() || t2.isAlive()) {
            AssertJUnit.fail((String)"Possible deadlock resulted in testRead.");
        }
    }

    public void testUpgradeWithExistingReader() throws Exception {
        String caseNum = "7";
        Thread t1 = this.readThread(caseNum, "t1", 0L, SLEEP_MSECS, "1st read lock attempt failed", this.NO_MORE_OP);
        Thread t2 = this.upgradeThread(caseNum, "t2", 0L, "2nd upgrade lock attempt failed");
        t1.start();
        t2.start();
        t1.join(3000L);
        t2.join(3000L);
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-RL-1") && this.checkLockingResult(caseNum + "-t2-UL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
        if (t1.isAlive() || t2.isAlive()) {
            AssertJUnit.fail((String)"Possible deadlock resulted in testRead.");
        }
    }

    public void testUpgradeWithMultipleReaders() throws Exception {
        String caseNum = "9";
        Thread t1 = this.readThread(caseNum, "t1", 0L, SLEEP_MSECS * 2L, "1st read lock attempt failed", this.NO_MORE_OP);
        Thread t2 = this.readThread(caseNum, "t2", 0L, SLEEP_MSECS, "2nd read lock attempt failed", this.INVOKE_UPGRADE);
        t1.start();
        t2.start();
        t1.join(3000L);
        t2.join(3000L);
        AssertJUnit.assertTrue((this.checkLockingResult(caseNum + "-t1-RL-1") && this.checkLockingResult(caseNum + "-t2-RL-1") && this.checkLockingResult(caseNum + "-t2-UL-1") ? 1 : 0) != 0);
        this.cleanLockingResult();
        if (t1.isAlive() || t2.isAlive()) {
            AssertJUnit.fail((String)"Possible deadlock resulted in testRead.");
        }
    }
}

