/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NodeInterceptorTransactionTest
extends AbstractOptimisticTestCase {
    public void testNoTransactionCRUDMethod() throws Exception {
        TestListener listener = new TestListener();
        CacheSPI<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        MockInterceptor dummy = new MockInterceptor();
        interceptor.setNext((CommandInterceptor)nodeInterceptor);
        nodeInterceptor.setNext((CommandInterceptor)dummy);
        TestingUtil.replaceInterceptorChain(cache, (CommandInterceptor)interceptor);
        try {
            cache.put("/one/two", (Object)"key1", new Object());
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        AssertJUnit.assertEquals(null, (Object)dummy.getCalledCommand());
        cache.stop();
    }

    public void testNoTransactionGetMethod() throws Exception {
        TestListener listener = new TestListener();
        CacheSPI<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        MockInterceptor dummy = new MockInterceptor();
        interceptor.setNext((CommandInterceptor)nodeInterceptor);
        nodeInterceptor.setNext((CommandInterceptor)dummy);
        TestingUtil.replaceInterceptorChain(cache, (CommandInterceptor)interceptor);
        boolean fail = false;
        try {
            AssertJUnit.assertEquals(null, (Object)cache.get("/one/two", (Object)"key1"));
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertTrue((boolean)fail);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalledCommand());
        cache.stop();
    }
}

