/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import java.io.NotSerializableException;
import java.io.Serializable;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ReplicationExceptionTest {
    private CacheSPI<String, ContainerData> cache1;
    private CacheSPI<String, ContainerData> cache2;
    String old_factory = null;
    final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.old_factory = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        DummyTransactionManager.destroy();
        this.destroyCaches();
        if (this.old_factory != null) {
            System.setProperty("java.naming.factory.initial", this.old_factory);
            this.old_factory = null;
        }
    }

    private TransactionManager beginTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }

    private void initCaches(Configuration.CacheMode caching_mode) {
        DefaultCacheFactory instance = new DefaultCacheFactory();
        this.cache1 = (CacheSPI)instance.createCache(false);
        this.cache2 = (CacheSPI)instance.createCache(false);
        this.cache1.getConfiguration().setCacheMode(caching_mode);
        this.cache2.getConfiguration().setCacheMode(caching_mode);
        this.cache1.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache2.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache1.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache1.getConfiguration().setLockAcquisitionTimeout(5000L);
        this.cache2.getConfiguration().setLockAcquisitionTimeout(5000L);
        this.cache1.start();
        this.cache2.start();
    }

    void destroyCaches() throws Exception {
        if (this.cache1 != null) {
            this.cache1.stop();
        }
        if (this.cache2 != null) {
            this.cache2.stop();
        }
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testNonSerializableRepl() throws Exception {
        try {
            this.initCaches(Configuration.CacheMode.REPL_SYNC);
            this.cache1.put("/a/b/c", (Object)"test", (Object)new ContainerData());
            AssertJUnit.assertNotNull((String)"NonSerializableData should not be null on cache2", (Object)this.cache2.get("/a/b/c", (Object)"test"));
        }
        catch (RuntimeException runtime) {
            Throwable t = runtime.getCause();
            if (t instanceof NotSerializableException) {
                System.out.println("received NotSerializableException - as expected");
            }
            throw runtime;
        }
    }

    public void testNonSerializableReplWithTx() throws Exception {
        try {
            this.initCaches(Configuration.CacheMode.REPL_SYNC);
            TransactionManager tm = this.beginTransaction();
            this.cache1.put("/a/b/c", (Object)"test", (Object)new ContainerData());
            tm.commit();
            AssertJUnit.assertNotNull((String)"NonSerializableData should not be null on cache2", (Object)this.cache2.get("/a/b/c", (Object)"test"));
        }
        catch (RollbackException rollback) {
            System.out.println("received RollbackException - as expected");
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    static class ContainerData
    implements Serializable {
        int i = 99;
        NonSerializabeData non_serializable_data = new NonSerializabeData();
        private static final long serialVersionUID = -8322197791060897247L;
    }

    static class NonSerializabeData {
        int i;

        NonSerializabeData() {
        }
    }
}

