/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.util.CachePrinter;
import org.jgroups.JChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestingUtil {
    private static Random random = new Random();

    public static Object extractField(Object target, String fieldName) {
        return TestingUtil.extractField(target.getClass(), target, fieldName);
    }

    public static void replaceField(Object newValue, String fieldName, Object owner, Class baseType) {
        try {
            Field field = baseType.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(owner, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object extractField(Class type, Object target, String fieldName) {
        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception e) {
            if (type.equals(Object.class)) {
                e.printStackTrace();
                return null;
            }
            return TestingUtil.extractField(type.getSuperclass(), target, fieldName);
        }
    }

    public static <T extends CommandInterceptor> T findInterceptor(CacheSPI<?, ?> cache, Class<T> interceptorToFind) {
        for (CommandInterceptor i : cache.getInterceptorChain()) {
            if (!interceptorToFind.isInstance(i)) continue;
            return (T)((CommandInterceptor)interceptorToFind.cast(i));
        }
        return null;
    }

    public static void injectInterceptor(CacheSPI<?, ?> cache, CommandInterceptor interceptorToInject, Class<? extends CommandInterceptor> interceptorAfterWhichToInject) {
        cache.addInterceptor(interceptorToInject, interceptorAfterWhichToInject);
    }

    public static void blockUntilViewsReceived(Cache[] caches, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static void blockUntilViewsReceived(long timeout, Cache ... caches) {
        TestingUtil.blockUntilViewsReceived(caches, timeout);
    }

    public static void blockUntilViewsReceived(CacheSPI[] caches, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static void blockUntilViewsReceived(long timeout, boolean barfIfTooManyMembers, Cache ... caches) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches, barfIfTooManyMembers)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static void blockUntilViewReceived(CacheSPI cache, int groupSize, long timeout) {
        TestingUtil.blockUntilViewReceived(cache, groupSize, timeout, true);
    }

    public static void blockUntilViewReceived(CacheSPI cache, int groupSize, long timeout, boolean barfIfTooManyMembersInView) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.isCacheViewComplete((Cache)cache, groupSize, barfIfTooManyMembersInView)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static boolean areCacheViewsComplete(Cache[] caches) {
        return TestingUtil.areCacheViewsComplete(caches, true);
    }

    public static boolean areCacheViewsComplete(Cache[] caches, boolean barfIfTooManyMembers) {
        int memberCount = caches.length;
        for (int i = 0; i < memberCount; ++i) {
            if (TestingUtil.isCacheViewComplete(caches[i], memberCount, barfIfTooManyMembers)) continue;
            return false;
        }
        return true;
    }

    public static boolean areCacheViewsComplete(CacheSPI[] caches) {
        if (caches == null) {
            throw new NullPointerException("Cache impl array is null");
        }
        Cache[] c = new Cache[caches.length];
        for (int i = 0; i < caches.length; ++i) {
            c[i] = caches[i];
        }
        return TestingUtil.areCacheViewsComplete(c);
    }

    public static boolean isCacheViewComplete(CacheSPI cache, int memberCount) {
        List members = cache.getRPCManager().getMembers();
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            StringBuilder sb = new StringBuilder("Cache at address ");
            sb.append(cache.getRPCManager().getLocalAddress());
            sb.append(" had ");
            sb.append(members.size());
            sb.append(" members; expecting ");
            sb.append(memberCount);
            sb.append(". Members were (");
            for (int j = 0; j < members.size(); ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(members.get(j));
            }
            sb.append(')');
            throw new IllegalStateException(sb.toString());
        }
        return true;
    }

    public static boolean isCacheViewComplete(Cache c, int memberCount) {
        return TestingUtil.isCacheViewComplete(c, memberCount, true);
    }

    public static boolean isCacheViewComplete(Cache c, int memberCount, boolean barfIfTooManyMembers) {
        CacheSPI cache = (CacheSPI)c;
        List members = cache.getMembers();
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            if (barfIfTooManyMembers) {
                StringBuilder sb = new StringBuilder("Cache at address ");
                sb.append(cache.getLocalAddress());
                sb.append(" had ");
                sb.append(members.size());
                sb.append(" members; expecting ");
                sb.append(memberCount);
                sb.append(". Members were (");
                for (int j = 0; j < members.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    sb.append(members.get(j));
                }
                sb.append(')');
                throw new IllegalStateException(sb.toString());
            }
            return false;
        }
        return true;
    }

    public static void sleepThread(long sleeptime) {
        try {
            Thread.sleep(sleeptime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepRandom(int maxTime) {
        TestingUtil.sleepThread(random.nextInt(maxTime));
    }

    public static void recursiveFileRemove(String directoryName) {
        File file = new File(directoryName);
        TestingUtil.recursiveFileRemove(file);
    }

    public static void recursiveFileRemove(File file) {
        if (file.exists()) {
            System.out.println("Deleting file " + file);
            TestingUtil.recursivedelete(file);
        }
    }

    private static void recursivedelete(File f) {
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                TestingUtil.recursivedelete(file);
            }
        }
        f.delete();
    }

    public static void killCaches(Cache ... caches) {
        for (Cache c : caches) {
            CacheLoaderManager clm;
            CacheLoader cl;
            if (c == null || c.getCacheStatus() != CacheStatus.STARTED) continue;
            CacheSPI spi = (CacheSPI)c;
            if (spi.getTransactionManager() != null) {
                try {
                    spi.getTransactionManager().rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            CacheLoader cacheLoader = cl = (clm = spi.getCacheLoaderManager()) == null ? null : clm.getCacheLoader();
            if (cl != null) {
                try {
                    cl.remove(Fqn.ROOT);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            spi.stop();
            spi.destroy();
        }
    }

    public static void killTransactions(Cache ... caches) {
        for (Cache c : caches) {
            CacheSPI ci;
            if (c == null || c.getCacheStatus() != CacheStatus.STARTED || (ci = (CacheSPI)c).getTransactionManager() == null) continue;
            try {
                ci.getTransactionManager().rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static ComponentRegistry extractComponentRegistry(Cache cache) {
        return (ComponentRegistry)TestingUtil.extractField(cache, "componentRegistry");
    }

    public static LockManager extractLockManager(Cache cache) {
        return (LockManager)TestingUtil.extractComponentRegistry(cache).getComponent(LockManager.class);
    }

    public static ComponentRegistry extractComponentRegistry(InterceptorChain ci) {
        return (ComponentRegistry)TestingUtil.extractField(ci, "componentRegistry");
    }

    public static void replaceInterceptorChain(CacheSPI<?, ?> cache, CommandInterceptor interceptor) {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache);
        CommandInterceptor i = interceptor;
        do {
            cr.wireDependencies((Object)i);
        } while ((i = i.getNext()) != null);
        InterceptorChain inch = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        inch.setFirstInChain(interceptor);
    }

    public static CacheInvocationDelegate getInvocationDelegate(CacheSPI cache) {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)cache);
        return (CacheInvocationDelegate)cr.getComponent(CacheInvocationDelegate.class);
    }

    public static void blockUntilCacheStatusAchieved(Cache cache, CacheStatus cacheStatus, long timeout) {
        CacheSPI spi = (CacheSPI)cache;
        long killTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < killTime) {
            if (spi.getCacheStatus() == cacheStatus) {
                return;
            }
            TestingUtil.sleepThread(50L);
        }
        throw new RuntimeException("Timed out waiting for condition");
    }

    public static void replicateCommand(CacheSPI cache, VisitableCommand command) throws Throwable {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)cache);
        InterceptorChain ic = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        ic.invoke(command);
    }

    public static void blockUntilViewsReceived(int timeout, List caches) {
        TestingUtil.blockUntilViewsReceived(caches.toArray(new Cache[0]), (long)timeout);
    }

    public static CommandsFactory extractCommandsFactory(CacheSPI<Object, Object> cache) {
        return (CommandsFactory)TestingUtil.extractField(cache, "commandsFactory");
    }

    public static String getJGroupsAttribute(Cache cache, String protocol, String attribute) {
        String s = ((JChannel)((CacheSPI)cache).getRPCManager().getChannel()).getProperties();
        String[] protocols = s.split(":");
        String attribs = null;
        for (String p : protocols) {
            boolean hasAttribs = p.contains("(");
            String name = hasAttribs ? p.substring(0, p.indexOf(40)) : p;
            String string = attribs = hasAttribs ? p.substring(p.indexOf(40) + 1, p.length() - 1) : null;
            if (name.equalsIgnoreCase(protocol)) break;
        }
        if (attribs != null) {
            String[] attrArray;
            for (String a : attrArray = attribs.split(";")) {
                String[] kvPairs = a.split("=");
                if (!kvPairs[0].equalsIgnoreCase(attribute)) continue;
                return kvPairs[1];
            }
        }
        return null;
    }

    public static void dumpCacheContents(List caches) {
        System.out.println("**** START: Cache Contents ****");
        int count = 1;
        for (Object o : caches) {
            CacheSPI c = (CacheSPI)o;
            if (c == null) {
                System.out.println("  ** Cache " + count + " is null!");
            } else {
                System.out.println("  ** Cache " + count + " is " + c.getLocalAddress());
                System.out.println("    " + CachePrinter.printCacheLockingInfo((Cache)c));
            }
            ++count;
        }
        System.out.println("**** END: Cache Contents ****");
    }

    public static void dumpCacheContents(Cache ... caches) {
        TestingUtil.dumpCacheContents(Arrays.asList(caches));
    }
}

