/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.collection.CollectionInterceptorUtil;
import org.jboss.cache.pojo.impl.AbstractHandler;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoUtil;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionClassHandler
extends AbstractHandler {
    private final Log log = LogFactory.getLog(CollectionClassHandler.class);
    private Cache<Object, Object> cache_;
    private PojoCacheImpl pCache_;
    private InternalHelper internal_;

    public CollectionClassHandler(PojoCacheImpl pCache, InternalHelper internal) {
        this.pCache_ = pCache;
        this.cache_ = this.pCache_.getCache();
        this.internal_ = internal;
    }

    @Override
    protected Fqn<?> getFqn(Object collection) {
        if (!(collection instanceof ClassProxy)) {
            return null;
        }
        AbstractCollectionInterceptor interceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)collection);
        return interceptor != null ? interceptor.getFqn() : null;
    }

    protected Object get(Fqn fqn, Class clazz, PojoInstance pojoInstance) throws CacheException {
        ClassProxy obj = null;
        try {
            if (Map.class.isAssignableFrom(clazz)) {
                Object map = clazz.newInstance();
                obj = CollectionInterceptorUtil.createMapProxy(this.pCache_, fqn, clazz, (Map)map);
            } else if (List.class.isAssignableFrom(clazz)) {
                Object list = clazz.newInstance();
                obj = CollectionInterceptorUtil.createListProxy(this.pCache_, fqn, clazz, (List)list);
            } else if (Set.class.isAssignableFrom(clazz)) {
                Object set = clazz.newInstance();
                obj = CollectionInterceptorUtil.createSetProxy(this.pCache_, fqn, clazz, (Set)set);
            }
        }
        catch (Exception e) {
            throw new CacheException("failure creating proxy", (Throwable)e);
        }
        return obj;
    }

    protected void put(Fqn fqn, Fqn referencingFqn, Object obj) throws CacheException {
        boolean isCollection = false;
        CachedType type = null;
        if (obj instanceof ClassProxy) {
            throw new IllegalStateException("CollectionClassHandler.put(): obj is an ClassProxy instance " + obj);
        }
        type = this.pCache_.getCachedType(obj.getClass());
        if (!(obj instanceof Map || obj instanceof List || obj instanceof Set)) {
            return;
        }
        PojoInstance pojoInstance = InternalHelper.initializeAopInstance(referencingFqn);
        pojoInstance.set(obj);
        pojoInstance.setPojoClass(type.getType());
        this.cache_.put(fqn, (Object)"POJOCache.PojoInstance", (Object)pojoInstance);
        if (obj instanceof Map) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("collectionPutObject(): aspectized obj is a Map type of size: " + ((Map)obj).size()));
            }
            Map map = (Map)obj;
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createMapProxy(this.pCache_, fqn, clazz, (Map)obj);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", (Throwable)e);
                }
                this.checkMapRecursion(map, obj);
            }
            isCollection = true;
            for (Map.Entry entry : map.entrySet()) {
                ((Map)obj).put(entry.getKey(), entry.getValue());
            }
        } else if (obj instanceof List) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("collectionPutObject(): aspectized obj is a List type of size: " + ((List)obj).size()));
            }
            List list = (List)obj;
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createListProxy(this.pCache_, fqn, clazz, (List)obj);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", (Throwable)e);
                }
                this.checkListRecursion(list, obj);
            }
            isCollection = true;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ((List)obj).add(i.next());
            }
        } else if (obj instanceof Set) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("collectionPutObject(): aspectized obj is a Set type of size: " + ((Set)obj).size()));
            }
            Set set = (Set)obj;
            if (!(obj instanceof ClassProxy)) {
                Class<?> clazz = obj.getClass();
                try {
                    obj = CollectionInterceptorUtil.createSetProxy(this.pCache_, fqn, clazz, (Set)obj);
                }
                catch (Exception e) {
                    throw new CacheException("failure creating proxy", (Throwable)e);
                }
                this.checkSetRecursion(set, obj);
            }
            isCollection = true;
            Iterator i = set.iterator();
            while (i.hasNext()) {
                ((Set)obj).add(i.next());
            }
        }
        if (isCollection) {
            pojoInstance.set(obj);
            AbstractCollectionInterceptor baseInterceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
            baseInterceptor.setAopInstance(pojoInstance);
        }
    }

    private void checkListRecursion(List list, Object obj) {
        int i;
        while ((i = list.indexOf(list)) != -1) {
            list.remove(list);
            list.add(i, obj);
        }
    }

    private void checkSetRecursion(Set set, Object obj) {
        if (set.remove(set)) {
            set.add(obj);
            throw new PojoCacheException("CollectionClassHandler.checkSetRecursion(): detect a recursive set (e.g., set inside the same set). This will fail to replicate even outside of PojoCache with HashSet. " + set);
        }
    }

    private void checkMapRecursion(Map map, Object obj) {
        Map m = Collections.unmodifiableMap(map);
        for (Object k : m.keySet()) {
            if (m == k) {
                throw new PojoCacheException("CollectionClassHandler.checkMapRecursion():  Can't handle the recursion map where it is nested in a constant key " + map);
            }
            Object v = m.get(k);
            if (v != map) continue;
            throw new PojoCacheException("CollectionClassHandler.checkMapRecursion(): detect a recursive map (e.g., map inside the same map). This will fail to replicate even outside of PojoCache with HashMap because of hashCode. " + map);
        }
    }

    @Override
    protected Object remove(Fqn<?> fqn, Fqn<?> referencingFqn, Object obj) throws CacheException {
        if (!(obj instanceof ClassProxy)) {
            throw new PojoCacheException("CollectionClassHandler.collectionRemoveObject(): object is not a proxy :" + obj);
        }
        AbstractCollectionInterceptor interceptor = CollectionInterceptorUtil.getInterceptor((ClassProxy)obj);
        new PojoUtil().detachCollectionInterceptor(interceptor);
        this.cache_.removeNode(fqn);
        return interceptor.getCurrentCopy();
    }

    @Override
    protected boolean handles(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }
}

