/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class DataContainerImpl
implements DataContainer {
    private static final Log log = LogFactory.getLog(DataContainerImpl.class);
    private static boolean trace = log.isTraceEnabled();
    private Configuration configuration;
    private NodeSPI root;
    private final Set<Fqn> internalFqns = new HashSet<Fqn>();
    private NodeFactory nodeFactory;
    private LockManager lockManager;
    private BuddyFqnTransformer buddyFqnTransformer;

    @Inject
    public void injectDependencies(Configuration configuration, NodeFactory nodeFactory, LockManager lockManager, BuddyFqnTransformer transformer) {
        this.setDependencies(configuration, nodeFactory, lockManager);
        this.createRootNode();
        this.buddyFqnTransformer = transformer;
    }

    public void setDependencies(Configuration configuration, NodeFactory nodeFactory, LockManager lockManager) {
        this.configuration = configuration;
        this.nodeFactory = nodeFactory;
        this.lockManager = lockManager;
    }

    @Start(priority=12)
    public void createRootNode() {
        if (trace) {
            log.trace((Object)"Starting data container");
        }
        NodeSPI tempRoot = this.nodeFactory.createRootDataNode();
        Class<?> currentRootType = this.root == null ? null : ((NodeInvocationDelegate)this.root).getDelegationTarget().getClass();
        Class<?> tempRootType = ((NodeInvocationDelegate)tempRoot).getDelegationTarget().getClass();
        if (!tempRootType.equals(currentRootType)) {
            if (trace) {
                log.trace((Object)("Setting root node to an instance of " + tempRootType));
            }
            this.setRoot(tempRoot);
        }
        this.root.setChildrenLoaded(true);
    }

    @Stop(priority=100)
    public void stop() {
        this.root.clearDataDirect();
        this.root.removeChildrenDirect();
    }

    @Override
    public NodeSPI getRoot() {
        return this.root;
    }

    public void setRoot(NodeSPI root) {
        if (root == null || !root.getFqn().isRoot()) {
            throw new CacheException("Attempting to set an invalid node [" + root + "] as a root node!");
        }
        this.root = root;
    }

    @Override
    public void registerInternalFqn(Fqn fqn) {
        this.internalFqns.add(fqn);
    }

    @Override
    public NodeSPI peek(Fqn fqn) {
        try {
            return this.peekVersioned(fqn, null);
        }
        catch (CacheException e) {
            log.warn((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    @Override
    public NodeSPI peekStrict(GlobalTransaction gtx, Fqn fqn, boolean includeInvalid) {
        NodeSPI n = this.peekVersioned(fqn, null, includeInvalid);
        if (n == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Node ").append(fqn).append(" not found");
            String errStr = builder.toString();
            if (trace) {
                log.trace((Object)errStr);
            }
            throw new NodeNotExistsException(errStr);
        }
        return n;
    }

    @Override
    public NodeSPI peekVersioned(Fqn fqn, DataVersion version) {
        return this.peekVersioned(fqn, version, false);
    }

    @Override
    public NodeSPI peekVersioned(Fqn fqn, DataVersion version, boolean includeInvalidNodes) {
        if (fqn == null) {
            return null;
        }
        NodeSPI toReturn = this.peek(fqn, false, includeInvalidNodes);
        if (toReturn != null && version != null && this.configuration.isNodeLockingOptimistic()) {
            DataVersion nodeVersion = toReturn.getVersion();
            if (trace) {
                log.trace((Object)("looking for optimistic node [" + fqn + "] with version [" + version + "].  My version is [" + nodeVersion + "]"));
            }
            if (nodeVersion.newerThan(version)) {
                throw new CacheException("Unable to validate versions.");
            }
        }
        return toReturn;
    }

    @Override
    public NodeSPI peek(Fqn<?> fqn, boolean includeDeletedNodes) {
        return this.peek(fqn, includeDeletedNodes, false);
    }

    @Override
    public NodeSPI peek(Fqn<?> fqn, boolean includeDeletedNodes, boolean includeInvalidNodes) {
        if (fqn == null || fqn.size() == 0) {
            return this.getRoot();
        }
        NodeSPI n = this.getRoot();
        int fqnSize = fqn.size();
        for (int i = 0; i < fqnSize; ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChildDirect(obj)) == null) {
                return null;
            }
            if (!includeDeletedNodes && n.isDeleted()) {
                return null;
            }
            if (includeInvalidNodes || n.isValid()) continue;
            return null;
        }
        return n;
    }

    @Override
    public boolean exists(Fqn fqn) {
        return this.peek(fqn, false, false) != null;
    }

    @Override
    public boolean hasChildren(Fqn fqn) {
        if (fqn == null) {
            return false;
        }
        NodeSPI n = this.peek(fqn);
        return n != null && n.hasChildrenDirect();
    }

    @Override
    public List<NodeData> buildNodeData(List<NodeData> list, NodeSPI node) {
        NodeData data = new NodeData(this.buddyFqnTransformer.getActualFqn(node.getFqn()), node.getDataDirect());
        list.add(data);
        for (NodeSPI childNode : node.getChildrenDirect()) {
            this.buildNodeData(list, childNode);
        }
        return list;
    }

    @Override
    public List<Fqn> getNodesForEviction(Fqn fqn, boolean recursive) {
        ArrayList<Fqn> result = new ArrayList<Fqn>();
        NodeSPI node = this.peek(fqn, false);
        if (recursive) {
            if (node != null) {
                this.recursiveAddEvictionNodes(node, result);
            }
        } else {
            if (node == null) {
                result.add(fqn);
                return result;
            }
            if (fqn.isRoot()) {
                for (Object childName : node.getChildrenNamesDirect()) {
                    if (node.isResident()) continue;
                    result.add(Fqn.fromRelativeElements(fqn, childName));
                }
            } else if (!node.isResident()) {
                result.add(fqn);
            }
        }
        return result;
    }

    private void recursiveAddEvictionNodes(NodeSPI<?, ?> node, List<Fqn> result) {
        for (NodeSPI<?, ?> child : node.getChildrenDirect()) {
            this.recursiveAddEvictionNodes(child, result);
        }
        Fqn fqn = node.getFqn();
        if (!fqn.isRoot() && !node.isResident()) {
            result.add(fqn);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public Set<Fqn> getInternalFqns() {
        return Collections.unmodifiableSet(this.internalFqns);
    }

    public String toString(boolean details) {
        StringBuilder sb = new StringBuilder();
        int indent = 0;
        if (!details) {
            sb.append(this.getClass().getName()).append(" [").append(this.getNumberOfNodes()).append(" nodes, ");
            sb.append(this.getNumberOfLocksHeld()).append(" locks]");
        } else {
            if (this.root == null) {
                return sb.toString();
            }
            for (NodeSPI n : this.root.getChildrenDirect()) {
                n.print(sb, indent);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public int getNumberOfLocksHeld() {
        return this.numLocks(this.root);
    }

    private int numLocks(NodeSPI n) {
        int num = 0;
        if (n != null) {
            if (this.lockManager.isLocked(n)) {
                ++num;
            }
            for (NodeSPI cn : n.getChildrenDirect(true)) {
                num += this.numLocks(cn);
            }
        }
        return num;
    }

    @Override
    public int getNumberOfNodes() {
        return this.numNodes(this.root) - 1;
    }

    private int numNodes(NodeSPI n) {
        int count = 1;
        if (n != null) {
            for (NodeSPI child : n.getChildrenDirect()) {
                count += this.numNodes(child);
            }
        }
        return count;
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        this.root.printDetails(sb, 0);
        sb.append("\n");
        return sb.toString();
    }

    public String printLockInfo() {
        return this.lockManager.printLockInfo(this.root);
    }

    @Override
    public int getNumberOfAttributes(Fqn fqn) {
        return this.numAttributes(this.peek(fqn));
    }

    private int numAttributes(NodeSPI n) {
        int count = 0;
        for (NodeSPI child : n.getChildrenDirect()) {
            count += this.numAttributes(child);
        }
        return count += n.getDataDirect().size();
    }

    @Override
    public int getNumberOfAttributes() {
        return this.numAttributes(this.root);
    }

    @Override
    public boolean removeFromDataStructure(Fqn f, boolean skipMarkerCheck) {
        NodeSPI n = this.peek(f, true);
        if (n == null) {
            return false;
        }
        if (trace) {
            log.trace((Object)("Performing a real remove for node " + f + ", marked for removal."));
        }
        if (skipMarkerCheck || n.isDeleted()) {
            if (n.getFqn().isRoot()) {
                n.markAsDeleted(true);
                n.setValid(false, true);
                n.setValid(true, false);
                n.removeChildrenDirect();
                return true;
            }
            n.setValid(false, true);
            return n.getParent().removeChildDirect(n.getFqn().getLastElement());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node " + f + " NOT marked for removal as expected, not removing!"));
        }
        return false;
    }

    @Override
    public void evict(Fqn fqn, boolean recursive) {
        List<Fqn> toEvict = this.getNodesForEviction(fqn, recursive);
        for (Fqn aFqn : toEvict) {
            this.evict(aFqn);
        }
    }

    @Override
    public boolean evict(Fqn fqn) {
        if (this.peek(fqn, false, true) == null) {
            return true;
        }
        if (this.hasChildren(fqn)) {
            if (trace) {
                log.trace((Object)("removing DATA as node has children: evict(" + fqn + ")"));
            }
            this.removeData(fqn);
            return false;
        }
        if (trace) {
            log.trace((Object)("removing NODE as it is a leaf: evict(" + fqn + ")"));
        }
        this.removeNode(fqn);
        return true;
    }

    private void removeNode(Fqn fqn) {
        NodeSPI targetNode = this.peekVersioned(fqn, null, true);
        if (targetNode == null) {
            return;
        }
        NodeSPI parentNode = targetNode.getParent();
        targetNode.setValid(false, false);
        if (parentNode != null) {
            parentNode.removeChildDirect(fqn.getLastElement());
            parentNode.setChildrenLoaded(false);
        }
    }

    protected void removeData(Fqn fqn) {
        NodeSPI n = this.peekVersioned(fqn, null);
        if (n == null) {
            log.warn((Object)("node " + fqn + " not found"));
            return;
        }
        n.clearDataDirect();
        n.setDataLoaded(false);
    }

    @Override
    public Object[] createNodes(Fqn fqn) {
        ArrayList result = new ArrayList(fqn.size());
        Fqn<Object> tmpFqn = Fqn.ROOT;
        int size = fqn.size();
        NodeSPI n = this.root;
        for (int i = 0; i < size; ++i) {
            NodeSPI childNode;
            Object childName = fqn.get(i);
            tmpFqn = Fqn.fromRelativeElements(tmpFqn, childName);
            Map children = n.getChildrenMapDirect();
            NodeSPI nodeSPI = childNode = children == null ? null : (NodeSPI)children.get(childName);
            if (childNode == null) {
                childNode = n.addChildDirect(Fqn.fromElements(childName));
                result.add(childNode);
            }
            n = childNode;
        }
        return new Object[]{result, n};
    }

    public void setBuddyFqnTransformer(BuddyFqnTransformer buddyFqnTransformer) {
        this.buddyFqnTransformer = buddyFqnTransformer;
    }
}

