/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.marshall.NodeData;
import org.jgroups.Address;

public class GravitateDataCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 35;
    private CacheSPI spi;
    private boolean searchSubtrees;
    private Address localAddress;
    private static final Log log = LogFactory.getLog(GravitateDataCommand.class);
    private static boolean trace = log.isTraceEnabled();
    private BuddyFqnTransformer buddyFqnTransformer;

    public GravitateDataCommand(Fqn fqn, boolean searchSubtrees, Address localAddress) {
        this.fqn = fqn;
        this.searchSubtrees = searchSubtrees;
        this.localAddress = localAddress;
    }

    public GravitateDataCommand(Address localAddress) {
        this.localAddress = localAddress;
    }

    public void initialize(DataContainer dataContainer, CacheSPI spi, BuddyFqnTransformer transformer) {
        this.dataContainer = dataContainer;
        this.spi = spi;
        this.buddyFqnTransformer = transformer;
    }

    public Object perform(InvocationContext ctx) {
        if (trace) {
            log.trace((Object)("Caller is asking for " + this.fqn));
        }
        try {
            Object backupSubtree;
            ctx.setOriginLocal(false);
            ctx.getOptionOverrides().setSkipDataGravitation(true);
            NodeSPI actualNode = this.spi.getNode(this.fqn);
            ctx.getOptionOverrides().setSkipDataGravitation(false);
            if (trace) {
                log.trace((Object)("In local tree, this is " + actualNode));
            }
            Fqn<Object> backupNodeFqn = null;
            if (actualNode == null && this.searchSubtrees) {
                Set<Object> allGroupNames;
                log.trace((Object)"Looking at backup trees.");
                backupSubtree = this.dataContainer.peek(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN);
                if (backupSubtree != null && (allGroupNames = backupSubtree.getChildrenNamesDirect()) != null) {
                    for (Object groupName : allGroupNames) {
                        Fqn<Object> backupRoot = Fqn.fromRelativeElements(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, groupName);
                        if (this.buddyFqnTransformer.isDeadBackupRoot(backupRoot)) {
                            TreeSet<Object> deadChildNames = new TreeSet<Object>(this.spi.getChildrenNames(backupRoot));
                            Integer[] elems = deadChildNames.toArray(new Integer[deadChildNames.size()]);
                            for (int i = elems.length - 1; i > -1; --i) {
                                Integer versionOfDefunctData = elems[i];
                                backupNodeFqn = Fqn.fromRelativeFqn(Fqn.fromRelativeElements(backupRoot, versionOfDefunctData), this.fqn);
                                ctx.getOptionOverrides().setSkipDataGravitation(true);
                                actualNode = this.spi.peek(backupNodeFqn, false);
                                ctx.getOptionOverrides().setSkipDataGravitation(false);
                                if (actualNode == null) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            backupNodeFqn = Fqn.fromRelativeFqn(backupRoot, this.fqn);
                            ctx.getOptionOverrides().setSkipDataGravitation(true);
                            actualNode = this.spi.getNode(backupNodeFqn);
                            ctx.getOptionOverrides().setSkipDataGravitation(false);
                        }
                        if (trace) {
                            log.trace((Object)("Looking for " + backupNodeFqn + ". Search result: " + actualNode));
                        }
                        if (actualNode == null) continue;
                        break;
                    }
                }
            }
            if (actualNode == null) {
                backupSubtree = GravitateResult.noDataFound();
                return backupSubtree;
            }
            actualNode.getData();
            if (backupNodeFqn == null && this.searchSubtrees) {
                backupNodeFqn = this.buddyFqnTransformer.getBackupFqn(this.buddyFqnTransformer.getGroupNameFromAddress(this.localAddress), this.fqn);
            }
            List<NodeData> list = this.dataContainer.buildNodeData(new LinkedList<NodeData>(), actualNode);
            GravitateResult gravitateResult = GravitateResult.subtreeResult(list, backupNodeFqn);
            return gravitateResult;
        }
        catch (RuntimeException re) {
            if (trace) {
                log.trace((Object)"Caught throwable", (Throwable)re);
            }
            throw re;
        }
        finally {
            ctx.setOriginLocal(true);
        }
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGravitateDataCommand(ctx, this);
    }

    public int getCommandId() {
        return 35;
    }

    public boolean isSearchSubtrees() {
        return this.searchSubtrees;
    }

    public Object[] getParameters() {
        return new Object[]{this.fqn, this.searchSubtrees};
    }

    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        this.searchSubtrees = (Boolean)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GravitateDataCommand that = (GravitateDataCommand)o;
        return this.searchSubtrees == that.searchSubtrees;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.searchSubtrees ? 1 : 0);
        return result;
    }

    public String toString() {
        return "GravitateDataCommand{fqn=" + this.fqn + ", searchSubtrees=" + this.searchSubtrees + '}';
    }

    void setSearchSubtrees(boolean searchSubtrees) {
        this.searchSubtrees = searchSubtrees;
    }
}

