/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class RemoveNodeCommand
extends AbstractVersionedDataCommand {
    public static final int METHOD_ID = 5;
    public static final int VERSIONED_METHOD_ID = 40;
    private static final Log log = LogFactory.getLog(RemoveNodeCommand.class);
    private static boolean trace = log.isTraceEnabled();
    private boolean skipSendingNodeEvents = false;
    protected Fqn parentFqn;
    protected NodeSPI targetNode;
    protected Map originalData;

    public RemoveNodeCommand(GlobalTransaction globalTransaction, Fqn fqn) {
        this.globalTransaction = globalTransaction;
        this.fqn = fqn;
    }

    public RemoveNodeCommand() {
    }

    public Object perform(InvocationContext ctx) {
        if (trace) {
            log.trace((Object)("perform(" + this.globalTransaction + ", \"" + this.fqn + ")"));
        }
        this.targetNode = this.dataContainer.peekVersioned(this.fqn, this.dataVersion, true);
        if (this.targetNode == null) {
            if (trace) {
                log.trace((Object)("node " + this.fqn + " not found"));
            }
            return false;
        }
        this.notifyBeforeRemove(this.targetNode, ctx);
        NodeSPI parentNode = this.targetNode.getParent();
        boolean found = this.targetNode.isValid() && !this.targetNode.isDeleted();
        this.targetNode.markAsDeleted(true, true);
        if (this.globalTransaction != null && found) {
            this.prepareForRollback(parentNode);
        }
        this.notifyAfterRemove(ctx);
        return found;
    }

    private void prepareForRollback(NodeSPI parentNode) {
        this.parentFqn = parentNode.getFqn();
        Map targetData = this.targetNode.getDataDirect();
        if (!targetData.isEmpty()) {
            this.originalData = new HashMap(this.targetNode.getDataDirect());
        }
    }

    private void notifyBeforeRemove(NodeSPI n, InvocationContext ctx) {
        if (!this.skipSendingNodeEvents) {
            this.notifier.notifyNodeRemoved(this.fqn, true, n.getDataDirect(), ctx);
        }
    }

    private void notifyAfterRemove(InvocationContext ctx) {
        if (!this.skipSendingNodeEvents) {
            this.notifier.notifyNodeRemoved(this.fqn, false, null, ctx);
        }
    }

    public void rollback() {
        if (this.targetNode != null) {
            Object childName = this.targetNode.getFqn().getLastElement();
            if (trace) {
                log.trace((Object)("rollback(parent: " + this.parentFqn + ", child: " + childName + ", node=" + this.targetNode + ")"));
            }
            if (this.parentFqn == null || childName == null) {
                log.error((Object)"parent fqn or childName or childNode was null");
                return;
            }
            NodeSPI parentNode = this.dataContainer.peek(this.parentFqn);
            if (parentNode == null) {
                log.warn((Object)("node " + this.parentFqn + " not found"));
                return;
            }
            parentNode.addChild(childName, this.targetNode);
            this.targetNode.markAsDeleted(false, true);
            this.targetNode.clearDataDirect();
            if (this.originalData != null) {
                this.targetNode.putAllDirect(this.originalData);
            }
            this.targetNode.setValid(true, true);
        }
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveNodeCommand(ctx, this);
    }

    public boolean isSkipSendingNodeEvents() {
        return this.skipSendingNodeEvents;
    }

    public int getCommandId() {
        return this.isVersioned() ? 40 : 5;
    }

    public Object[] getParameters() {
        if (this.isVersioned()) {
            return new Object[]{this.globalTransaction, this.fqn, true, this.skipSendingNodeEvents, this.dataVersion};
        }
        return new Object[]{this.globalTransaction, this.fqn, true, this.skipSendingNodeEvents};
    }

    public void setParameters(int commandId, Object[] args) {
        this.globalTransaction = (GlobalTransaction)args[0];
        this.fqn = (Fqn)args[1];
        this.skipSendingNodeEvents = (Boolean)args[3];
        if (this.isVersionedId(commandId)) {
            this.dataVersion = (DataVersion)args[4];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveNodeCommand that = (RemoveNodeCommand)o;
        if (this.skipSendingNodeEvents != that.skipSendingNodeEvents) {
            return false;
        }
        return !(this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 31 * result + (this.skipSendingNodeEvents ? 1 : 0);
        return result;
    }

    protected boolean isVersionedId(int id) {
        return id == 40;
    }

    public void setSkipSendingNodeEvents(boolean skipSendingNodeEvents) {
        this.skipSendingNodeEvents = skipSendingNodeEvents;
    }

    public String toString() {
        return "RemoveNodeCommand{fqn=" + this.fqn + ", dataVersion=" + this.dataVersion + ", globalTransaction=" + this.globalTransaction + ", skipSendingNodeEvents=" + this.skipSendingNodeEvents + ", parentFqn=" + this.parentFqn + ", targetNode=" + this.targetNode + '}';
    }
}

