/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.xml.XmlHelper;

public abstract class PluggableConfigurationComponent
extends ConfigurationComponent {
    protected String className;
    protected Properties properties;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        this.testImmutability("className");
        this.className = className;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.testImmutability("properties");
        this.properties = properties;
    }

    public void setProperties(String properties) throws IOException {
        if (properties == null) {
            return;
        }
        this.testImmutability("properties");
        properties = XmlHelper.escapeBackslashes(properties);
        ByteArrayInputStream is = new ByteArrayInputStream(properties.trim().getBytes("ISO8859_1"));
        this.properties = new Properties();
        this.properties.load(is);
        is.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluggableConfigurationComponent that = (PluggableConfigurationComponent)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {className = " + this.className + ", properties=" + this.properties + "}";
    }

    public PluggableConfigurationComponent clone() throws CloneNotSupportedException {
        PluggableConfigurationComponent clone = (PluggableConfigurationComponent)super.clone();
        if (this.properties != null) {
            clone.properties = (Properties)this.properties.clone();
        }
        return clone;
    }
}

