/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Region;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvictionTimerTask {
    private Log log = LogFactory.getLog(EvictionTimerTask.class);
    private final Set<Region> processedRegions = Collections.synchronizedSet(new HashSet());
    private static AtomicInteger tcount = new AtomicInteger();
    private int wakeupIntervalSeconds;
    private Timer evictionThread;

    public void init(int wakeupIntervalSeconds) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating a new eviction listener with wakeupIntervalSeconds set at " + wakeupIntervalSeconds));
        }
        this.wakeupIntervalSeconds = wakeupIntervalSeconds;
        this.start();
    }

    public void addRegionToProcess(Region region) {
        this.processedRegions.add(region);
    }

    public void removeRegionToProcess(Region region) {
        this.processedRegions.remove(region);
    }

    public boolean isRegionRegisteredForProcessing(Region region) {
        return this.processedRegions.contains(region);
    }

    public Set<Region> getProcessedRegions() {
        return this.processedRegions;
    }

    public void stop() {
        this.log.debug((Object)"Stopping eviction timer");
        if (this.evictionThread != null) {
            this.evictionThread.cancel();
        }
        this.evictionThread = null;
    }

    private void start() {
        this.evictionThread = new Timer("EvictionTimer-" + tcount.getAndIncrement(), true);
        TimerTask tt = new TimerTask(){

            public void run() {
                EvictionTimerTask.this.processRegions();
            }
        };
        this.evictionThread.schedule(tt, this.wakeupIntervalSeconds * 1000, (long)(this.wakeupIntervalSeconds * 1000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRegions() {
        Set<Region> set = this.processedRegions;
        synchronized (set) {
            for (Region region : this.processedRegions) {
                this.handleRegion(region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegion(Region region) {
        Region region2 = region;
        synchronized (region2) {
            EvictionPolicy policy = region.getEvictionPolicy();
            EvictionAlgorithm algo = policy.getEvictionAlgorithm();
            if (algo == null) {
                throw new NullPointerException("algorithm null");
            }
            try {
                algo.process(region);
            }
            catch (EvictionException e) {
                this.log.error((Object)("run(): error processing eviction with exception: " + e.toString() + " will reset the eviction queue list."));
                region.resetEvictionQueues();
                this.log.debug((Object)"trace", (Throwable)e);
            }
        }
    }
}

