/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.interceptors.ActivationInterceptor;
import org.jboss.cache.interceptors.BuddyRegionAwareEvictionInterceptor;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.DataGravitatorInterceptor;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.interceptors.InvalidationInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.MarshalledValueInterceptor;
import org.jboss.cache.interceptors.NotificationInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticReplicationInterceptor;
import org.jboss.cache.interceptors.OptimisticTxInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.interceptors.PassivationInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.ReplicationInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={InterceptorChain.class})
public class InterceptorChainFactory
extends ComponentFactory {
    @Deprecated
    public static InterceptorChainFactory getInstance() {
        return new InterceptorChainFactory();
    }

    private CommandInterceptor createInterceptor(Class<? extends CommandInterceptor> clazz) throws IllegalAccessException, InstantiationException {
        CommandInterceptor chainedInterceptor = this.componentRegistry.getComponent(clazz);
        if (chainedInterceptor == null) {
            chainedInterceptor = clazz.newInstance();
            this.componentRegistry.registerComponent(chainedInterceptor, clazz);
        } else {
            chainedInterceptor.setNext(null);
        }
        chainedInterceptor.setStatisticsEnabled(this.configuration.getExposeManagementStatistics());
        return chainedInterceptor;
    }

    public InterceptorChain buildInterceptorChain() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        boolean optimistic = this.configuration.isNodeLockingOptimistic();
        CommandInterceptor first = this.createInterceptor(InvocationContextInterceptor.class);
        InterceptorChain interceptorChain = new InterceptorChain(first);
        this.componentRegistry.registerComponent(interceptorChain, InterceptorChain.class);
        if (this.configuration.getExposeManagementStatistics()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(CacheMgmtInterceptor.class));
        }
        interceptorChain.appendIntereceptor(this.createInterceptor(optimistic ? OptimisticTxInterceptor.class : TxInterceptor.class));
        if (this.configuration.isUseLazyDeserialization()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(MarshalledValueInterceptor.class));
        }
        interceptorChain.appendIntereceptor(this.createInterceptor(NotificationInterceptor.class));
        switch (this.configuration.getCacheMode()) {
            case REPL_SYNC: 
            case REPL_ASYNC: {
                interceptorChain.appendIntereceptor(optimistic ? this.createInterceptor(OptimisticReplicationInterceptor.class) : this.createInterceptor(ReplicationInterceptor.class));
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                interceptorChain.appendIntereceptor(this.createInterceptor(InvalidationInterceptor.class));
                break;
            }
        }
        if (!optimistic) {
            interceptorChain.appendIntereceptor(this.createInterceptor(PessimisticLockInterceptor.class));
        }
        if (this.configuration.isUsingCacheLoaders()) {
            if (this.configuration.getCacheLoaderConfig().isPassivation()) {
                interceptorChain.appendIntereceptor(this.createInterceptor(ActivationInterceptor.class));
                interceptorChain.appendIntereceptor(this.createInterceptor(PassivationInterceptor.class));
            } else {
                interceptorChain.appendIntereceptor(this.createInterceptor(CacheLoaderInterceptor.class));
                interceptorChain.appendIntereceptor(this.createInterceptor(CacheStoreInterceptor.class));
            }
        }
        if (this.configuration.isUsingBuddyReplication()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(DataGravitatorInterceptor.class));
        }
        if (optimistic) {
            interceptorChain.appendIntereceptor(this.createInterceptor(OptimisticLockingInterceptor.class));
            interceptorChain.appendIntereceptor(this.createInterceptor(OptimisticValidatorInterceptor.class));
            interceptorChain.appendIntereceptor(this.createInterceptor(OptimisticCreateIfNotExistsInterceptor.class));
        }
        if (this.configuration.getEvictionConfig() != null && this.configuration.getEvictionConfig().isValidConfig()) {
            interceptorChain.appendIntereceptor(this.createInterceptor(this.configuration.isUsingBuddyReplication() ? BuddyRegionAwareEvictionInterceptor.class : EvictionInterceptor.class));
        }
        if (optimistic) {
            interceptorChain.appendIntereceptor(this.createInterceptor(OptimisticNodeInterceptor.class));
        }
        CommandInterceptor callInterceptor = this.createInterceptor(CallInterceptor.class);
        interceptorChain.appendIntereceptor(callInterceptor);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Finished building interceptor chain.");
        }
        return interceptorChain;
    }

    @Override
    protected <T> T construct(Class<T> componentType) {
        try {
            return (T)this.buildInterceptorChain();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build interceptor chain", e);
        }
    }

    public static InterceptorChainFactory getInstance(ComponentRegistry componentRegistry, Configuration configuration) {
        InterceptorChainFactory icf = new InterceptorChainFactory();
        icf.componentRegistry = componentRegistry;
        icf.configuration = configuration;
        return icf;
    }
}

