/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.DataContainer;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.CacheMgmtInterceptorMBean;
import org.jboss.cache.interceptors.base.CommandInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMgmtInterceptor
extends CommandInterceptor
implements CacheMgmtInterceptorMBean {
    private long m_hit_times = 0L;
    private long m_miss_times = 0L;
    private long m_store_times = 0L;
    private long m_hits = 0L;
    private long m_misses = 0L;
    private long m_stores = 0L;
    private long m_evictions = 0L;
    private long m_start;
    private long m_reset = this.m_start = System.currentTimeMillis();
    private DataContainer dataContainer;

    @Inject
    public void setDependencies(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public Object visitEvictFqnCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        ++this.m_evictions;
        return returnValue;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        if (retval == null) {
            this.m_miss_times += t2 - t1;
            ++this.m_misses;
        } else {
            this.m_hit_times += t2 - t1;
            ++this.m_hits;
        }
        return retval;
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        Map data = command.getData();
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        if (data != null && data.size() > 0) {
            this.m_store_times += t2 - t1;
            this.m_stores += (long)data.size();
        }
        return retval;
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        this.m_store_times += t2 - t1;
        ++this.m_stores;
        return retval;
    }

    @Override
    public long getHits() {
        return this.m_hits;
    }

    @Override
    public long getMisses() {
        return this.m_misses;
    }

    @Override
    public long getStores() {
        return this.m_stores;
    }

    @Override
    public long getEvictions() {
        return this.m_evictions;
    }

    @Override
    public double getHitMissRatio() {
        double total = this.m_hits + this.m_misses;
        if (total == 0.0) {
            return 0.0;
        }
        return (double)this.m_hits / total;
    }

    @Override
    public double getReadWriteRatio() {
        if (this.m_stores == 0L) {
            return 0.0;
        }
        return (double)(this.m_hits + this.m_misses) / (double)this.m_stores;
    }

    @Override
    public long getAverageReadTime() {
        long total = this.m_hits + this.m_misses;
        if (total == 0L) {
            return 0L;
        }
        return (this.m_hit_times + this.m_miss_times) / total;
    }

    @Override
    public long getAverageWriteTime() {
        if (this.m_stores == 0L) {
            return 0L;
        }
        return this.m_store_times / this.m_stores;
    }

    @Override
    public int getNumberOfAttributes() {
        return this.dataContainer.getNumberOfAttributes();
    }

    @Override
    public int getNumberOfNodes() {
        return this.dataContainer.getNumberOfNodes();
    }

    @Override
    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.m_start) / 1000L;
    }

    @Override
    public long getTimeSinceReset() {
        return (System.currentTimeMillis() - this.m_reset) / 1000L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Hits", this.m_hits);
        retval.put("Misses", this.m_misses);
        retval.put("Stores", this.m_stores);
        retval.put("Evictions", this.m_evictions);
        retval.put("NumberOfAttributes", this.dataContainer.getNumberOfAttributes());
        retval.put("NumberOfNodes", this.dataContainer.getNumberOfNodes());
        retval.put("ElapsedTime", this.getElapsedTime());
        retval.put("TimeSinceReset", this.getTimeSinceReset());
        retval.put("AverageReadTime", this.getAverageReadTime());
        retval.put("AverageWriteTime", this.getAverageWriteTime());
        retval.put("HitMissRatio", this.getHitMissRatio());
        retval.put("ReadWriteRatio", this.getReadWriteRatio());
        return retval;
    }

    @Override
    public void resetStatistics() {
        this.m_hits = 0L;
        this.m_misses = 0L;
        this.m_stores = 0L;
        this.m_evictions = 0L;
        this.m_hit_times = 0L;
        this.m_miss_times = 0L;
        this.m_store_times = 0L;
        this.m_reset = System.currentTimeMillis();
    }
}

