/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors.base;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.AbstractVisitor;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.InterceptorMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandInterceptor
extends AbstractVisitor
implements InterceptorMBean {
    private boolean statsEnabled = false;
    private CommandInterceptor next;
    protected Log log = LogFactory.getLog(this.getClass());
    protected boolean trace = this.log.isTraceEnabled();
    protected Configuration configuration;

    @Inject
    private void injectConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Start
    private void checkStatisticsUsed() {
        this.setStatisticsEnabled(this.configuration.getExposeManagementStatistics());
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        return Collections.emptyMap();
    }

    @Override
    public void resetStatistics() {
    }

    public CommandInterceptor getNext() {
        return this.next;
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public void setNext(CommandInterceptor next) {
        this.next = next;
    }

    public Object invokeNextInterceptor(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return command.acceptVisitor(ctx, this.next);
    }

    @Override
    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }
}

