/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RegionEmptyException;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.InactiveRegionException;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.statetransfer.StateTransferFactory;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.statetransfer.StateTransferIntegrator;

@NonVolatile
public class StateTransferManager {
    protected static final Log log = LogFactory.getLog(StateTransferManager.class);
    public static final NodeData STREAMING_DELIMITER_NODE = new NodeDataMarker();
    public static final String PARTIAL_STATE_DELIMITER = "_PARTIAL_STATE_DELIMITER";
    private CacheSPI cache;
    private Marshaller marshaller;
    private RegionManager regionManager;
    private Configuration configuration;
    private LockManager lockManager;

    public StateTransferManager() {
    }

    @Inject
    public void injectDependencies(CacheSPI cache, Marshaller marshaller, RegionManager regionManager, Configuration configuration, LockManager lockManager) {
        this.cache = cache;
        this.regionManager = regionManager;
        this.marshaller = marshaller;
        this.configuration = configuration;
        this.lockManager = lockManager;
    }

    public StateTransferManager(CacheSPI cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getState(ObjectOutputStream out, Fqn fqn, long timeout, boolean force, boolean suppressErrors) throws Throwable {
        boolean fetchPersistentState;
        boolean canProvideState = !this.regionManager.isInactive(fqn) && this.cache.peek(fqn, false) != null;
        boolean fetchTransientState = this.configuration.isFetchInMemoryState();
        CacheLoaderManager cacheLoaderManager = this.cache.getCacheLoaderManager();
        boolean bl = fetchPersistentState = cacheLoaderManager != null && cacheLoaderManager.isFetchPersistentState();
        if (canProvideState && (fetchPersistentState || fetchTransientState)) {
            this.marshaller.objectToObjectStream(true, out);
            StateTransferGenerator generator = this.getStateTransferGenerator();
            Object owner = this.getOwnerForLock();
            long startTime = System.currentTimeMillis();
            NodeSPI rootNode = this.cache.peek(fqn, false, false);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("locking the " + fqn + " subtree to return the in-memory (transient) state"));
                }
                this.acquireLocksForStateTransfer(rootNode, owner, timeout, true, force);
                generator.generateState(out, rootNode, fetchTransientState, fetchPersistentState, suppressErrors);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Successfully generated state in " + (System.currentTimeMillis() - startTime) + " msec"));
                return;
            }
            finally {
                this.releaseStateTransferLocks(rootNode, owner, true);
            }
        } else {
            this.marshaller.objectToObjectStream(false, out);
            CacheException e = null;
            if (!canProvideState) {
                String exceptionMessage = "Cache instance at " + this.cache.getLocalAddress() + " cannot provide state for fqn " + fqn + ".";
                if (this.regionManager.isInactive(fqn)) {
                    exceptionMessage = exceptionMessage + " Region for fqn " + fqn + " is inactive.";
                    e = new InactiveRegionException(exceptionMessage);
                }
                if (this.cache.peek(fqn, false, false) == null) {
                    e = new RegionEmptyException();
                }
            }
            if (!fetchPersistentState && !fetchTransientState) {
                e = new CacheException("Cache instance at " + this.cache.getLocalAddress() + " is not configured to provide state");
            }
            this.marshaller.objectToObjectStream(e, out);
            if (e == null) return;
            throw e;
        }
    }

    public void setState(ObjectInputStream in, Fqn targetRoot) throws Exception {
        Object o;
        Boolean hasState;
        NodeSPI target = this.cache.peek(targetRoot, false, false);
        if (target == null) {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
            this.cache.put(targetRoot, null);
            target = this.cache.peek(targetRoot, false, false);
        }
        if (!(hasState = (Boolean)(o = this.marshaller.objectFromObjectStream(in))).booleanValue()) {
            throw new CacheException("Cache instance at " + this.cache.getLocalAddress() + " cannot integrate state since state provider could not provide state due to " + this.marshaller.objectFromObjectStream(in));
        }
        this.setState(in, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ObjectInputStream state, NodeSPI targetRoot) throws Exception {
        Object owner = this.getOwnerForLock();
        long timeout = this.configuration.getStateRetrievalTimeout();
        long startTime = System.currentTimeMillis();
        try {
            this.acquireLocksForStateTransfer(targetRoot, owner, timeout, true, true);
            StateTransferIntegrator integrator = this.getStateTransferIntegrator(state, targetRoot.getFqn());
            if (log.isDebugEnabled()) {
                log.debug((Object)("starting state integration at node " + targetRoot));
            }
            integrator.integrateState(state, targetRoot);
            if (log.isDebugEnabled()) {
                log.debug((Object)("successfully integrated state in " + (System.currentTimeMillis() - startTime) + " msec"));
            }
        }
        finally {
            this.releaseStateTransferLocks(targetRoot, owner, true);
        }
    }

    protected void acquireLocksForStateTransfer(NodeSPI root, Object lockOwner, long timeout, boolean lockChildren, boolean force) throws Exception {
        try {
            if (lockChildren) {
                this.lockManager.lockAll(root, LockType.READ, lockOwner, timeout, true);
            } else {
                this.lockManager.lock(Fqn.ROOT, LockType.READ, lockOwner, timeout);
            }
        }
        catch (TimeoutException te) {
            log.error((Object)("Caught TimeoutException acquiring locks on region " + root.getFqn()), (Throwable)te);
            if (force) {
                throw te;
            }
            throw te;
        }
    }

    protected void releaseStateTransferLocks(NodeSPI root, Object lockOwner, boolean childrenLocked) {
        try {
            if (childrenLocked) {
                this.lockManager.unlockAll(root, lockOwner);
            } else {
                this.lockManager.unlock(Fqn.ROOT, lockOwner);
            }
        }
        catch (Throwable t) {
            log.error((Object)"failed releasing locks", t);
        }
    }

    protected StateTransferGenerator getStateTransferGenerator() {
        return StateTransferFactory.getStateTransferGenerator(this.cache);
    }

    protected StateTransferIntegrator getStateTransferIntegrator(ObjectInputStream istream, Fqn fqn) throws Exception {
        return StateTransferFactory.getStateTransferIntegrator(istream, fqn, this.cache);
    }

    private Object getOwnerForLock() {
        Object owner = this.cache.getCurrentTransaction();
        if (owner == null) {
            owner = Thread.currentThread();
        }
        return owner;
    }
}

