/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.GeneratedInstanceAdvisorMixin;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.joinpoint.ConstructionInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

public class GeneratedAdvisorInterceptor
implements Interceptor {
    private static final Logger logger = AOPLogger.getLogger(GeneratedAdvisorInterceptor.class);
    private static final Interceptor EMPTY_INTERCEPTOR = new Interceptor(){

        public Object invoke(Invocation invocation) throws Throwable {
            return invocation.invokeNext();
        }

        public String getName() {
            return "NULL";
        }
    };
    private InterceptorFactory factory;
    private volatile Object instance;
    private String cflowString;
    private ASTCFlowExpression cflowExpression;
    volatile Interceptor lazyInterceptor;
    String adviceString;

    public GeneratedAdvisorInterceptor(InterceptorFactory factory, GeneratedClassAdvisor advisor, Joinpoint joinpoint, String cflowString, ASTCFlowExpression cflowExpr) {
        this(factory, advisor, joinpoint);
        this.cflowString = cflowString;
        this.cflowExpression = cflowExpr;
    }

    public GeneratedAdvisorInterceptor(InterceptorFactory factory, GeneratedClassAdvisor advisor, Joinpoint joinpoint) {
        this.factory = factory;
        if (!(factory instanceof GenericInterceptorFactory)) {
            if (this.getScope() == Scope.PER_INSTANCE) {
                if (!advisor.getPerInstanceAspectDefinitions().contains(factory.getAspect())) {
                    advisor.addPerInstanceAspect(factory.getAspect());
                }
            } else if (this.getScope() == Scope.PER_JOINPOINT) {
                advisor.addPerInstanceJoinpointAspect(joinpoint, factory.getAspect());
            } else if (this.getScope() == Scope.PER_CLASS_JOINPOINT && advisor.getPerClassJoinpointAspect(factory.getAspect(), joinpoint) == null) {
                advisor.addPerClassJoinpointAspect(factory.getAspect(), joinpoint);
            }
        }
    }

    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        return this.factory.create(advisor, joinpoint);
    }

    public Object getAspect(Advisor advisor, Joinpoint joinpoint) {
        return this.getAspect(advisor, joinpoint, false);
    }

    public Object getAspect(Advisor advisor, Joinpoint joinpoint, boolean forCodeGeneration) {
        if (this.factory instanceof GenericInterceptorFactory) {
            if (this.instance == null) {
                this.instance = ((GenericInterceptorFactory)this.factory).create(advisor, joinpoint);
            }
            return this.instance;
        }
        if (this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return ((GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)this.factory).create(advisor, joinpoint);
        }
        if (this.factory instanceof ScopedInterceptorFactory || this.factory instanceof AdviceFactory) {
            ClassInstanceAdvisor temp = forCodeGeneration ? new ClassInstanceAdvisor(advisor) : null;
            return this.getAspectInstance(this.factory.getAspect(), advisor, joinpoint, temp);
        }
        return null;
    }

    public Object getPerInstanceAspect(Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia) {
        if (this.factory instanceof GenericInterceptorFactory) {
            if (this.instance == null) {
                this.instance = ((GenericInterceptorFactory)this.factory).create(advisor, joinpoint);
            }
            return this.instance;
        }
        if (this.factory instanceof ScopedInterceptorFactory || this.factory instanceof AdviceFactory) {
            return this.getAspectInstance(this.factory.getAspect(), advisor, joinpoint, ia);
        }
        return null;
    }

    private Object getAspectInstance(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia) {
        Scope scope = def.getScope();
        if (scope == Scope.PER_VM) {
            if (this.instance == null) {
                this.instance = advisor.getPerVMAspect(def);
            }
            if (this.instance == null || this.instance == EMPTY_INTERCEPTOR) {
                this.instance = EMPTY_INTERCEPTOR;
                return null;
            }
            return this.instance;
        }
        if (scope == Scope.PER_CLASS) {
            if (this.instance == null) {
                this.instance = advisor.getPerClassAspect(def);
                if (this.instance != null) {
                    return this.instance;
                }
                advisor.addPerClassAspect(def);
                this.instance = advisor.getPerClassAspect(def);
            }
            if (this.instance == null || this.instance == EMPTY_INTERCEPTOR) {
                this.instance = EMPTY_INTERCEPTOR;
                return null;
            }
            return this.instance;
        }
        if (scope == Scope.PER_INSTANCE) {
            return this.getPerInstanceAspect(def, advisor, joinpoint, ia);
        }
        if (scope == Scope.PER_JOINPOINT) {
            return this.getPerJoinPointAspect(def, advisor, joinpoint, ia);
        }
        if (scope == Scope.PER_CLASS_JOINPOINT) {
            if (this.instance == null) {
                this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
                if (this.instance != null) {
                    return this.instance;
                }
                ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(def, joinpoint);
                this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
                if (this.instance == null) {
                    this.instance = EMPTY_INTERCEPTOR;
                }
            }
            if (this.instance == EMPTY_INTERCEPTOR) {
                return null;
            }
            return this.instance;
        }
        return null;
    }

    private Object getPerJoinPointAspect(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia) {
        if (ia == null) {
            if (this.instance == null) {
                Field field;
                if (AspectManager.verbose && logger.isDebugEnabled()) {
                    logger.debug((Object)"Calling create on PER_JOINPOINT scoped AspectFactory with no InstanceAdvisor as part of setup");
                }
                if (joinpoint instanceof FieldJoinpoint && Modifier.isStatic((field = ((FieldJoinpoint)joinpoint).getField()).getModifiers())) {
                    this.instance = ((ClassAdvisor)advisor).getFieldAspect((FieldJoinpoint)joinpoint, def);
                }
                if (this.instance == null) {
                    this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
                    if (this.instance != null) {
                        return this.instance;
                    }
                    ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(def, joinpoint);
                    this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
                }
            }
            if (this.instance == null || this.instance == EMPTY_INTERCEPTOR) {
                this.instance = EMPTY_INTERCEPTOR;
                return null;
            }
            return this.instance;
        }
        return ia.getPerInstanceJoinpointAspect(joinpoint, def);
    }

    private Object getPerInstanceAspect(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia) {
        if (ia == null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)"Calling create on PER_INSTANCE scoped AspectFactory with no InstanceAdvisor as part of setup");
            }
            return def.getFactory().createPerInstance(advisor, ia);
        }
        return ia.getPerInstanceAspect(def);
    }

    public boolean isAspectFactory() {
        if (this.factory instanceof GenericInterceptorFactory || this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return false;
        }
        return !(this.factory.getAspect().getFactory() instanceof GenericAspectFactory);
    }

    public InterceptorFactory getDelegate() {
        return this.factory;
    }

    public AspectDefinition getAspect() {
        return this.factory.getAspect();
    }

    public String getName() {
        return this.factory.getName();
    }

    public String getAspectClassName() {
        if (this.factory instanceof GenericInterceptorFactory) {
            return ((GenericInterceptorFactory)this.factory).getClassName();
        }
        if (this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return ((GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)this.factory).getClassName();
        }
        AspectFactory af = this.factory.getAspect().getFactory();
        return af.getName();
    }

    public AdviceType getType() {
        return this.factory.getType();
    }

    public boolean isInterceptor() {
        return !(this.factory instanceof AdviceFactory);
    }

    public String getAdviceName() {
        if (this.factory instanceof AdviceFactory) {
            return ((AdviceFactory)this.factory).getAdvice();
        }
        return "invoke";
    }

    public Scope getScope() {
        if (this.factory instanceof GenericInterceptorFactory || this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return null;
        }
        return this.factory.getAspect().getScope();
    }

    public String getRegisteredName() {
        if (this.factory instanceof GenericInterceptorFactory || this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return null;
        }
        return this.factory.getAspect().getName();
    }

    public ASTCFlowExpression getCflowExpression() {
        return this.cflowExpression;
    }

    public String getCFlowString() {
        return this.cflowString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeneratedAdvisorInterceptor)) {
            return false;
        }
        return this.factory.equals(((GeneratedAdvisorInterceptor)obj).getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        if (this.lazyInterceptor == null) {
            GeneratedAdvisorInterceptor generatedAdvisorInterceptor = this;
            synchronized (generatedAdvisorInterceptor) {
                if (this.lazyInterceptor == null) {
                    if (this.factory.getType().isGeneratedOnly()) {
                        this.lazyInterceptor = new GeneratedOnlyInterceptor(this.factory.getName(), this.factory);
                    } else {
                        this.lazyInterceptor = this.create(invocation.getAdvisor(), this.getJoinpoint(invocation));
                        if (this.lazyInterceptor == null) {
                            this.lazyInterceptor = EMPTY_INTERCEPTOR;
                        }
                    }
                }
            }
        }
        return this.lazyInterceptor.invoke(invocation);
    }

    private Joinpoint getJoinpoint(Invocation invocation) {
        if (invocation instanceof MethodInvocation) {
            return new MethodJoinpoint(((MethodInvocation)invocation).getMethod());
        }
        if (invocation instanceof FieldInvocation) {
            return new FieldJoinpoint(((FieldInvocation)invocation).getField());
        }
        if (invocation instanceof ConstructorInvocation) {
            return new ConstructorJoinpoint(((ConstructorInvocation)invocation).getConstructor());
        }
        if (invocation instanceof ConstructionInvocation) {
            return new ConstructorJoinpoint(((ConstructionInvocation)invocation).getConstructor());
        }
        if (invocation instanceof MethodCalledByMethodInvocation) {
            return new MethodCalledByMethodJoinpoint(((MethodCalledByMethodInvocation)invocation).getCallingMethod(), ((MethodCalledByMethodInvocation)invocation).getCalledMethod());
        }
        if (invocation instanceof MethodCalledByConstructorInvocation) {
            return new MethodCalledByConstructorJoinpoint(((MethodCalledByConstructorInvocation)invocation).getCalling(), ((MethodCalledByConstructorInvocation)invocation).getCalledMethod());
        }
        if (invocation instanceof ConstructorCalledByMethodInvocation) {
            return new ConstructorCalledByMethodJoinpoint(((ConstructorCalledByMethodInvocation)invocation).getCallingMethod(), ((ConstructorCalledByMethodInvocation)invocation).getCalledConstructor());
        }
        if (invocation instanceof ConstructorCalledByConstructorInvocation) {
            return new ConstructorCalledByConstructorJoinpoint(((ConstructorCalledByConstructorInvocation)invocation).getCallingConstructor(), ((ConstructorCalledByConstructorInvocation)invocation).getCalledConstructor());
        }
        throw new RuntimeException("Invocation type not handled " + invocation);
    }

    public String getAdviceString() {
        if (this.adviceString == null) {
            StringBuffer buf = new StringBuffer();
            switch (this.getType()) {
                case AROUND: {
                    buf.append("R");
                    break;
                }
                case BEFORE: {
                    buf.append("B");
                    break;
                }
                case AFTER: {
                    buf.append("A");
                    break;
                }
                case THROWING: {
                    buf.append("T");
                    break;
                }
                case FINALLY: {
                    buf.append("F");
                    break;
                }
                default: {
                    throw new RuntimeException("No such interceptor");
                }
            }
            buf.append((Object)this.getScope());
            buf.append("~#$%");
            buf.append(this.getAspectClassName());
            buf.append("->");
            buf.append(this.getAdviceName());
            this.adviceString = buf.toString();
        }
        return this.adviceString;
    }

    private class GeneratedOnlyInterceptor
    implements Interceptor {
        String name;

        GeneratedOnlyInterceptor(String name, InterceptorFactory factory) {
            this.name = name;
            logger.warn((Object)(factory.getType().getName() + " interceptor:s'" + name + "' is ignored for dynamic invocation. Adding null GeneratedOnlyInterceptor in its place"));
        }

        public String getName() {
            return this.name;
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return invocation.invokeNext();
        }
    }
}

