/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.lang.reflect.Array;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.collection.CachedObjectArray;
import org.jboss.cache.pojo.collection.CachedPrimitiveArray;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.PojoCacheImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedArray {
    private static final String LENGTH = "ARRAY.LENGTH";
    protected PojoCacheImpl cache;
    protected Fqn<?> fqn;
    private int length = -1;
    private Class<?> type;

    public static CachedArray load(Fqn<?> fqn, PojoCacheImpl cache, Class<?> type) {
        boolean primitive = CachedType.isImmediate(type.getComponentType());
        CachedArray array = primitive ? new CachedPrimitiveArray(fqn, type, cache) : new CachedObjectArray(fqn, type, cache);
        return array;
    }

    public static CachedArray create(Fqn<?> fqn, PojoCacheImpl cache, Object originalArray) {
        Class<?> type = originalArray.getClass();
        assert (type.isArray());
        Class<?> component = type.getComponentType();
        boolean primitive = CachedType.isImmediate(component);
        CachedArray array = primitive ? new CachedPrimitiveArray(fqn, type, cache) : new CachedObjectArray(fqn, type, cache);
        int length = Array.getLength(originalArray);
        for (int c = 0; c < length; ++c) {
            array.set(c, Array.get(originalArray, c));
        }
        array.length = length;
        array.writeInfo();
        return array;
    }

    protected CachedArray(Fqn<?> fqn, Class<?> type, PojoCacheImpl cache) {
        this.fqn = fqn;
        this.type = type;
        this.cache = cache;
    }

    public Fqn<?> getFqn() {
        return this.fqn;
    }

    public abstract void set(int var1, Object var2);

    public abstract Object get(int var1);

    protected void writeInfo() {
        this.cache.getCache().put(this.fqn, (Object)LENGTH, (Object)this.length);
    }

    public void destroy() {
        this.cache.getCache().removeNode(this.fqn);
        this.length = -1;
    }

    public int length() {
        if (this.length == -1) {
            Integer i = (Integer)this.cache.getCache().get(this.fqn, (Object)LENGTH);
            this.length = i != null ? i : 0;
        }
        return this.length;
    }

    public Object toArray() {
        try {
            int len = this.length();
            Object array = Array.newInstance(this.type.getComponentType(), len);
            for (int i = 0; i < len; ++i) {
                Array.set(array, i, this.get(i));
            }
            return array;
        }
        catch (Exception e) {
            throw new CacheException("Could not construct array " + this.type);
        }
    }
}

