/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.pojo.Reference;
import org.jboss.cache.pojo.impl.AbstractHandler;
import org.jboss.cache.pojo.impl.AdvisedPojoHandler;
import org.jboss.cache.pojo.impl.ArrayHandler;
import org.jboss.cache.pojo.impl.ArrayInterceptable;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.CollectionClassHandler;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.ObjectGraphHandler;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoReference;
import org.jboss.cache.pojo.impl.PojoUtil;
import org.jboss.cache.pojo.impl.ReferenceImpl;
import org.jboss.cache.pojo.impl.SerializableObjectHandler;
import org.jboss.cache.pojo.util.AopUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoCacheDelegate {
    private PojoCacheImpl pojoCache;
    private Cache<Object, Object> cache;
    private static final Log log = LogFactory.getLog(PojoCacheDelegate.class);
    private InternalHelper internal_;
    private AdvisedPojoHandler advisedHandler_;
    private ObjectGraphHandler graphHandler_;
    private CollectionClassHandler collectionHandler_;
    private ArrayHandler arrayHandler;
    private SerializableObjectHandler serializableHandler_;
    private PojoUtil util_ = new PojoUtil();

    public PojoCacheDelegate(PojoCacheImpl cache) {
        this.pojoCache = cache;
        this.cache = this.pojoCache.getCache();
        this.internal_ = new InternalHelper(cache);
        this.graphHandler_ = new ObjectGraphHandler(this.pojoCache, this.internal_);
        this.collectionHandler_ = new CollectionClassHandler(this.pojoCache, this.internal_);
        this.serializableHandler_ = new SerializableObjectHandler(this.pojoCache, this.internal_);
        this.advisedHandler_ = new AdvisedPojoHandler(this.pojoCache, this.internal_, this.util_);
        this.arrayHandler = new ArrayHandler(this.pojoCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Fqn fqn, String field, Object source) throws CacheException {
        Object pojo = this.internal_.getPojo(fqn, field);
        if (pojo != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getObject(): id: " + fqn + " retrieved from existing instance directly. "));
            }
            return pojo;
        }
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        try {
            Region region = this.cache.getRegion(fqn, false);
            if (region != null && region.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(region.getClassLoader());
            }
            Object object = this.getObjectInternal(fqn, field, source);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCL);
        }
    }

    public Object putObject(Fqn fqn, Object obj, String field, Object source) throws CacheException {
        this.internal_.lockPojo(fqn);
        Object oldValue = this.internal_.getPojo(fqn, field);
        boolean allowArray = source instanceof ArrayInterceptable;
        if (oldValue == obj && this.skipDuplicateAttach(obj, allowArray)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("putObject(): id: " + fqn + " pojo is already in the cache. Return right away."));
            }
            return obj;
        }
        this.pojoCache.detach(fqn, field, source);
        if (obj == null) {
            return oldValue;
        }
        AbstractHandler handler = this.getHandler(obj.getClass(), allowArray);
        Fqn internalFqn = handler.getFqn(obj);
        ReferenceImpl reference = new ReferenceImpl(fqn, field);
        if (internalFqn != null) {
            this.internal_.lockPojo(internalFqn);
            this.graphHandler_.put(internalFqn, reference, obj);
        } else {
            internalFqn = this.createInternalFqn(fqn, obj);
            if (log.isDebugEnabled()) {
                log.debug((Object)("attach(): id: " + fqn + " will store the pojo in the internal area: " + internalFqn));
            }
            handler.put(internalFqn, reference, obj);
            this.cache.put(internalFqn, (Object)"POJOCache.Status", (Object)"ATTACHED");
        }
        this.setPojoReference(fqn, obj, field, internalFqn);
        return oldValue;
    }

    private boolean skipDuplicateAttach(Object obj, boolean allowArray) {
        return obj == null || this.getHandler(obj.getClass(), allowArray) != this.serializableHandler_;
    }

    private AbstractHandler getHandler(Class<?> clazz, boolean allowArray) {
        if (this.advisedHandler_.handles(clazz)) {
            return this.advisedHandler_;
        }
        if (this.collectionHandler_.handles(clazz)) {
            return this.collectionHandler_;
        }
        if (allowArray && this.arrayHandler.handles(clazz)) {
            return this.arrayHandler;
        }
        if (this.serializableHandler_.handles(clazz)) {
            return this.serializableHandler_;
        }
        throw new CacheException("Can not manage object. It must be either instrumented, a collection, an array, or Serializable: " + clazz.getName());
    }

    private Fqn createInternalFqn(Fqn fqn, Object obj) throws CacheException {
        return AopUtil.createInternalFqn(fqn, this.cache);
    }

    private Fqn setPojoReference(Fqn fqn, Object obj, String field, Fqn internalFqn) throws CacheException {
        CachedType type = this.pojoCache.getCachedType(obj.getClass());
        PojoReference pojoReference = new PojoReference();
        pojoReference.setPojoClass(type.getType());
        pojoReference.setFqn(internalFqn);
        this.internal_.putPojoReference(fqn, pojoReference, field);
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(): inserting PojoReference with id: " + fqn));
        }
        return internalFqn;
    }

    private void createChildNodeFirstWithoutLocking(Fqn internalFqn) {
        int size = internalFqn.size();
        Fqn f = internalFqn.getSubFqn(0, size - 1);
        Fqn child = internalFqn.getSubFqn(size - 1, size);
        Node base = this.cache.getRoot().getChild(f);
        if (base == null) {
            log.debug((Object)("The node retrieved is null from fqn: " + f));
            return;
        }
        base.addChild(child);
    }

    public Object removeObject(Fqn fqn, String field, Object source) throws CacheException {
        Object result;
        this.internal_.lockPojo(fqn);
        PojoReference pojoReference = this.internal_.getPojoReference(fqn, field);
        if (pojoReference == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("removeObject(): clazz is null. id: " + fqn + " No need to remove."));
            }
            return null;
        }
        Fqn internalFqn = pojoReference.getFqn();
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeObject(): removing object from id: " + fqn + " with the corresponding internal id: " + internalFqn));
        }
        if ((result = this.pojoCache.find(internalFqn)) == null) {
            return null;
        }
        this.internal_.lockPojo(internalFqn);
        ReferenceImpl reference = new ReferenceImpl(fqn, field);
        if (this.graphHandler_.isMultipleReferenced(internalFqn)) {
            this.graphHandler_.remove(internalFqn, reference, result);
        } else {
            this.cache.put(internalFqn, (Object)"POJOCache.Status", (Object)"DETACHING");
            boolean allowArray = source instanceof ArrayInterceptable;
            result = this.getHandler(result.getClass(), allowArray).remove(internalFqn, reference, result);
        }
        this.internal_.cleanUp(fqn, field);
        return result;
    }

    public Map findObjects(Fqn fqn) throws CacheException {
        HashMap<Fqn, Object> map = new HashMap<Fqn, Object>();
        Object pojo = this.getObject(fqn, null, null);
        if (pojo != null) {
            map.put(fqn, pojo);
            return map;
        }
        this.findChildObjects(fqn, map);
        if (log.isDebugEnabled()) {
            log.debug((Object)("_findObjects(): id: " + fqn + " size of pojos found: " + map.size()));
        }
        return map;
    }

    private Object getObjectInternal(Fqn<?> fqn, String field, Object source) throws CacheException {
        PojoInstance pojoInstance;
        Fqn internalFqn = fqn;
        PojoReference pojoReference = this.internal_.getPojoReference(fqn, field);
        if (pojoReference != null) {
            internalFqn = pojoReference.getFqn();
        } else if (field != null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getObject(): id: " + fqn + " with a corresponding internal id: " + internalFqn));
        }
        if ((pojoInstance = this.internal_.getPojoInstance(internalFqn)) == null) {
            return null;
        }
        Class clazz = pojoInstance.getPojoClass();
        boolean allowArray = source instanceof ArrayInterceptable;
        Object obj = this.getHandler(clazz, allowArray).get(internalFqn, clazz, pojoInstance);
        InternalHelper.setPojo(pojoInstance, obj);
        return obj;
    }

    private void findChildObjects(Fqn fqn, Map map) throws CacheException {
        Node root = this.cache.getRoot();
        Node current = root.getChild(fqn);
        if (current == null) {
            return;
        }
        Set col = current.getChildren();
        if (col == null) {
            return;
        }
        for (Node n : col) {
            Fqn newFqn = n.getFqn();
            if (InternalHelper.isInternalNode(newFqn)) continue;
            Object pojo = this.getObject(newFqn, null, null);
            if (pojo != null) {
                map.put(newFqn, pojo);
                continue;
            }
            this.findChildObjects(newFqn, map);
        }
    }

    public boolean exists(Fqn<?> id) {
        return this.internal_.getPojoReference(id, null) != null || this.internal_.getPojoInstance(id) != null;
    }

    public Fqn<?> getInternalFqn(Object object) {
        AbstractHandler handler = this.getHandler(object.getClass(), true);
        Fqn<?> internalFqn = handler.getFqn(object);
        return internalFqn;
    }

    public Collection<Reference> getReferences(Object object) {
        Fqn<?> fqn = this.getInternalFqn(object);
        if (fqn == null) {
            return Collections.emptyList();
        }
        PojoInstance pojoInstance = this.internal_.getPojoInstance(fqn);
        return pojoInstance.getReferences();
    }
}

