/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataContainerImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.mock.MockNodesFixture;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DataContainerTest {
    private DataContainerImpl container;
    private MockNodesFixture nodes;

    @BeforeMethod
    public void setUp() {
        this.nodes = new MockNodesFixture();
        this.container = new DataContainerImpl();
        this.container.setRoot((NodeSPI)this.nodes.root);
        this.container.setBuddyFqnTransformer(new BuddyFqnTransformer());
    }

    public void testPeekNodesSimple() {
        assert (this.nodes.root == this.container.peek(Fqn.ROOT, true, true));
        assert (this.nodes.adfgNode == this.container.peek(this.nodes.adfg, false, false));
        assert (this.nodes.adfgNode == this.container.peek(this.nodes.adfg, false, true));
        assert (this.nodes.adfgNode == this.container.peek(this.nodes.adfg, true, true));
    }

    public void testPeekInvalidNodes() {
        this.nodes.adfgNode.setValid(false, false);
        assert (null == this.container.peek(this.nodes.adfg, true, false));
        assert (this.nodes.adfgNode == this.container.peek(this.nodes.adfg, true, true));
    }

    public void testPeekDeletedNodes() {
        this.nodes.adfgNode.markAsDeleted(true);
        assert (null == this.container.peek(this.nodes.adfg, false, false));
        assert (this.nodes.adfgNode == this.container.peek(this.nodes.adfg, true, false));
    }

    public void testPeekVersioned() {
        assert (this.nodes.adfgNode == this.container.peekVersioned(this.nodes.adfg, null, true)) : "if data version is null this returns same value as peek(boolean, boolean)";
        Configuration config = new Configuration();
        config.setNodeLockingOptimistic(false);
        DefaultDataVersion dataVersion = new DefaultDataVersion(2L);
        this.container.setDependencies(config, null, null);
        assert (this.nodes.adfgNode == this.container.peekVersioned(this.nodes.adfg, (DataVersion)dataVersion, true)) : "if NOT opt locking same value as peek(boolean, boolean) expected";
        config.setNodeLockingOptimistic(true);
        DefaultDataVersion adfgDataVersion = new DefaultDataVersion(2L);
        this.nodes.adfgNode.setVersion((DataVersion)adfgDataVersion);
        assert (this.nodes.adfgNode == this.container.peekVersioned(this.nodes.adfg, (DataVersion)adfgDataVersion, true)) : "same version, expcting node to be returned";
        try {
            this.container.peekVersioned(this.nodes.adfg, (DataVersion)new DefaultDataVersion(1L), true);
            assert (false) : "exception expected as version changed.";
        }
        catch (CacheException e) {
            // empty catch block
        }
    }

    public void testPeekStrict() {
        assert (this.nodes.adfgNode == this.container.peekStrict(null, this.nodes.adfg, true)) : "if data version is null this returns same value as peek(boolean, boolean)";
        try {
            this.container.peekStrict(null, this.nodes.notExistent, true);
            assert (false) : "excpetion expected as node does not exist";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testsExists() {
        assert (this.container.exists(this.nodes.ab)) : "ab exists";
        this.nodes.abNode.markAsDeleted(true);
        assert (!this.container.exists(this.nodes.ab)) : "ab marked as deleted";
        assert (this.container.exists(this.nodes.ad));
        this.nodes.adNode.setValid(false, false);
        assert (!this.container.exists(this.nodes.ade)) : "its parent was marked as invalid";
    }

    public void testHasChildren() {
        assert (this.container.hasChildren(this.nodes.ad)) : " ade is a child of ad";
        assert (!this.container.hasChildren(this.nodes.notExistent)) : " this one does not exist";
        assert (!this.container.hasChildren(this.nodes.adfg)) : "this one exists but does not have children";
        this.nodes.adNode.setValid(false, false);
        assert (!this.container.hasChildren(this.nodes.ad)) : "ad exists and has children but is invalid";
    }

    public void testBuildNodeData() {
        this.nodes.abNode.put("ab", "ab");
        this.nodes.abcNode.put("abc", "abc");
        ArrayList result = new ArrayList();
        this.container.buildNodeData(result, (NodeSPI)this.nodes.abNode);
        assert (result.size() == 2);
        assert (result.contains(new NodeData(this.nodes.ab, this.nodes.abNode.getData())));
        assert (result.contains(new NodeData(this.nodes.abc, this.nodes.abcNode.getData())));
    }

    public void testGetNodesForEvictionNonrecursive() {
        List result = this.container.getNodesForEviction(Fqn.ROOT, false);
        assert (result.size() == 1) : "for root the direct children are considered for eviction";
        assert (result.contains(this.nodes.a));
        result = this.container.getNodesForEviction(this.nodes.ad, false);
        assert (result.size() == 1) : "one child expected";
        assert (result.contains(this.nodes.ad));
        this.nodes.adNode.setResident(true);
        result = this.container.getNodesForEviction(this.nodes.ad, false);
        assert (result.size() == 0) : "no children expected";
    }

    public void testGetNodesForEvictionRecursive() {
        List result = this.container.getNodesForEviction(Fqn.ROOT, true);
        assert (result.size() == 8) : "all children are considered for eviction";
        result = this.container.getNodesForEviction(this.nodes.ad, true);
        assert (result.size() == 5) : "five childrens expected";
        assert (result.contains(this.nodes.ad));
        assert (result.contains(this.nodes.ade));
        assert (result.contains(this.nodes.adf));
        assert (result.contains(this.nodes.adfh));
        assert (result.contains(this.nodes.adfg));
        this.nodes.adNode.setResident(true);
        result = this.container.getNodesForEviction(this.nodes.ad, true);
        assert (result.size() == 4) : "only children expected";
        assert (result.contains(this.nodes.ade));
        assert (result.contains(this.nodes.adf));
        assert (result.contains(this.nodes.adfh));
        assert (result.contains(this.nodes.adfg));
    }

    public void testGetNodesForEvictionRecursiveNullNodes() {
        this.container.removeFromDataStructure(this.nodes.ad, true);
        List result = this.container.getNodesForEviction(Fqn.ROOT, true);
        assert (result.size() == 3) : "all children are considered for eviction";
        result = this.container.getNodesForEviction(this.nodes.ad, true);
        assert (result.isEmpty()) : "Should be empty";
    }

    public void testGetNumberOfNodes() {
        assert (this.container.getNumberOfNodes() == 8) : "eoght nodes expected";
    }

    public void removeFromDataStructureNoSkip1() {
        assert (!this.container.removeFromDataStructure(this.nodes.notExistent, false));
        this.nodes.root.markAsDeleted(true);
        assert (this.container.removeFromDataStructure(Fqn.ROOT, false));
        assert (!this.nodes.aNode.isValid());
        assert (!this.nodes.abNode.isValid());
        assert (!this.nodes.abcNode.isValid());
        assert (!this.nodes.adNode.isValid());
        assert (!this.nodes.adeNode.isValid());
        assert (!this.nodes.adfNode.isValid());
        assert (!this.nodes.adfgNode.isValid());
        assert (!this.nodes.adfhNode.isValid());
        assert (this.nodes.root.isValid());
    }

    public void removeFromDataStructureNoSkip2() {
        this.nodes.root.markAsDeleted(false);
        assert (!this.container.removeFromDataStructure(Fqn.ROOT, false));
        this.nodes.adNode.markAsDeleted(true);
        assert (this.container.removeFromDataStructure(this.nodes.ad, false));
        assert (!this.nodes.adeNode.isValid());
        assert (!this.nodes.adfNode.isValid());
        assert (!this.nodes.adfhNode.isValid());
        assert (!this.nodes.adfhNode.isValid());
    }

    public void removeFromDataStructureWithSkip() {
        assert (!this.container.removeFromDataStructure(this.nodes.notExistent, false));
        assert (this.container.removeFromDataStructure(Fqn.ROOT, true));
        assert (!this.nodes.aNode.isValid());
        assert (!this.nodes.abNode.isValid());
        assert (!this.nodes.abcNode.isValid());
        assert (!this.nodes.adNode.isValid());
        assert (!this.nodes.adeNode.isValid());
        assert (!this.nodes.adfNode.isValid());
        assert (!this.nodes.adfgNode.isValid());
        assert (!this.nodes.adfhNode.isValid());
        assert (this.nodes.root.isValid());
    }

    public void testEvict() {
        assert (this.container.evict(this.nodes.abc));
        assert (!this.nodes.abcNode.isValid());
        assert (!this.nodes.abNode.hasChild("c"));
        this.nodes.adNode.put("key", "value");
        assert (!this.container.evict(this.nodes.ad));
        assert (this.nodes.adNode.isValid());
        assert (this.nodes.adNode.getData().isEmpty());
        assert (this.nodes.aNode.hasChild("d"));
        assert (this.nodes.adNode.hasChild("e"));
    }

    public void testCreateNodes() {
        Object[] objects = this.container.createNodes(Fqn.fromString((String)"/a/x/y/z"));
        List result = (List)objects[0];
        assert (result.size() == 3);
        assert (((NodeSPI)result.get(0)).getFqn().equals((Object)Fqn.fromString((String)"/a/x")));
        assert (((NodeSPI)result.get(1)).getFqn().equals((Object)Fqn.fromString((String)"/a/x/y")));
        assert (((NodeSPI)result.get(2)).getFqn().equals((Object)Fqn.fromString((String)"/a/x/y/z")));
        NodeSPI target = (NodeSPI)objects[1];
        assert (target != null);
        assert (target.getFqn().toString().equals("/a/x/y/z"));
    }
}

