/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.Marshaller;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"unit"})
public class FqnTest {
    private Cache<Object, Object> cache;
    private Marshaller marshaller;

    @BeforeTest
    protected void setUp() {
        this.cache = null;
        this.marshaller = new CacheMarshaller210();
    }

    @AfterTest
    protected void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
    }

    public void testNull() {
        Fqn fqn = Fqn.ROOT;
        this.log("null fqn is " + fqn);
        assert (0 == fqn.size());
        int hcode = fqn.hashCode();
        assert (hcode != -1);
    }

    public void testOne() {
        Fqn fqn = Fqn.fromElements((Object[])new Integer[]{22});
        this.log("one fqn is " + fqn);
        assert (1 == fqn.size());
        int hcode = fqn.hashCode();
        assert (hcode != -1);
    }

    public void testEmptyFqn() {
        Fqn f1 = Fqn.ROOT;
        Fqn f2 = Fqn.ROOT;
        assert (f1.equals((Object)f2));
    }

    public void testFqn() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        this.log("fqn is " + fqn);
        assert (3 == fqn.size());
        Fqn fqn2 = Fqn.fromElements((Object[])new String[]{"a", "b", "c"});
        this.log("fqn2 is " + fqn2);
        assert (3 == fqn.size());
        assert (fqn.equals((Object)fqn2));
        assert (fqn.hashCode() == fqn2.hashCode());
    }

    public void testHereogeneousNames() {
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{"string", Integer.valueOf(38), Boolean.valueOf(true)});
        this.log("fqn is " + fqn);
        assert (3 == fqn.size());
        Fqn fqn2 = Fqn.fromElements((Object[])new Serializable[]{"string", Integer.valueOf(38), Boolean.valueOf(true)});
        assert (fqn.equals((Object)fqn2));
        assert (fqn.hashCode() == fqn2.hashCode());
    }

    public void testHashcode() {
        Fqn fqn1 = Fqn.fromElements((Object[])new String[]{"a", "b", "c"});
        Fqn fqn2 = Fqn.fromString((String)"/a/b/c");
        this.log("fqn is " + fqn1);
        assert (fqn1.equals((Object)fqn2));
        HashMap<Fqn, Integer> map = new HashMap<Fqn, Integer>();
        map.put(fqn1, 33);
        map.put(fqn2, 34);
        assert (map.size() == 1);
        assert (((Integer)map.get(fqn1)).equals(34));
    }

    public void testHashcode2() {
        Fqn fqn = Fqn.fromElements((Object[])new Integer[]{-1});
        this.log("one fqn is " + fqn);
        assert (fqn.size() == 1);
        int hcode = fqn.hashCode();
        assert (hcode == -1);
    }

    public void testEquals() {
        Fqn fqn1 = Fqn.fromElements((Object[])new String[]{"person/test"});
        Fqn f1 = Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"0"});
        Fqn f2 = Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"1"});
        Fqn f3 = Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"2"});
        HashMap<Fqn, String> map = new HashMap<Fqn, String>();
        map.put(f1, "0");
        map.put(f2, "1");
        map.put(f3, "2");
        assert (map.get(Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"0"})) != null);
        assert (map.get(Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"1"})) != null);
        assert (map.get(Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"2"})) != null);
    }

    public void testEquals2() {
        Fqn f1 = Fqn.fromString((String)"/a/b/c");
        Fqn f2 = Fqn.fromString((String)"/a/b/c");
        assert (f1.equals((Object)f2));
        f2 = Fqn.fromString((String)"/a/b");
        assert (!f1.equals((Object)f2));
        f2 = Fqn.fromString((String)"/a/b/c/d");
        assert (!f1.equals((Object)f2));
    }

    public void testEquals2WithMarshalling() throws Exception {
        Fqn f1 = Fqn.fromString((String)"/a/b/c");
        Fqn f2 = this.marshalAndUnmarshal(f1);
        assert (f1.equals(f2));
    }

    public void testEquals3() {
        Fqn f1 = Fqn.fromElements((Object[])new Serializable[]{"a", Integer.valueOf(322649), Boolean.TRUE});
        Fqn f2 = Fqn.ROOT;
        assert (!f1.equals((Object)f2));
        assert (!f2.equals((Object)f1));
        f2 = Fqn.fromString((String)"a/322649/TRUE");
        assert (!f1.equals((Object)f2));
        f2 = Fqn.fromElements((Object[])new Serializable[]{"a", Integer.valueOf(322649), Boolean.FALSE});
        assert (!f1.equals((Object)f2));
        f2 = Fqn.fromElements((Object[])new Serializable[]{"a", Integer.valueOf(322649), Boolean.TRUE});
        assert (f1.equals((Object)f2));
    }

    public void testEquals3WithMarshalling() throws Exception {
        Fqn f1 = Fqn.fromElements((Object[])new Serializable[]{"a", Integer.valueOf(322649), Boolean.TRUE});
        Fqn f2 = this.marshalAndUnmarshal(f1);
        assert (f1.equals(f2));
        assert (f2.equals((Object)f1));
        Fqn f3 = Fqn.fromString((String)"a/322649/TRUE");
        f3 = this.marshalAndUnmarshal(f3);
        assert (!f1.equals(f3));
        f2 = Fqn.fromElements((Object[])new Serializable[]{"a", Integer.valueOf(322649), Boolean.FALSE});
        f2 = this.marshalAndUnmarshal(f2);
        assert (!f1.equals(f2));
        f2 = Fqn.fromElements((Object[])new Serializable[]{"a", Integer.valueOf(322649), Boolean.TRUE});
        f2 = this.marshalAndUnmarshal(f2);
        assert (f1.equals(f2));
    }

    public void testEquals4() {
        Fqn fqn = Fqn.fromString((String)"X");
        assert (!fqn.equals((Object)"X"));
        assert (!fqn.equals(null));
    }

    public void testClone() throws CloneNotSupportedException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = fqn1.clone();
        assert (fqn1.equals((Object)fqn2));
        assert (fqn1.hashCode() == fqn2.hashCode());
    }

    public void testNullElements() throws CloneNotSupportedException {
        Fqn fqn0 = Fqn.fromElements((Object[])new Object[]{null});
        assert (1 == fqn0.size());
        Fqn fqn1 = Fqn.fromElements((Object[])new Serializable[]{"NULL", null, Integer.valueOf(0)});
        assert (3 == fqn1.size());
        Fqn fqn2 = Fqn.fromElements((Object[])new Serializable[]{"NULL", null, Integer.valueOf(0)});
        assert (fqn1.hashCode() == fqn2.hashCode());
        assert (fqn1.equals((Object)fqn2));
        assert (fqn1.equals((Object)fqn1.clone()));
    }

    public void testIteration() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        assert (3 == fqn.size());
        Fqn tmp_fqn = Fqn.ROOT;
        assert (0 == tmp_fqn.size());
        for (int i = 0; i < fqn.size(); ++i) {
            String s = (String)fqn.get(i);
            tmp_fqn = Fqn.fromRelativeElements((Fqn)tmp_fqn, (Object[])new Object[]{s});
            assert (tmp_fqn.size() == i + 1);
        }
        assert (3 == tmp_fqn.size());
        assert (fqn.equals((Object)tmp_fqn));
    }

    public void testIsChildOf() {
        Fqn child = Fqn.fromString((String)"/a/b");
        Fqn parent = Fqn.fromString((String)"/a");
        assert (child.isChildOf(parent));
        assert (!parent.isChildOf(child));
        assert (child.isChildOrEquals(child));
        parent = Fqn.fromString((String)"/a/b/c");
        child = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/e/r/e/r/t/tt/");
        assert (child.isChildOf(parent));
    }

    public void testIsChildOf2() {
        Fqn child = Fqn.fromString((String)"/a/b/c/d");
        assert ("/b/c/d".equals(child.getSubFqn(1, child.size()).toString()));
    }

    public void testParentage() {
        Fqn fqnRoot = Fqn.ROOT;
        Fqn parent = fqnRoot.getParent();
        assert (parent.equals((Object)fqnRoot));
        Fqn fqnOne = Fqn.fromString((String)"/one");
        parent = fqnOne.getParent();
        assert (parent.equals((Object)fqnRoot));
        assert (fqnOne.isChildOf(parent));
        Fqn fqnTwo = Fqn.fromString((String)"/one/two");
        parent = fqnTwo.getParent();
        assert (parent.equals((Object)fqnOne));
        assert (fqnTwo.isChildOf(parent));
        Fqn fqnThree = Fqn.fromString((String)"/one/two/three");
        parent = fqnThree.getParent();
        assert (parent.equals((Object)fqnTwo));
        assert (fqnThree.isChildOf(parent));
    }

    public void testRoot() {
        Fqn fqn = Fqn.ROOT;
        assert (fqn.isRoot());
        fqn = Fqn.fromString((String)"/one/two");
        assert (!fqn.isRoot());
        Fqn f = Fqn.fromString((String)"/");
        assert (f.isRoot());
        assert (f.equals((Object)Fqn.ROOT));
    }

    public void testGetName() {
        Fqn integerFqn = Fqn.fromElements((Object[])new Integer[]{1});
        assert ("1".equals(integerFqn.getLastElementAsString()));
        Object object = new Object();
        Fqn objectFqn = Fqn.fromElements((Object[])new Object[]{object});
        assert (object.toString().equals(objectFqn.getLastElementAsString()));
    }

    public void testCloningString() throws CloneNotSupportedException {
        Fqn f = Fqn.fromString((String)"/a/b/c");
        assert (f.equals((Object)f.clone()));
    }

    public void testCloningOtherTypes() throws CloneNotSupportedException {
        Fqn f = Fqn.fromElements((Object[])new Serializable[]{"blah", Integer.valueOf(10), Boolean.TRUE});
        assert (f.equals((Object)f.clone()));
    }

    public void testRemovalNonString() throws Exception {
        Fqn f = Fqn.fromElements((Object[])new Serializable[]{"test", Integer.valueOf(1)});
        Configuration c = new Configuration();
        c.setCacheMode("LOCAL");
        this.cache = new DefaultCacheFactory().createCache(c);
        this.cache.put(f, (Object)"key", (Object)"value");
        assert ("value".equals(this.cache.get(f, (Object)"key")));
        assert (this.cache.getRoot().hasChild(f));
        this.cache.removeNode(f);
        assert (this.cache.get(f, (Object)"key") == null);
        assert (!this.cache.getRoot().hasChild(f));
    }

    <T> Fqn<T> marshalAndUnmarshal(Fqn<T> fqn) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        this.marshaller.objectToObjectStream(fqn, out);
        out.close();
        baos.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        return (Fqn)this.marshaller.objectFromObjectStream(in);
    }

    public void testGenerics() {
        Fqn f = Fqn.fromString((String)"/blah/blah");
        Fqn f2 = Fqn.fromString((String)"/blah/blah");
        assert (f.equals((Object)f2));
        Fqn f3 = Fqn.fromElements((Object[])new Integer[]{1, 2, 3, 5});
        Fqn f4 = Fqn.fromElements((Object[])new Integer[]{1, 2, 3});
        assert (f3.getParent().equals((Object)f4));
    }

    public void testSize() {
        Fqn f = Fqn.ROOT;
        assert (f.size() == 0);
        assert (f.isRoot());
        f = Fqn.fromString((String)"/");
        assert (f.size() == 0);
        assert (f.isRoot());
        f = Fqn.fromString((String)"/hello");
        assert (f.size() == 1);
        assert (!f.isRoot());
    }

    public void testGenerations() {
        Fqn f = Fqn.fromElements((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
        assert (f.equals((Object)f.getAncestor(f.size())));
        assert (f.getParent().equals((Object)f.getAncestor(f.size() - 1)));
        assert (Fqn.ROOT.equals((Object)f.getAncestor(0)));
        assert (Fqn.fromElements((Object[])new Integer[]{1}).equals((Object)f.getAncestor(1)));
        assert (Fqn.fromElements((Object[])new Integer[]{1, 2}).equals((Object)f.getAncestor(2)));
        assert (Fqn.fromElements((Object[])new Integer[]{1, 2, 3}).equals((Object)f.getAncestor(3)));
        assert (Fqn.fromElements((Object[])new Integer[]{1, 2, 3, 4}).equals((Object)f.getAncestor(4)));
        assert (Fqn.fromElements((Object[])new Integer[]{1, 2, 3, 4, 5}).equals((Object)f.getAncestor(5)));
        try {
            f.getAncestor(-1);
            assert (false);
        }
        catch (IllegalArgumentException good) {
            // empty catch block
        }
        try {
            f.getAncestor(f.size() + 1);
            assert (false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    public void testDifferentFactories() {
        Fqn[] fqns = new Fqn[7];
        int i = 0;
        fqns[i++] = Fqn.fromString((String)"/a/b/c");
        fqns[i++] = Fqn.fromRelativeElements((Fqn)Fqn.ROOT, (Object[])new Object[]{"a", "b", "c"});
        fqns[i++] = Fqn.fromElements((Object[])new String[]{"a", "b", "c"});
        fqns[i++] = Fqn.fromList(Arrays.asList("a", "b", "c"));
        fqns[i++] = Fqn.fromRelativeList((Fqn)Fqn.ROOT, Arrays.asList("a", "b", "c"));
        fqns[i++] = Fqn.fromRelativeFqn((Fqn)Fqn.ROOT, (Fqn)Fqn.fromString((String)"/a/b/c"));
        fqns[i] = new Fqn(new Object[]{"a", "b", "c"});
        for (i = 0; i < fqns.length; ++i) {
            for (int j = 0; j < fqns.length; ++j) {
                assert (fqns[i].equals((Object)fqns[j])) : "Error on equals comparing " + i + " and " + j;
                assert (fqns[j].equals((Object)fqns[i])) : "Error on equals comparing " + i + " and " + j;
                assert (fqns[i].hashCode() == fqns[j].hashCode()) : "Error on hashcode comparing " + i + " and " + j;
            }
        }
    }
}

