/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class DeletedChildResurrectionTest {
    private Cache<Object, Object> cache;
    private static final Fqn<String> A_B = Fqn.fromString((String)"/a/b");
    private static final Fqn<String> A = Fqn.fromString((String)"/a");
    private static final Fqn<String> A_C = Fqn.fromString((String)"/a/c");
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String K2 = "k2";
    private static final String V2 = "v2";

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cache = new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true), false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache);
    }

    public void testDeletedChildResurrectionPessimistic1() throws Exception {
        this.deletedChildResurrectionTest1(false);
    }

    public void testDeletedChildResurrectionOptimistic1() throws Exception {
        this.deletedChildResurrectionTest1(true);
    }

    public void testDeletedChildResurrectionPessimistic2() throws Exception {
        this.deletedChildResurrectionTest2(false);
    }

    public void testDeletedChildResurrectionOptimistic2() throws Exception {
        this.deletedChildResurrectionTest2(true);
    }

    private void deletedChildResurrectionTest1(boolean optimistic) throws Exception {
        this.cache.getConfiguration().setNodeLockingOptimistic(optimistic);
        this.cache.start();
        CacheSPI spi = (CacheSPI)this.cache;
        Node root = this.cache.getRoot();
        TransactionManager txManager = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        root.addChild(A_B).put((Object)KEY, (Object)VALUE);
        this.cache.put(A, (Object)KEY, (Object)VALUE);
        txManager.begin();
        root.removeChild(A);
        root.addChild(A);
        txManager.commit();
        assert (!root.hasChild(A_B));
        assert (null == this.cache.get(A, (Object)KEY));
        assert (spi.peek(A_B, true, true) == null);
        assert (root.hasChild(A));
    }

    private void deletedChildResurrectionTest2(boolean optimistic) throws Exception {
        this.cache.getConfiguration().setNodeLockingOptimistic(optimistic);
        this.cache.start();
        Node root = this.cache.getRoot();
        TransactionManager txManager = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        root.addChild(A_B).put((Object)KEY, (Object)VALUE);
        txManager.begin();
        root.removeChild(A);
        root.addChild(A_C).put((Object)K2, (Object)V2);
        txManager.commit();
        assert (!root.hasChild(A_B));
        assert (root.hasChild(A_C));
        assert (V2.equals(root.getChild(A_C).get((Object)K2)));
    }
}

