/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.TestingUtil;
import org.jgroups.JChannel;
import org.jgroups.protocols.DISCARD;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class BuddyReplicationFailoverTest
extends BuddyReplicationTestsBase {
    protected boolean optimisticLocks = false;
    private String key = "key";
    private String value = "value";
    BuddyFqnTransformer fqnTransformer = new BuddyFqnTransformer();

    public void testDataGravitationKillOwner() throws Exception {
        this.testDataGravitation(true);
    }

    public void testDataGravitationDontKillOwner() throws Exception {
        this.testDataGravitation(false);
    }

    private void testDataGravitation(boolean killOwner) throws Exception {
        this.caches = this.createCaches(3, false, true, this.optimisticLocks);
        Fqn fqn = Fqn.fromString((String)"/test");
        Fqn backupFqn = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(0)).getLocalAddress(), fqn);
        TestingUtil.dumpCacheContents(this.caches);
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        TestingUtil.dumpCacheContents(this.caches);
        AssertJUnit.assertEquals((String)"Value should exist", (Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        TestingUtil.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((String)"Should be false", (!((CacheSPI)this.caches.get(1)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"Should be false", (!((CacheSPI)this.caches.get(2)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertFalse((String)"Should be false", (boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
        AssertJUnit.assertTrue((String)"Value be true", (boolean)((CacheSPI)this.caches.get(1)).exists(backupFqn));
        AssertJUnit.assertFalse((String)"Should be false", (boolean)((CacheSPI)this.caches.get(2)).exists(backupFqn));
        if (killOwner) {
            System.out.println("***** About to kill original data owner (" + ((CacheSPI)this.caches.get(0)).getLocalAddress() + ").  *****");
            this.killChannel((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(1), 2);
            System.out.println("Killed.  Testing backup roots.");
            TestingUtil.dumpCacheContents(this.caches);
            assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(2)).getLocalAddress()), false) != null) : "Should have new buddy's backup root.";
            assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) == null) : "Should not have self as a backup root.";
            assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) == null) : "Should not have dead node as a backup root.";
            assert (((CacheSPI)this.caches.get(1)).peek(Fqn.fromRelativeElements((Fqn)this.fqnTransformer.getDeadBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), (Object[])new Object[]{1}), false) != null) : "Should have dead node as a defunct backup root.";
            assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(2)).getLocalAddress()), false) == null) : "Should not have self as a backup root.";
            assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) != null) : "Should have new buddy's backup root.";
            assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) == null) : "Should not have dead node as a backup root.";
            assert (((CacheSPI)this.caches.get(2)).peek(Fqn.fromRelativeElements((Fqn)this.fqnTransformer.getDeadBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), (Object[])new Object[]{1}), false) == null) : "Should not have dead node as a defunct backup root.";
        }
        System.out.println("***** Killed original data owner, about to call a get on a different cache instance.  *****");
        AssertJUnit.assertEquals((String)"Value should have gravitated", (Object)this.value, (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        this.delay();
        TestingUtil.dumpCacheContents(this.caches);
        Fqn newBackupFqn = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(2)).getLocalAddress(), fqn);
        if (!killOwner) {
            AssertJUnit.assertTrue((String)"Should be false", (!((CacheSPI)this.caches.get(0)).exists(fqn) ? 1 : 0) != 0);
        } else {
            assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(2)).getLocalAddress()), false) != null) : "Should have new buddy's backup root.";
            assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) == null) : "Should not have self as a backup root.";
            assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) == null) : "Should not have dead node as a backup root.";
            assert (((CacheSPI)this.caches.get(1)).peek(Fqn.fromRelativeElements((Fqn)this.fqnTransformer.getDeadBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), (Object[])new Object[]{1}), false) == null) : "Should not have dead node as a defunct backup root.";
            assert (((CacheSPI)this.caches.get(1)).peek(this.fqnTransformer.getDeadBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) == null) : "Should not have dead node as a defunct backup root.";
            assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(2)).getLocalAddress()), false) == null) : "Should not have self as a backup root.";
            assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(1)).getLocalAddress()), false) != null) : "Should have new buddy's backup root.";
            assert (((CacheSPI)this.caches.get(2)).peek(this.fqnTransformer.getBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), false) == null) : "Should not have dead node as a backup root.";
            assert (((CacheSPI)this.caches.get(2)).peek(Fqn.fromRelativeElements((Fqn)this.fqnTransformer.getDeadBackupRoot(((CacheSPI)this.caches.get(0)).getLocalAddress()), (Object[])new Object[]{1}), false) == null) : "Should not have dead node as a defunct backup root.";
        }
        AssertJUnit.assertTrue((String)"Should be false", (!((CacheSPI)this.caches.get(1)).exists(fqn) ? 1 : 0) != 0);
        if (!killOwner) {
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
        }
        AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(1)).exists(backupFqn));
        AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(2)).exists(backupFqn));
        if (killOwner) {
            AssertJUnit.assertEquals((String)"Value should exist", (Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(newBackupFqn, (Object)this.key));
        } else {
            AssertJUnit.assertEquals((String)"Value should exist", (Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(newBackupFqn, (Object)this.key));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(1)).exists(newBackupFqn));
        }
        AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheSPI)this.caches.get(2)).exists(newBackupFqn));
    }

    private void killChannel(CacheSPI cacheToKill, CacheSPI anotherCache, int finalExpectedClusterSize) {
        JChannel channel = (JChannel)cacheToKill.getRPCManager().getChannel();
        DISCARD discard = (DISCARD)channel.getProtocolStack().findProtocol(DISCARD.class);
        if (discard != null) {
            discard.setDiscardAll(true);
            TestingUtil.blockUntilViewReceived(anotherCache, finalExpectedClusterSize, 10000L, false);
            TestingUtil.sleepThread(1000L);
        }
    }

    public void testDataReplicationSuppression() throws Exception {
        this.caches = this.createCaches(3, false, false, this.optimisticLocks);
        Fqn fqn = Fqn.fromString((String)"/test");
        Fqn backupFqn = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(0)).getLocalAddress(), fqn);
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        TestingUtil.dumpCacheContents(this.caches);
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(1)).exists(fqn));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(2)).exists(fqn));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(2)).exists(backupFqn));
        this.assertNoLocks(this.caches);
        backupFqn = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(1)).getLocalAddress(), fqn);
        System.out.println("*** Calling get() on cache[1] with force option");
        ((CacheSPI)this.caches.get(1)).getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(1)).get(fqn, (Object)this.key));
        this.delay();
        TestingUtil.dumpCacheContents(this.caches);
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(1)).exists(backupFqn));
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheSPI)this.caches.get(2)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(2)).exists(fqn));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(0)).exists(fqn));
        AssertJUnit.assertFalse((boolean)((CacheSPI)this.caches.get(0)).exists(backupFqn));
    }

    public void testSubtreeRetrieval() throws Exception {
        this.caches = this.createCaches(3, false, true, this.optimisticLocks);
        Fqn fqn = Fqn.fromString((String)"/test");
        Fqn fqn2 = Fqn.fromString((String)"/test/subtree");
        Fqn backupFqn = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(0)).getLocalAddress(), fqn);
        Fqn backupFqn2 = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(0)).getLocalAddress(), fqn2);
        ((CacheSPI)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        ((CacheSPI)this.caches.get(0)).put(fqn2, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(fqn2, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(1)).get(backupFqn2, (Object)this.key));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(backupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(backupFqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(fqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(fqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(backupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(backupFqn2) ? 1 : 0) != 0);
        this.assertNoLocks(this.caches);
        ((CacheSPI)this.caches.get(2)).getNode(fqn);
        this.delay();
        Fqn newBackupFqn = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(2)).getLocalAddress(), fqn);
        Fqn newBackupFqn2 = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(2)).getLocalAddress(), fqn2);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(2)).exists(fqn2));
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheSPI)this.caches.get(0)).get(newBackupFqn, (Object)this.key));
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(0)).exists(newBackupFqn2));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(fqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(fqn2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn2) ? 1 : 0) != 0);
        TestingUtil.dumpCacheContents(this.caches);
        for (CacheSPI cache : this.caches) {
            AssertJUnit.assertTrue((!cache.exists(backupFqn) ? 1 : 0) != 0);
            AssertJUnit.assertTrue((!cache.exists(backupFqn2) ? 1 : 0) != 0);
        }
        this.assertNoLocks(this.caches);
    }

    protected void delay() {
        TestingUtil.sleepThread(250L);
    }
}

