/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class DisabledStateTransferTest
extends BuddyReplicationTestsBase {
    public void testCachesWithoutStateTransfer() throws Exception {
        Fqn backup;
        this.caches = this.createCaches(1, 3, false, false, false, false);
        int cacheNumber = 0;
        for (CacheSPI c : this.caches) {
            c.getConfiguration().setFetchInMemoryState(false);
            c.start();
            c.put("/" + cacheNumber++, (Object)"k", (Object)"v");
        }
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheSPI[0]), 60000L);
        for (CacheSPI c : this.caches) {
            System.out.println("Cache (local address " + c.getLocalAddress() + ") contents: " + CachePrinter.printCacheLockingInfo((Cache)c));
        }
        for (int i = 0; i < 3; ++i) {
            boolean backupOlderThanOwner;
            int backupIndex;
            int n = backupIndex = i == 2 ? 0 : i + 1;
            assert (((CacheSPI)this.caches.get(i)).exists("/" + i)) : "Data should exist on owner (cache #" + i + ")";
            backup = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(i)).getLocalAddress(), Fqn.fromString((String)("/" + i)));
            assert (((CacheSPI)this.caches.get(backupIndex)).exists(backup.getParent())) : "Backup region should have been created on buddy (cache #" + backupIndex + ")";
            boolean backupStatePropagated = ((CacheSPI)this.caches.get(backupIndex)).exists(backup);
            boolean bl = backupOlderThanOwner = backupIndex < i;
            assert (!backupStatePropagated && !backupOlderThanOwner || backupStatePropagated && backupOlderThanOwner) : "Backup state should NOT have been transferred to buddy (cache #" + backupIndex + ")";
        }
        cacheNumber = 0;
        for (CacheSPI c : this.caches) {
            c.put("/" + cacheNumber++ + "_NEW", (Object)"k", (Object)"v");
        }
        for (int i = 0; i < 3; ++i) {
            int backupIndex;
            int n = backupIndex = i == 2 ? 0 : i + 1;
            assert (((CacheSPI)this.caches.get(i)).exists("/" + i + "_NEW")) : "Data should exist on owner (cache #" + i + ")";
            backup = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(i)).getLocalAddress(), Fqn.fromString((String)("/" + i + "_NEW")));
            assert (((CacheSPI)this.caches.get(backupIndex)).exists(backup.getParent())) : "Backup region should have been created on buddy (cache #" + backupIndex + ")";
            assert (((CacheSPI)this.caches.get(backupIndex)).exists(backup)) : "Backup state should NOT have been transferred to buddy (cache #" + backupIndex + ")";
        }
    }
}

