/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Collections;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.commands.write.OptimisticInvalidateCommand;
import org.jboss.cache.mock.MockNodesFixture;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class OptimisticInvalidateCommandTest
extends AbstractDataCommandTest {
    DataVersion dataVersion;
    OptimisticInvalidateCommand command;
    IMocksControl control;
    Notifier notifier;
    TransactionManager tmMock;
    MockNodesFixture nodes;
    CacheSPI spiMock;

    protected void moreSetup() {
        this.control = EasyMock.createStrictControl();
        this.notifier = (Notifier)this.control.createMock(Notifier.class);
        this.container = (DataContainer)this.control.createMock(DataContainer.class);
        this.tmMock = (TransactionManager)this.control.createMock(TransactionManager.class);
        this.spiMock = (CacheSPI)this.control.createMock(CacheSPI.class);
        this.nodes = new MockNodesFixture();
        this.command = new OptimisticInvalidateCommand(this.testFqn);
        this.dataVersion = new DefaultDataVersion(10L);
        this.command.setDataVersion(this.dataVersion);
        this.command.initialize(this.spiMock, this.container, this.notifier);
        this.command.initialize(this.tmMock);
    }

    public void testWithExistingNode() {
        this.nodes.adfNode.put("key", "value");
        this.nodes.adfNode.setDataLoaded(true);
        EasyMock.expect((Object)this.spiMock.getNode(this.testFqn)).andReturn((Object)this.nodes.adfNode);
        EasyMock.expect((Object)this.container.peekVersioned(this.testFqn, this.dataVersion)).andReturn((Object)this.nodes.adfNode);
        this.notifier.notifyNodeEvicted(this.testFqn, true, this.ctx);
        this.notifier.notifyNodeEvicted(this.testFqn, false, this.ctx);
        EasyMock.expect((Object)this.container.peek(this.testFqn, false, true)).andReturn((Object)this.nodes.adfNode);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (this.nodes.adfNode.getData().isEmpty());
        assert (!this.nodes.adfNode.isDataLoaded());
        assert (!this.nodes.adfNode.isValid());
        assert (this.nodes.adfNode.getVersion().equals(this.dataVersion));
        this.control.verify();
    }

    public void testWithExistingNodeInvalidVersion() {
        this.nodes.adfNode.put("key", "value");
        this.nodes.adfNode.setDataLoaded(true);
        EasyMock.expect((Object)this.spiMock.getNode(this.testFqn)).andReturn((Object)this.nodes.adfNode);
        EasyMock.expect((Object)this.container.peekVersioned(this.testFqn, this.dataVersion)).andThrow((Throwable)new RuntimeException());
        this.control.replay();
        try {
            this.command.perform(this.ctx);
            assert (false) : "exception expected";
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (!this.nodes.adfNode.getData().isEmpty());
        assert (this.nodes.adfNode.isDataLoaded());
        assert (this.nodes.adfNode.isValid());
        assert (!this.dataVersion.equals(this.nodes.adfNode.getVersion()));
        this.control.verify();
    }

    public void testExistingTumbstone() {
        this.nodes.adfNode.setValid(false, true);
        EasyMock.expect((Object)this.spiMock.getNode(this.testFqn)).andReturn(null);
        EasyMock.expect((Object)this.container.peek(this.testFqn, false, true)).andReturn((Object)this.nodes.adfNode);
        EasyMock.expect((Object)this.container.peekVersioned(this.testFqn, this.dataVersion)).andReturn((Object)this.nodes.adfNode);
        this.notifier.notifyNodeEvicted(this.testFqn, true, this.ctx);
        this.notifier.notifyNodeEvicted(this.testFqn, false, this.ctx);
        EasyMock.expect((Object)this.container.peek(this.testFqn, false, true)).andReturn((Object)this.nodes.adfNode);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (this.nodes.adfNode.getData().isEmpty());
        assert (!this.nodes.adfNode.isDataLoaded());
        assert (!this.nodes.adfNode.isValid());
        assert (this.nodes.adfNode.getVersion().equals(this.dataVersion));
        this.control.verify();
    }

    public void testCreateTumbstone() throws Exception {
        Transaction tx = (Transaction)this.control.createMock(Transaction.class);
        EasyMock.expect((Object)this.tmMock.suspend()).andReturn((Object)tx);
        this.spiMock.put(this.testFqn, Collections.emptyMap());
        this.tmMock.resume(tx);
        this.control.replay();
        this.command.createTombstone(this.ctx);
        this.control.verify();
    }

    public void testCreateTumbstoneNoTx() throws Exception {
        EasyMock.expect((Object)this.tmMock.suspend()).andReturn(null);
        this.spiMock.put(this.testFqn, Collections.EMPTY_MAP);
        this.control.replay();
        this.command.createTombstone(this.ctx);
        this.control.verify();
    }
}

