/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.demo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.demo.CacheModelDelegate;
import org.jboss.cache.demo.JBossCacheGUI;
import org.jboss.cache.demo.JBossCacheModelDelegate;

public class JBossCacheView {
    private static Log log = LogFactory.getLog((String)JBossCacheView.class.getName());
    private JBossCacheGUI gui = null;
    private boolean useConsole = false;
    private String configurationFile = null;
    private CacheModelDelegate cacheModelDelegate;

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setCacheModelDelegate(CacheModelDelegate cacheModelDelegate) {
        this.cacheModelDelegate = cacheModelDelegate;
        if (this.gui != null) {
            this.gui.setCacheModelDelegate(cacheModelDelegate);
        }
    }

    public void doMain(String[] args) throws Exception {
        this.parseParameters(args);
        if (this.configurationFile == null) {
            JBossCacheView.help();
            throw new Exception("Configuration file cannot be null, please specify with the -config parameter when starting!");
        }
        CacheModelDelegate cacheModelDelegate = this.createCacheDelegate();
        cacheModelDelegate.getGenericCache().start();
        this.setCacheModelDelegate(cacheModelDelegate);
        this.start();
    }

    public void start() throws Exception {
        if (this.gui == null) {
            log.info((Object)"start(): creating the GUI");
            System.out.println("start(): creating the GUI");
            this.gui = this.createGUI(this.cacheModelDelegate, this.useConsole);
        }
    }

    public void stop() {
        if (this.gui != null) {
            log.info((Object)"stop(): disposing the GUI");
            this.gui.stopGui();
            this.gui = null;
        }
    }

    public static void main(String[] args) {
        try {
            JBossCacheView view = new JBossCacheView();
            view.doMain(args);
        }
        catch (Exception ex) {
            log.error((Object)"Cannot start up!!", (Throwable)ex);
        }
    }

    protected void parseParameters(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-console")) {
                this.useConsole = true;
                continue;
            }
            if (args[i].equals("-config")) {
                this.configurationFile = args[++i];
                continue;
            }
            JBossCacheView.help();
            return;
        }
    }

    protected CacheModelDelegate createCacheDelegate() throws Exception {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        Cache cache = factory.createCache(this.configurationFile, false);
        JBossCacheModelDelegate delegate = new JBossCacheModelDelegate();
        delegate.setCacheShellVariable(cache);
        return delegate;
    }

    protected JBossCacheGUI createGUI(CacheModelDelegate delegate, boolean useConsole) throws Exception {
        return new JBossCacheGUI(delegate, useConsole);
    }

    private static void help() {
        System.out.println("JBossCacheView [-help] [-console] [-config <path to configuration file to use>]");
        System.out.println();
        System.out.println("-console enables the embedded BeanShell console");
        System.out.println("-config allows you to provide a path to the configuration file to use.");
        System.out.println();
        System.out.println();
    }
}

