/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.NullEvictionPolicyConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class NullEvictionConfigTest {
    public void testXMLParsing() throws Exception {
        String xml = "<region name=\"/org/jboss/data\">\n<attribute name=\"maxNodes\">5000</attribute>\n<attribute name=\"timeToLiveSeconds\">1000</attribute>\n</region>";
        this.testConfigBlock(xml);
        xml = "<region name=\"/maxAgeTest/\">\n<attribute name=\"maxNodes\">10000</attribute>\n<attribute name=\"timeToLiveSeconds\">8</attribute>\n<attribute name=\"maxAgeSeconds\">10</attribute>\n</region>";
        this.testConfigBlock(xml);
        xml = "<region name=\"/maxAgeTest/\">\n<attribute name=\"maxNodes\">10000</attribute>\n<attribute name=\"maxAgeSeconds\">10</attribute>\n</region>";
        this.testConfigBlock(xml);
        xml = "<region name=\"/maxAgeTest/\">\n<attribute name=\"timeToLiveSeconds\">8</attribute>\n<attribute name=\"maxAgeSeconds\">10</attribute>\n</region>";
        this.testConfigBlock(xml);
        xml = "<region name=\"/maxAgeTest/\"/>\n";
        this.testConfigBlock(xml);
    }

    private void testConfigBlock(String xml) throws Exception {
        Element element = XmlHelper.stringToElement((String)xml);
        NullEvictionPolicyConfig config = new NullEvictionPolicyConfig();
        try {
            XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.getMessage());
        }
    }
}

