/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.Iterator;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.factories.InterceptorChainTestBase;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.interceptors.ActivationInterceptor;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.DataGravitatorInterceptor;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.interceptors.InvalidationInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.NotificationInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticReplicationInterceptor;
import org.jboss.cache.interceptors.OptimisticTxInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.interceptors.PassivationInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.ReplicationInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class InterceptorChainFactoryTest
extends InterceptorChainTestBase {
    CacheSPI cache = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode("LOCAL");
        this.cache.getConfiguration().setUseLazyDeserialization(false);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
        }
    }

    public void testBareConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testBareConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)5, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testTxConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testTxConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)5, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    protected CacheLoaderConfig getCacheLoaderConfig(boolean pasv, boolean fetchPersistentState) throws Exception {
        String xml = "            <config>\n                \n                <passivation>" + pasv + "</passivation>\n" + "                <preload></preload>\n" + "\n" + "                <cacheloader>\n" + "                    <class>org.jboss.cache.loader.FileCacheLoader</class>\n" + "                    <properties>\n" + "                        location=/tmp\n" + "                    </properties>\n" + "                    <async>false</async>\n" + "                    <fetchPersistentState>" + fetchPersistentState + "</fetchPersistentState>\n" + "                    <ignoreModifications>false</ignoreModifications>\n" + "                </cacheloader>\n" + "                \n" + "            </config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    public void testSharedCacheLoaderConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(false, false));
        this.cache.getConfiguration().setCacheMode("REPL_ASYNC");
        this.cache.getConfiguration().setFetchInMemoryState(false);
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testSharedCacheLoaderConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheLoaderInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheStoreInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testUnsharedCacheLoaderConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(false, true));
        this.cache.getConfiguration().setCacheMode("REPL_ASYNC");
        this.cache.getConfiguration().setFetchInMemoryState(false);
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testUnsharedCacheLoaderConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheLoaderInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheStoreInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testTxAndRepl() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setCacheMode("repl_sync");
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testTxAndRepl interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testOptimisticChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingOptimistic(true);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testOptimisticReplicatedChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingOptimistic(true);
        this.cache.getConfiguration().setCacheMode("REPL_SYNC");
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)9, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testOptimisticCacheLoaderChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingOptimistic(true);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(false, false));
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)10, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheLoaderInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheStoreInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testOptimisticPassivationCacheLoaderChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingOptimistic(true);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(true, false));
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)10, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ActivationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PassivationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testInvalidationInterceptorChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setCacheMode("REPL_ASYNC");
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setCacheMode("INVALIDATION_ASYNC");
        chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        list = chain.asList();
        interceptors = list.iterator();
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(InvalidationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testCacheMgmtConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(true);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testCacheMgmtConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheMgmtInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testEvictionInterceptorConfig() throws Exception {
        this.cache.getConfiguration().setEvictionConfig(new EvictionConfig(){
            private static final long serialVersionUID = -6644183636899605065L;

            public boolean isValidConfig() {
                return true;
            }
        });
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testEvictionInterceptorConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)7, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheMgmtInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(EvictionInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testBuddyReplicationOptLocking() throws Exception {
        String xmlString = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled>\n<buddyCommunicationTimeout>600000</buddyCommunicationTimeout>\n          <buddyLocatorClass>org.jboss.cache.buddyreplication.NextMemberBuddyLocator</buddyLocatorClass>\n          <buddyLocatorProperties>numBuddies = 1</buddyLocatorProperties>\n";
        xmlString = xmlString + "<buddyPoolName>buddyPoolName</buddyPoolName>";
        xmlString = xmlString + "</config>";
        Element element = XmlHelper.stringToElement((String)xmlString);
        BuddyReplicationConfig brc = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.cache.getConfiguration().setCacheMode("REPL_SYNC");
        this.cache.getConfiguration().setNodeLockingScheme("OPTIMISTIC");
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testEvictionInterceptorConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)11, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheMgmtInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(DataGravitatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testBuddyReplicationPessLocking() throws Exception {
        String xmlString = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled>\n<buddyCommunicationTimeout>600000</buddyCommunicationTimeout>\n          <buddyLocatorClass>org.jboss.cache.buddyreplication.NextMemberBuddyLocator</buddyLocatorClass>\n          <buddyLocatorProperties>numBuddies = 1</buddyLocatorProperties>\n";
        xmlString = xmlString + "<buddyPoolName>buddyPoolName</buddyPoolName>";
        xmlString = xmlString + "</config>";
        Element element = XmlHelper.stringToElement((String)xmlString);
        BuddyReplicationConfig brc = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.cache.getConfiguration().setCacheMode("REPL_SYNC");
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testEvictionInterceptorConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheMgmtInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(DataGravitatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    private InterceptorChainFactory getInterceptorChainFactory(Cache cache) {
        return InterceptorChainFactory.getInstance((ComponentRegistry)TestingUtil.extractComponentRegistry(cache), (Configuration)cache.getConfiguration());
    }
}

