/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.SuspectException;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class LifeCycleTest {
    private CacheSPI[] c;

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches((Cache[])this.c);
        this.c = null;
    }

    private void createAndRegisterCache(Configuration.CacheMode mode, boolean start) throws Exception {
        CacheSPI<Object, Object> cache = this.createCache(mode);
        LinkedList<Object> caches = new LinkedList<Object>();
        if (this.c != null) {
            caches.addAll(Arrays.asList(this.c));
        }
        caches.add(cache);
        this.c = caches.toArray(new CacheSPI[0]);
        if (start) {
            cache.start();
            if (this.c.length > 1) {
                TestingUtil.blockUntilViewsReceived(this.c, 10000L);
            }
        }
    }

    public void testLocalRestartNoTransactions() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, true);
        this.c[0].put("/a/b/c", null);
        AssertJUnit.assertTrue((this.c[0].getNumberOfNodes() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
        this.restartCache(this.c[0]);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
    }

    public void testLocalRestartWithTransactions() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, true);
        TransactionManager tm = this.beginTransaction();
        this.c[0].put("/a/b/c", null);
        AssertJUnit.assertTrue((this.c[0].getNumberOfNodes() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)4, (int)this.c[0].getNumberOfLocksHeld());
        this.restartCache(this.c[0]);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfNodes());
        tm.rollback();
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
    }

    public void testStartNoCreate() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, false);
        this.c[0].start();
        this.c[0].put("/a/b/c", null);
        AssertJUnit.assertTrue((this.c[0].getNumberOfNodes() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
        this.restartCache(this.c[0]);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
    }

    public void testReStartNoCreate() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, false);
        this.c[0].start();
        this.c[0].stop();
        this.c[0].start();
        this.c[0].put("/a/b/c", null);
        AssertJUnit.assertTrue((this.c[0].getNumberOfNodes() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
        this.restartCache(this.c[0]);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
    }

    public void testDuplicateInvocation() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, false);
        this.c[0].create();
        this.c[0].start();
        this.c[0].create();
        this.c[0].start();
        this.c[0].put("/a/b/c", null);
        AssertJUnit.assertTrue((this.c[0].getNumberOfNodes() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
        this.restartCache(this.c[0]);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
        this.c[0].stop();
        this.c[0].destroy();
        this.c[0].stop();
        this.c[0].destroy();
    }

    public void testFailedStart() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, false);
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.INSTANTIATED, (Object)this.c[0].getCacheStatus());
        DisruptLifecycleListener listener = new DisruptLifecycleListener();
        this.c[0].addCacheListener((Object)listener);
        this.c[0].create();
        listener.disrupt = true;
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.CREATED, (Object)this.c[0].getCacheStatus());
        try {
            this.c[0].start();
            AssertJUnit.fail((String)"Listener did not prevent start");
        }
        catch (CacheException good) {
            // empty catch block
        }
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.FAILED, (Object)this.c[0].getCacheStatus());
        this.c[0].addCacheListener((Object)listener);
        listener.disrupt = false;
        this.c[0].start();
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.STARTED, (Object)this.c[0].getCacheStatus());
        this.c[0].put("/a/b/c", null);
        AssertJUnit.assertTrue((this.c[0].getNumberOfNodes() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)this.c[0].getNumberOfLocksHeld());
        listener.disrupt = true;
        this.c[0].addCacheListener((Object)listener);
        try {
            this.c[0].stop();
            AssertJUnit.fail((String)"Listener did not prevent stop");
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.FAILED, (Object)this.c[0].getCacheStatus());
        listener.disrupt = false;
        this.c[0].stop();
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.STOPPED, (Object)this.c[0].getCacheStatus());
        this.c[0].destroy();
        AssertJUnit.assertEquals((String)"Correct state", (Object)CacheStatus.DESTROYED, (Object)this.c[0].getCacheStatus());
    }

    public void testInvalidStateInvocations() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, false);
        try {
            this.c[0].get(Fqn.ROOT, (Object)"k");
            AssertJUnit.fail((String)"Cache isn't ready!");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        this.c[0].create();
        try {
            this.c[0].get(Fqn.ROOT, (Object)"k");
            AssertJUnit.fail((String)"Cache isn't ready!");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        this.c[0].start();
        this.c[0].get(Fqn.ROOT, (Object)"k");
        this.c[0].stop();
        try {
            this.c[0].get(Fqn.ROOT, (Object)"k");
            AssertJUnit.fail((String)"Cache isn't ready!");
        }
        catch (IllegalStateException good) {
            // empty catch block
        }
        this.c[0].destroy();
        try {
            this.c[0].get(Fqn.ROOT, (Object)"k");
            AssertJUnit.fail((String)"Cache isn't ready!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoteInvalidStateInvocations() throws Exception {
        ComponentRegistry cr1;
        this.createAndRegisterCache(Configuration.CacheMode.REPL_SYNC, true);
        this.createAndRegisterCache(Configuration.CacheMode.REPL_SYNC, true);
        try {
            cr1 = TestingUtil.extractComponentRegistry((Cache)this.c[1]);
            cr1.state = CacheStatus.STOPPING;
            this.c[0].put(Fqn.ROOT, (Object)"k", (Object)"v");
        }
        catch (Throwable throwable) {
            ComponentRegistry cr12 = TestingUtil.extractComponentRegistry((Cache)this.c[1]);
            cr12.state = CacheStatus.STARTED;
            throw throwable;
        }
        cr1 = TestingUtil.extractComponentRegistry((Cache)this.c[1]);
        cr1.state = CacheStatus.STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoteInvalidStateInvocations2() throws Exception {
        ComponentRegistry cr1;
        this.createAndRegisterCache(Configuration.CacheMode.REPL_SYNC, true);
        this.createAndRegisterCache(Configuration.CacheMode.REPL_SYNC, true);
        TestingUtil.blockUntilViewsReceived(this.c, 10000L);
        try {
            TestingUtil.blockUntilCacheStatusAchieved((Cache)this.c[1], CacheStatus.STARTED, 1000L);
            cr1 = TestingUtil.extractComponentRegistry((Cache)this.c[1]);
            cr1.state = CacheStatus.STARTING;
            try {
                this.c[0].put(Fqn.ROOT, (Object)"k", (Object)"v");
                AssertJUnit.fail((String)"Should barf!");
            }
            catch (Exception good) {
                // empty catch block
            }
            int sleepTime = 500;
            new Thread(){

                public void run() {
                    TestingUtil.sleepThread(500L);
                    ComponentRegistry cr1 = TestingUtil.extractComponentRegistry((Cache)LifeCycleTest.this.c[1]);
                    cr1.state = CacheStatus.STARTED;
                }
            }.start();
            long startTime = System.currentTimeMillis();
            this.c[0].put(Fqn.ROOT, (Object)"k", (Object)"v");
            assert (System.currentTimeMillis() > startTime + 500L) : "Should wait till c[1] has STARTED state";
        }
        catch (Throwable throwable) {
            ComponentRegistry cr12 = TestingUtil.extractComponentRegistry((Cache)this.c[1]);
            cr12.state = CacheStatus.STARTED;
            throw throwable;
        }
        cr1 = TestingUtil.extractComponentRegistry((Cache)this.c[1]);
        cr1.state = CacheStatus.STARTED;
    }

    public void testInvalidStateTxCommit() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, true);
        this.c[0].getTransactionManager().begin();
        this.c[0].put(Fqn.ROOT, (Object)"k1", (Object)"v1");
        this.c[0].put(Fqn.ROOT, (Object)"k2", (Object)"v2");
        ComponentRegistry cr0 = TestingUtil.extractComponentRegistry((Cache)this.c[0]);
        cr0.state = CacheStatus.STOPPING;
        try {
            this.c[0].getTransactionManager().commit();
            AssertJUnit.fail((String)"Cache isn't STARTED!");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    public void testStopInstanceWhileOtherInstanceSends() throws Exception {
        final Fqn fqn = Fqn.fromString((String)"/a");
        final LinkedList<Boolean> running = new LinkedList<Boolean>();
        final LinkedList exceptions = new LinkedList();
        running.add(true);
        this.createAndRegisterCache(Configuration.CacheMode.REPL_SYNC, true);
        this.createAndRegisterCache(Configuration.CacheMode.REPL_SYNC, true);
        this.c[0].put(fqn, (Object)"k", (Object)"v");
        assert ("v".equals(this.c[0].get(fqn, (Object)"k")));
        assert ("v".equals(this.c[1].get(fqn, (Object)"k")));
        Thread updater = new Thread(){

            public void run() {
                int i = 0;
                while (((Boolean)running.get(0)).booleanValue()) {
                    try {
                        ++i;
                        if (((Boolean)running.get(0)).booleanValue()) {
                            LifeCycleTest.this.c[1].put(fqn, (Object)"k", (Object)("v" + i));
                        }
                    }
                    catch (ReplicationException re) {
                    }
                    catch (SuspectException se) {
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                    TestingUtil.sleepThread(20L);
                }
            }
        };
        updater.start();
        this.c[0].stop();
        running.add(false);
        running.remove(true);
        updater.join();
        Iterator i$ = exceptions.iterator();
        if (i$.hasNext()) {
            Exception e = (Exception)i$.next();
            throw e;
        }
    }

    public void testInvalidStateTxRollback() throws Exception {
        this.createAndRegisterCache(Configuration.CacheMode.LOCAL, true);
        this.c[0].getTransactionManager().begin();
        this.c[0].put(Fqn.ROOT, (Object)"k1", (Object)"v1");
        this.c[0].put(Fqn.ROOT, (Object)"k2", (Object)"v2");
        ComponentRegistry cr0 = TestingUtil.extractComponentRegistry((Cache)this.c[0]);
        cr0.state = CacheStatus.STOPPING;
        this.c[0].getTransactionManager().rollback();
    }

    private CacheSPI<Object, Object> createCache(Configuration.CacheMode cache_mode) {
        CacheSPI retval = (CacheSPI)new DefaultCacheFactory().createCache(false);
        retval.getConfiguration().setCacheMode(cache_mode);
        retval.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        return retval;
    }

    private TransactionManager beginTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.c[0].getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }

    private void startCache(CacheSPI c) {
        c.create();
        c.start();
    }

    private void stopCache(CacheSPI c) {
        c.stop();
        c.destroy();
    }

    private void restartCache(CacheSPI c) throws Exception {
        this.stopCache(c);
        this.startCache(c);
    }

    @CacheListener
    public class DisruptLifecycleListener {
        private boolean disrupt;

        @CacheStarted
        public void cacheStarted(Event e) {
            if (this.disrupt) {
                throw new IllegalStateException("I don't want to start");
            }
        }

        @CacheStopped
        public void cacheStopped(Event e) {
            if (this.disrupt) {
                throw new IllegalStateException("I don't want to stop");
            }
        }

        public void setDisrupt(boolean disrupt) {
            this.disrupt = disrupt;
        }
    }
}

