/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.LinkedList;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.DummyEvictionConfiguration;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class EvictionInterceptorTest {
    private static final String fqn1 = "/a/b/c";
    private static final String fqn2 = "/a/b";
    private static final String fqn3 = "/a/b/d";
    private static final String fqn4 = "/d/e/f";
    private CacheSPI<Object, Object> cache;
    private InterceptorChain invoker;
    private RegionManager regionManager;
    private CommandsFactory commandsFactory;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.getConfiguration().setCacheMode("LOCAL");
        EvictionConfig ec = new EvictionConfig();
        LinkedList<EvictionRegionConfig> ercs = new LinkedList<EvictionRegionConfig>();
        ercs.add(new EvictionRegionConfig(Fqn.ROOT, (EvictionPolicyConfig)new DummyEvictionConfiguration()));
        ercs.add(new EvictionRegionConfig(Fqn.fromString((String)fqn1), (EvictionPolicyConfig)new DummyEvictionConfiguration()));
        ercs.add(new EvictionRegionConfig(Fqn.fromString((String)"/a/b/c/d"), (EvictionPolicyConfig)new DummyEvictionConfiguration()));
        ercs.add(new EvictionRegionConfig(Fqn.fromString((String)fqn2), (EvictionPolicyConfig)new DummyEvictionConfiguration()));
        ercs.add(new EvictionRegionConfig(Fqn.fromString((String)fqn4), (EvictionPolicyConfig)new DummyEvictionConfiguration()));
        ercs.add(new EvictionRegionConfig(Fqn.fromString((String)"/d/e/g"), (EvictionPolicyConfig)new DummyEvictionConfiguration()));
        ercs.add(new EvictionRegionConfig(Fqn.fromString((String)"/d/e"), (EvictionPolicyConfig)new DummyEvictionConfiguration()));
        ec.setEvictionRegionConfigs(ercs);
        this.cache.getConfiguration().setEvictionConfig(ec);
        this.cache.start();
        this.invoker = (InterceptorChain)TestingUtil.extractComponentRegistry(this.cache).getComponent(InterceptorChain.class);
        this.commandsFactory = TestingUtil.extractCommandsFactory(this.cache);
        this.regionManager = this.cache.getRegionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
    }

    private NodeSPI<Object, Object> cast(Node node) {
        return (NodeSPI)node;
    }

    public void testVisitNode() throws Throwable {
        int i;
        GetNodeCommand command = this.commandsFactory.buildGetNodeCommand(Fqn.fromString((String)fqn1));
        this.invoker.invoke((VisitableCommand)command);
        Region regionABC = this.regionManager.getRegion(fqn1, false);
        AssertJUnit.assertNull((Object)regionABC.takeLastEventNode());
        this.putQuietly(fqn1, (Object)"key", (Object)"value");
        NodeSPI<Object, Object> node = this.cast((Node)this.cache.peek(Fqn.fromString((String)fqn1), false, false));
        AssertJUnit.assertNotNull(node);
        AssertJUnit.assertEquals((Object)"value", (Object)node.getDirect((Object)"key"));
        this.putQuietly(fqn3, (Object)"key", (Object)"value");
        node = this.cast((Node)this.cache.peek(Fqn.fromString((String)fqn3), false, false));
        AssertJUnit.assertNotNull(node);
        AssertJUnit.assertEquals((Object)"value", (Object)node.getDirect((Object)"key"));
        command = this.commandsFactory.buildGetNodeCommand(Fqn.fromString((String)fqn1));
        this.invoker.invoke((VisitableCommand)command);
        regionABC = this.regionManager.getRegion(fqn1, false);
        EvictedEventNode event = regionABC.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((String)fqn1, (String)event.getFqn().toString());
        AssertJUnit.assertNull((Object)regionABC.takeLastEventNode());
        command = this.commandsFactory.buildGetNodeCommand(Fqn.fromString((String)fqn2));
        this.invoker.invoke((VisitableCommand)command);
        Region regionAB = this.regionManager.getRegion(fqn2, false);
        event = regionAB.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((String)fqn2, (String)event.getFqn().toString());
        AssertJUnit.assertNull((Object)regionAB.takeLastEventNode());
        command = this.commandsFactory.buildGetNodeCommand(Fqn.fromString((String)fqn3));
        this.invoker.invoke((VisitableCommand)command);
        Region regionABD = this.regionManager.getRegion(fqn3, false);
        event = regionABD.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((String)fqn3, (String)event.getFqn().toString());
        AssertJUnit.assertNull((Object)regionABD.takeLastEventNode());
        for (i = 0; i < 10; ++i) {
            command = this.commandsFactory.buildGetNodeCommand(Fqn.fromString((String)fqn3));
            this.invoker.invoke((VisitableCommand)command);
        }
        for (i = 0; i < 10; ++i) {
            Region region = this.regionManager.getRegion(fqn3, false);
            event = region.takeLastEventNode();
            AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
            AssertJUnit.assertEquals((String)fqn3, (String)event.getFqn().toString());
        }
        AssertJUnit.assertNull((Object)this.regionManager.getRegion(fqn3, false).takeLastEventNode());
        command = this.commandsFactory.buildGetDataMapCommand(null);
        this.invoker.invoke((VisitableCommand)command);
    }

    private void putQuietly(String fqn, Object key, Object value) {
        this.putQuietly(Fqn.fromString((String)fqn), key, value);
    }

    private void putQuietly(Fqn fqn, Object key, Object value) {
        NodeSPI root;
        NodeSPI child = root = this.cache.getRoot();
        for (int i = 0; i < fqn.size(); ++i) {
            child = child.addChildDirect(Fqn.fromElements((Object[])new Object[]{fqn.get(i)}));
        }
        assert (child.getFqn().equals((Object)fqn));
        child.putDirect(key, value);
    }

    public void testVisitElement() throws Throwable {
        int i;
        Fqn fqn = Fqn.fromString((String)fqn4);
        Object key = "key";
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(fqn, key, false);
        this.invoker.invoke((VisitableCommand)command);
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        this.putQuietly(fqn, (Object)"wrongkey", (Object)"");
        command = this.commandsFactory.buildGetKeyValueCommand(fqn, key, false);
        this.invoker.invoke((VisitableCommand)command);
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        command = this.commandsFactory.buildGetKeyValueCommand(fqn, (Object)"wrongkey", false);
        this.invoker.invoke((VisitableCommand)command);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        this.putQuietly(fqn4, key, (Object)"value");
        fqn = Fqn.fromString((String)fqn4);
        command = this.commandsFactory.buildGetKeyValueCommand(fqn, key, false);
        this.invoker.invoke((VisitableCommand)command);
        region = this.regionManager.getRegion(fqn.toString(), false);
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        fqn = Fqn.fromString((String)"/d/e/g");
        for (i = 0; i < 100; ++i) {
            key = i;
            this.putQuietly("/d/e/g", key, (Object)"");
            command = this.commandsFactory.buildGetKeyValueCommand(fqn, key, false);
            this.invoker.invoke((VisitableCommand)command);
        }
        region = this.regionManager.getRegion(fqn.toString(), false);
        for (i = 0; i < 100; ++i) {
            event = region.takeLastEventNode();
            AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
            AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        }
        this.putQuietly(fqn1, key, (Object)"");
        fqn = Fqn.fromString((String)fqn1);
        command = this.commandsFactory.buildGetKeyValueCommand(fqn, key, false);
        this.invoker.invoke((VisitableCommand)command);
        region = this.regionManager.getRegion(fqn.toString(), false);
        event = region.takeLastEventNode();
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        for (i = 0; i < 100; ++i) {
            key = i;
            this.putQuietly(fqn, key, (Object)"");
            command = this.commandsFactory.buildGetKeyValueCommand(fqn, key, false);
            this.invoker.invoke((VisitableCommand)command);
        }
        for (i = 0; i < 100; ++i) {
            event = region.takeLastEventNode();
            AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
            AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        }
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
    }

    public void testCreateNode() throws Throwable {
        int i;
        HashMap<Integer, Integer> data = new HashMap<Integer, Integer>();
        for (int i2 = 0; i2 < 100; ++i2) {
            data.put(i2, i2);
        }
        Fqn fqn = Fqn.fromString((String)fqn1);
        PutDataMapCommand putDataMapCommand = this.commandsFactory.buildPutDataMapCommand(null, fqn, data);
        this.invoker.invoke((VisitableCommand)putDataMapCommand);
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)100, (int)event.getElementDifference());
        NodeSPI<Object, Object> node = this.cast((Node)this.cache.peek(fqn, false, false));
        AssertJUnit.assertNotNull(node);
        for (i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)node.getDataDirect().containsKey(i));
            AssertJUnit.assertEquals((Object)i, (Object)node.getDirect((Object)i));
        }
        for (i = 0; i < 100; ++i) {
            PutKeyValueCommand pkvCommand = this.commandsFactory.buildPutKeyValueCommand(null, fqn, (Object)i, (Object)"value");
            this.invoker.invoke((VisitableCommand)pkvCommand);
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache.peek(fqn, false, false).getDirect((Object)i));
        }
        for (i = 0; i < 100; ++i) {
            event = region.takeLastEventNode();
            AssertJUnit.assertNotNull((Object)event);
            AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
            AssertJUnit.assertEquals((Object)NodeEventType.ADD_ELEMENT_EVENT, (Object)event.getEventType());
        }
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        fqn = Fqn.fromString((String)fqn2);
        PutDataMapCommand putCommand = this.commandsFactory.buildPutDataMapCommand(null, fqn, data);
        this.invoker.invoke((VisitableCommand)putCommand);
        event = this.regionManager.getRegion(fqn.toString(), false).takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)100, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)this.regionManager.getRegion(fqn.toString(), false).takeLastEventNode());
        node = this.cast((Node)this.cache.peek(fqn, false, false));
        AssertJUnit.assertEquals((int)100, (int)node.getDataDirect().size());
        AssertJUnit.assertNotNull(node);
        for (int i3 = 0; i3 < 100; ++i3) {
            AssertJUnit.assertTrue((boolean)node.getDataDirect().containsKey(i3));
            AssertJUnit.assertEquals((Object)i3, (Object)node.getDirect((Object)i3));
        }
        PutDataMapCommand putDataMap = this.commandsFactory.buildPutDataMapCommand(null, fqn, data);
        this.invoker.invoke((VisitableCommand)putDataMap);
        event = this.regionManager.getRegion(fqn.toString(), false).takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)100, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)this.regionManager.getRegion(fqn.toString(), false).takeLastEventNode());
        node = this.cast((Node)this.cache.getNode(fqn));
        AssertJUnit.assertEquals((int)100, (int)node.getData().size());
        AssertJUnit.assertNotNull(node);
        for (int i4 = 0; i4 < 100; ++i4) {
            AssertJUnit.assertTrue((boolean)node.getDataDirect().containsKey(i4));
            AssertJUnit.assertEquals((Object)i4, (Object)node.getDirect((Object)i4));
        }
    }

    public void testCreateElement() throws Throwable {
        Fqn fqn = Fqn.fromString((String)fqn4);
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        String key = "key";
        String value = "value";
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(null, fqn, (Object)key, (Object)value);
        this.invoker.invoke((VisitableCommand)command);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.peek(fqn, false, false).getDirect((Object)key));
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.peek(fqn, false, false).getDirect((Object)key));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        command = this.commandsFactory.buildPutKeyValueCommand(null, fqn, (Object)key, (Object)value);
        this.invoker.invoke((VisitableCommand)command);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.peek(fqn, false, false).getDirect((Object)key));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.peek(fqn, false, false).getDirect((Object)key));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
    }

    public void testRemoveNode() throws Throwable {
        Fqn fqn = Fqn.fromString((String)fqn1);
        this.putQuietly(fqn, (Object)"a", (Object)"b");
        this.putQuietly(fqn, (Object)"b", (Object)"c");
        ClearDataCommand clearDataCommand = this.commandsFactory.buildClearDataCommand(null, fqn);
        this.invoker.invoke((VisitableCommand)clearDataCommand);
        AssertJUnit.assertEquals((int)0, (int)this.cache.peek(fqn, false, false).getDataDirect().size());
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        RemoveNodeCommand removeNodeCommand = this.commandsFactory.buildRemoveNodeCommand(null, fqn);
        this.invoker.invoke((VisitableCommand)removeNodeCommand);
        AssertJUnit.assertNull((Object)this.cache.peek(fqn, false, false));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
    }

    public void testRemoveElement() throws Throwable {
        Fqn fqn = Fqn.fromString((String)fqn1);
        this.putQuietly(fqn, (Object)"a", (Object)"b");
        this.putQuietly(fqn, (Object)"b", (Object)"c");
        RemoveKeyCommand removeKeyCommand = this.commandsFactory.buildRemoveKeyCommand(null, fqn, (Object)"a");
        this.invoker.invoke((VisitableCommand)removeKeyCommand);
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)"a"));
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        RemoveKeyCommand removeKeyCommand2 = this.commandsFactory.buildRemoveKeyCommand(null, fqn, (Object)"b");
        this.invoker.invoke((VisitableCommand)removeKeyCommand2);
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)"b"));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        RemoveKeyCommand removeKeyCommand3 = this.commandsFactory.buildRemoveKeyCommand(null, fqn, (Object)"a");
        this.invoker.invoke((VisitableCommand)removeKeyCommand3);
        event = region.takeLastEventNode();
        AssertJUnit.assertNull((Object)event);
    }

    public void testMixedEvent() throws Throwable {
        HashMap<Integer, Integer> data = new HashMap<Integer, Integer>();
        for (int i = 0; i < 100; ++i) {
            data.put(i, i);
        }
        Fqn fqn = Fqn.fromString((String)fqn1);
        PutDataMapCommand putDataCommand = this.commandsFactory.buildPutDataMapCommand(null, fqn, data);
        this.invoker.invoke((VisitableCommand)putDataCommand);
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)100, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        GetNodeCommand getNodeCommand = this.commandsFactory.buildGetNodeCommand(fqn);
        this.invoker.invoke((VisitableCommand)getNodeCommand);
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        RemoveNodeCommand removeNodeCommand = this.commandsFactory.buildRemoveNodeCommand(null, fqn);
        this.invoker.invoke((VisitableCommand)removeNodeCommand);
        AssertJUnit.assertNull((Object)this.cache.getNode(fqn));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        String key = "key";
        String value = "value";
        PutKeyValueCommand putKeyValueCommand = this.commandsFactory.buildPutKeyValueCommand(null, fqn, (Object)key, (Object)value);
        this.invoker.invoke((VisitableCommand)putKeyValueCommand);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.peek(fqn, false, false).getDirect((Object)key));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.peek(fqn, false, false).getDirect((Object)key));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        GetKeyValueCommand getKeyValueCommand = this.commandsFactory.buildGetKeyValueCommand(fqn, (Object)key, false);
        this.invoker.invoke((VisitableCommand)getKeyValueCommand);
        region = this.regionManager.getRegion(fqn.toString(), false);
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        RemoveKeyCommand removeKeyCommand = this.commandsFactory.buildRemoveKeyCommand(null, fqn, (Object)key);
        this.invoker.invoke((VisitableCommand)removeKeyCommand);
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)key));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
    }
}

