/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocation;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.interceptors.InvalidationInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"unit"})
public class InterceptorChainTest {
    private CommandInterceptor icInterceptor;
    private CommandInterceptor invalidationInterceptor;
    private CommandInterceptor txInterceptor;
    private CommandInterceptor pessimisticInterceptor;
    private CommandInterceptor callInterceptor;
    private InterceptorChain chain;

    @BeforeMethod
    public void setUp() {
        this.icInterceptor = this.create(InvocationContextInterceptor.class);
        this.invalidationInterceptor = this.create(InvalidationInterceptor.class);
        this.txInterceptor = this.create(TxInterceptor.class);
        this.pessimisticInterceptor = this.create(PessimisticLockInterceptor.class);
        this.callInterceptor = this.create(CallInterceptor.class);
        this.chain = new InterceptorChain(this.icInterceptor);
    }

    public void testGetIntercpetorsAsList() throws Throwable {
        this.invalidationInterceptor.setNext(this.txInterceptor);
        this.txInterceptor.setNext(this.pessimisticInterceptor);
        this.pessimisticInterceptor.setNext(this.callInterceptor);
        InterceptorChain chain = new InterceptorChain(this.invalidationInterceptor);
        ArrayList<CommandInterceptor> expectedList = new ArrayList<CommandInterceptor>();
        expectedList.add(this.invalidationInterceptor);
        expectedList.add(this.txInterceptor);
        expectedList.add(this.pessimisticInterceptor);
        expectedList.add(this.callInterceptor);
        assert (((Object)chain.asList()).equals(expectedList));
    }

    public void testAddAtPosition() throws Throwable {
        this.chain.addInterceptor(this.invalidationInterceptor, 1);
        assert (this.invalidationInterceptor.equals(this.icInterceptor.getNext()));
        this.chain.addInterceptor(this.pessimisticInterceptor, 1);
        assert (this.pessimisticInterceptor.equals(this.icInterceptor.getNext()));
        assert (this.invalidationInterceptor.equals(this.pessimisticInterceptor.getNext()));
        assert (this.invalidationInterceptor.getNext() == null);
        this.chain.addInterceptor(this.callInterceptor, 3);
        assert (this.invalidationInterceptor.getNext().equals(this.callInterceptor));
    }

    public void testAddAtPositionIncremented() {
        this.chain.addInterceptor(this.txInterceptor, 1);
        this.chain.addInterceptor(this.invalidationInterceptor, 2);
        this.chain.addInterceptor(this.pessimisticInterceptor, 3);
        this.chain.addInterceptor(this.callInterceptor, 4);
        assert (this.icInterceptor.getNext().equals(this.txInterceptor));
        assert (this.txInterceptor.getNext().equals(this.invalidationInterceptor));
        assert (this.invalidationInterceptor.getNext().equals(this.pessimisticInterceptor));
        assert (this.pessimisticInterceptor.getNext().equals(this.callInterceptor));
    }

    public void testRemoveAtPostion() throws Throwable {
        this.chain.addInterceptor(this.txInterceptor, 1);
        this.chain.addInterceptor(this.invalidationInterceptor, 2);
        this.chain.addInterceptor(this.pessimisticInterceptor, 3);
        this.chain.addInterceptor(this.callInterceptor, 4);
        this.chain.removeInterceptor(4);
        assert (this.chain.size() == 4);
        assert (this.pessimisticInterceptor.getNext() == null);
        this.chain.removeInterceptor(0);
        assert (this.chain.size() == 3);
        this.chain.getFirstInChain().equals(this.txInterceptor);
        this.chain.removeInterceptor(1);
        assert (this.chain.size() == 2);
        assert (this.txInterceptor.getNext().equals(this.pessimisticInterceptor));
    }

    public void testGetSize() {
        assert (this.chain.size() == 1);
        this.chain.addInterceptor(this.txInterceptor, 1);
        assert (this.chain.size() == 2);
        this.chain.addInterceptor(this.invalidationInterceptor, 2);
        assert (this.chain.size() == 3);
        this.chain.addInterceptor(this.pessimisticInterceptor, 3);
        assert (this.chain.size() == 4);
        this.chain.addInterceptor(this.callInterceptor, 4);
        assert (this.chain.size() == 5);
    }

    public void testAppendInterceptor() {
        this.chain.appendIntereceptor(this.txInterceptor);
        assert (this.chain.size() == 2);
        assert (this.icInterceptor.getNext().equals(this.txInterceptor));
        this.chain.appendIntereceptor(this.invalidationInterceptor);
        assert (this.chain.size() == 3);
        assert (this.txInterceptor.getNext().equals(this.invalidationInterceptor));
    }

    public void testGetInterceptorsWhichExtend() {
        InvocationContextInterceptor ic2 = (InvocationContextInterceptor)this.create(InvocationContextInterceptor.class);
        this.chain.appendIntereceptor((CommandInterceptor)ic2);
        List result = this.chain.getInterceptorsWhichExtend(InvocationContextInterceptor.class);
        assert (result.contains(this.icInterceptor));
        assert (result.contains(ic2));
        assert (result.size() == 2);
        result = this.chain.getInterceptorsWhichExtend(CommandInterceptor.class);
        assert (result.size() == this.chain.asList().size());
    }

    public void removeInterceptorWithtType() {
        this.chain.addInterceptor(this.txInterceptor, 1);
        this.chain.addInterceptor(this.invalidationInterceptor, 2);
        this.chain.addInterceptor(this.pessimisticInterceptor, 3);
        this.chain.addInterceptor(this.callInterceptor, 4);
        this.chain.removeInterceptor(InvalidationInterceptor.class);
        assert (this.chain.size() == 4);
        assert (this.txInterceptor.getNext().equals(this.pessimisticInterceptor));
        this.chain.removeInterceptor(InvocationContextInterceptor.class);
        assert (this.chain.size() == 3);
        assert (this.chain.getFirstInChain().equals(this.txInterceptor));
        this.chain.removeInterceptor(CallInterceptor.class);
        assert (this.chain.size() == 2);
        assert (this.pessimisticInterceptor.getNext() == null);
    }

    public void addInterceptorWithType() {
        assert (this.chain.addInterceptor(this.invalidationInterceptor, this.icInterceptor.getClass()));
        assert (this.icInterceptor.getNext().equals(this.invalidationInterceptor));
        this.chain.addInterceptor(this.txInterceptor, this.icInterceptor.getClass());
        assert (this.icInterceptor.getNext().equals(this.txInterceptor));
        assert (this.txInterceptor.getNext().equals(this.invalidationInterceptor));
    }

    private CommandInterceptor create(Class<? extends CommandInterceptor> toInstantiate) {
        try {
            return toInstantiate.newInstance();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }
}

