/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class InterceptorSynchronizationTest {
    final int CACHELOADER_WAITTIME = 2000;
    final int numThreadsPerTopLevelNode = 5;

    public void testBlockingProblem() throws Exception {
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setCacheLoader((CacheLoader)new TestSlowCacheLoader());
        clc.addIndividualCacheLoaderConfig(iclc);
        cache.getConfiguration().setCacheLoaderConfig(clc);
        cache.start();
        long begin = System.currentTimeMillis();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 5; ++i) {
            Thread thread = new Thread(new Retriever(cache, "/Moo/" + i));
            threads.add(thread);
            Thread thread2 = new Thread(new Retriever(cache, "/Meow/" + i));
            threads.add(thread2);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        long end = System.currentTimeMillis();
        long timeTaken = end - begin;
        int totalTimeExpectedToWaitIfNotSerialized = 6000;
        AssertJUnit.assertTrue((String)("If it was parallel, it should have finished quicker than this:" + timeTaken), (timeTaken < (long)totalTimeExpectedToWaitIfNotSerialized ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Retriever
    implements Runnable {
        private final String fqn;
        private CacheSPI<Object, Object> cache;

        private Retriever(CacheSPI<Object, Object> cache, String fqn) {
            this.fqn = fqn;
            this.cache = cache;
        }

        @Override
        public void run() {
            try {
                this.cache.get(this.fqn, (Object)"foo");
            }
            catch (CacheException e) {
                throw new RuntimeException("Unexpected", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestSlowCacheLoader
    extends AbstractCacheLoader {
        public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        }

        public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
            return null;
        }

        public Set<?> getChildrenNames(Fqn arg0) throws Exception {
            return null;
        }

        public Object get(Fqn arg0, Object arg1) {
            return null;
        }

        public Map<Object, Object> get(Fqn arg0) throws Exception {
            Thread.sleep(2000L);
            return Collections.singletonMap("foo", "bar");
        }

        public boolean exists(Fqn arg0) throws Exception {
            return true;
        }

        public Object put(Fqn arg0, Object arg1, Object arg2) throws Exception {
            return null;
        }

        public void put(Fqn arg0, Map arg1) throws Exception {
        }

        public void put(List<Modification> modifications) throws Exception {
        }

        public Object remove(Fqn arg0, Object arg1) throws Exception {
            return null;
        }

        public void remove(Fqn arg0) throws Exception {
        }

        public void removeData(Fqn arg0) throws Exception {
        }

        public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        }

        public void commit(Object arg0) throws Exception {
        }

        public void rollback(Object arg0) {
        }

        public void loadEntireState(ObjectOutputStream os) throws Exception {
        }

        public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        }

        public void storeEntireState(ObjectInputStream is) throws Exception {
        }

        public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        }

        public void create() throws Exception {
        }

        public void start() throws Exception {
        }

        public void stop() {
        }

        public void destroy() {
        }
    }
}

