/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.marshall.AbstractVersionAwareMarshallerTest;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class CacheMarshallerTestBase
extends AbstractVersionAwareMarshallerTest {
    protected String currentVersion;
    protected int currentVersionShort;
    protected Class expectedMarshallerClass;
    protected Class latestMarshallerClass = CacheMarshaller210.class;
    protected VersionAwareMarshaller marshaller;
    protected RegionManager regionManager;
    protected Configuration c;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.c = new Configuration();
        this.c.setUseRegionBasedMarshalling(false);
        this.c.setInactiveOnStartup(false);
        this.c.setReplVersionString(this.currentVersion);
        this.cr = new ComponentRegistry(this.c, (CacheSPI)new CacheInvocationDelegate());
        this.marshaller = this.createVAMandRestartCache(new RegionManager());
        this.regionManager = (RegionManager)this.cr.getComponent(RegionManager.class);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.marshaller = null;
    }

    protected void assertObjectArraysAreEqual(Object[] a1, Object[] a2) {
        AssertJUnit.assertEquals((String)"Number of args should match", (int)a1.length, (int)a2.length);
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] instanceof List && a2[i] instanceof List) {
                Object[] a1Elements = ((List)a1[i]).toArray();
                Object[] a2Elements = ((List)a2[i]).toArray();
                this.assertObjectArraysAreEqual(a1Elements, a2Elements);
                continue;
            }
            AssertJUnit.assertEquals((String)("Argument # " + i + " should be equal"), (Object)a1[i], (Object)a2[i]);
        }
    }

    public void testGetMarshaller() {
        AssertJUnit.assertEquals((String)"Only one marshaller should be in the map by this stage", (int)1, (int)this.marshaller.marshallers.size());
        AssertJUnit.assertEquals((Object)this.expectedMarshallerClass, this.marshaller.getMarshaller(this.currentVersionShort).getClass());
        assert (this.marshaller.defaultMarshaller.getClass().equals(this.expectedMarshallerClass));
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, this.marshaller.getMarshaller(15).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, this.marshaller.getMarshaller(1).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, this.marshaller.getMarshaller(-1).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, this.marshaller.getMarshaller(0).getClass());
        AssertJUnit.assertEquals(CacheMarshaller200.class, this.marshaller.getMarshaller(20).getClass());
        AssertJUnit.assertEquals(CacheMarshaller210.class, this.marshaller.getMarshaller(21).getClass());
        assert (this.marshaller.marshallers.size() == 2) : "Should have 2 marshallers now";
    }

    public void testStringBasedFqn() throws Exception {
        Fqn fqn = Fqn.fromElements((Object[])new String[]{"JSESSIONID", "1010.10.5:3000", "1234567890", "1"});
        byte[] asBytes = this.marshaller.objectToByteBuffer((Object)fqn);
        System.out.println("Marshalled to " + asBytes.length + " bytes");
        Object o2 = this.marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertEquals((Object)fqn, (Object)o2);
    }

    public void testNonStringBasedFqn() throws Exception {
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{Integer.valueOf(3), Boolean.valueOf(false)});
        byte[] asBytes = this.marshaller.objectToByteBuffer((Object)fqn);
        Object o2 = this.marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertEquals((Object)fqn, (Object)o2);
    }

    public void testMethodCall() throws Exception {
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{Integer.valueOf(3), Boolean.valueOf(false)});
        PutKeyValueCommand cmd = new PutKeyValueCommand(null, fqn, (Object)"key", (Object)"value");
        byte[] asBytes = this.marshaller.objectToByteBuffer((Object)cmd);
        Object o2 = this.marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertTrue((String)"Unmarshalled object should be a method call", (boolean)(o2 instanceof ReplicableCommand));
        ReplicableCommand cmd2 = (ReplicableCommand)o2;
        AssertJUnit.assertEquals((Object)cmd, (Object)cmd2);
    }

    public void testNestedMethodCall() throws Exception {
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{Integer.valueOf(3), Boolean.valueOf(false)});
        PutKeyValueCommand cmd = new PutKeyValueCommand(null, fqn, (Object)"key", (Object)"value");
        ReplicateCommand replicateCmd = new ReplicateCommand((ReplicableCommand)cmd);
        byte[] asBytes = this.marshaller.objectToByteBuffer((Object)replicateCmd);
        Object o2 = this.marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertTrue((String)"Unmarshalled object should be a method call", (boolean)(o2 instanceof ReplicableCommand));
        ReplicableCommand cmd2 = (ReplicableCommand)o2;
        AssertJUnit.assertEquals((Object)replicateCmd, (Object)cmd2);
    }

    public void testLargeString() throws Exception {
        this.doLargeStringTest(Short.MAX_VALUE, false);
    }

    public void testLargerString() throws Exception {
        this.doLargeStringTest(32768, false);
    }

    public void test64KString() throws Exception {
        this.doLargeStringTest(65526, false);
        this.doLargeStringTest(65546, false);
    }

    public void test128KString() throws Exception {
        this.doLargeStringTest(131062, false);
        this.doLargeStringTest(131082, false);
    }

    public void testLargeStringMultiByte() throws Exception {
        this.doLargeStringTest(Short.MAX_VALUE, true);
    }

    public void testLargerStringMultiByte() throws Exception {
        this.doLargeStringTest(32768, true);
    }

    public void test64KStringMultiByte() throws Exception {
        this.doLargeStringTest(65526, true);
        this.doLargeStringTest(65546, true);
    }

    public void test128KStringMultiByte() throws Exception {
        this.doLargeStringTest(131062, true);
        this.doLargeStringTest(131082, true);
    }

    protected void doLargeStringTest(int stringSize, boolean multiByteChars) throws Exception {
        StringBuilder sb = new StringBuilder();
        int startingChar = multiByteChars ? 210 : 65;
        for (int i = 0; i < stringSize; ++i) {
            sb.append((char)(startingChar + i % 26));
        }
        String largeString = sb.toString();
        AssertJUnit.assertEquals((int)stringSize, (int)largeString.length());
        byte[] buf = this.marshaller.objectToByteBuffer((Object)largeString);
        AssertJUnit.assertEquals((Object)largeString, (Object)this.marshaller.objectFromByteBuffer(buf));
    }

    public void testReplicationQueue() throws Exception {
        this.doReplicationQueueTest();
    }

    public void testReplicationQueueWithRegionBasedMarshalling() throws Exception {
        this.c.setUseRegionBasedMarshalling(true);
        this.marshaller.init();
        this.doReplicationQueueTest();
    }

    protected void doReplicationQueueTest() throws Exception {
        ArrayList<ReplicateCommand> calls = new ArrayList<ReplicateCommand>();
        Fqn f = Fqn.fromElements((Object[])new Serializable[]{"BlahBlah", Integer.valueOf(3), Boolean.valueOf(false)});
        String k = "key";
        String v = "value";
        PutKeyValueCommand cmd = new PutKeyValueCommand(null, f, (Object)k, (Object)v);
        ReplicateCommand replCmd = new ReplicateCommand((ReplicableCommand)cmd);
        calls.add(replCmd);
        cmd = new PutKeyValueCommand(null, f, (Object)k, (Object)v);
        replCmd = new ReplicateCommand((ReplicableCommand)cmd);
        calls.add(replCmd);
        ReplicateCommand replAllCmd = new ReplicateCommand(calls);
        byte[] buf = this.marshaller.objectToByteBuffer((Object)replAllCmd);
        AssertJUnit.assertEquals((Object)replAllCmd, (Object)this.marshaller.objectFromByteBuffer(buf));
    }
}

