/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class ReplicateToInactiveRegionTest {
    CacheSPI[] caches;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.caches = new CacheSPI[]{this.createCache(), this.createCache()};
        TestingUtil.blockUntilViewsReceived(this.caches, 10000L);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.destroyCache(this.caches[0]);
        this.destroyCache(this.caches[1]);
        this.caches = null;
    }

    private void destroyCache(CacheSPI c) {
        c.stop();
    }

    private CacheSPI createCache() {
        CacheSPI c = (CacheSPI)new DefaultCacheFactory().createCache(false);
        c.getConfiguration().setCacheMode("REPL_SYNC");
        c.getConfiguration().setUseRegionBasedMarshalling(true);
        c.start();
        return c;
    }

    public void testTransferToInactiveRegion() {
        Fqn f = Fqn.fromString((String)"/a/b");
        this.caches[0].put(f, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.caches[0].get(f, (Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.caches[1].get(f, (Object)"k"));
        Region region0 = this.caches[0].getRegionManager().getRegion(f, true);
        region0.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertTrue((String)"Should be active by default", (boolean)region0.isActive());
        AssertJUnit.assertTrue((boolean)this.caches[0].getRegionManager().getAllRegions(Region.Type.MARSHALLING).contains(region0));
        Region region1 = this.caches[1].getRegionManager().getRegion(f, true);
        region1.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertTrue((String)"Should be active by default", (boolean)region1.isActive());
        AssertJUnit.assertTrue((boolean)this.caches[1].getRegionManager().getAllRegions(Region.Type.MARSHALLING).contains(region1));
        region1.deactivate();
        AssertJUnit.assertFalse((String)"Should be have deactivated", (boolean)region1.isActive());
        this.caches[0].put(f, (Object)"k", (Object)"v2");
        AssertJUnit.assertEquals((Object)"v2", (Object)this.caches[0].get(f, (Object)"k"));
        AssertJUnit.assertNull((Object)this.caches[1].get(f, (Object)"k"));
    }
}

