/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.notifications.EventLog;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheListenerTest {
    protected boolean optLocking = false;
    private Cache<Object, Object> cache;
    private TransactionManager tm;
    private EventLog eventLog = new EventLog();
    private Fqn<String> fqn = Fqn.fromString((String)"/test");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        if (this.optLocking) {
            c.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        }
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache = new DefaultCacheFactory().createCache(c);
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.eventLog.events.clear();
        this.cache.addCacheListener((Object)this.eventLog);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        Transaction t = this.tm.getTransaction();
        if (t != null) {
            this.tm.rollback();
        }
        this.cache.stop();
        this.cache.destroy();
    }

    public void testCreation() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, data, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(this.fqn, (Object)"key"));
    }

    public void testOnlyModification() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value2");
        HashMap<String, String> newData = new HashMap<String, String>();
        newData.put("key", "value2");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, oldData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, newData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals((int)expected.size(), (int)this.eventLog.events.size());
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testOnlyRemoval() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(this.fqn, (Object)"key"));
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.removeNode(this.fqn);
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add(new EventImpl(true, this.cache, null, oldData, this.fqn, null, true, null, false, null, Event.Type.NODE_REMOVED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_REMOVED));
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache.getRoot().getChild(this.fqn));
    }

    public void testNonexistentRemove() throws Exception {
        this.cache.removeNode("/does/not/exist");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testRemoveData() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        this.cache.put(this.fqn, (Object)"key2", (Object)"value2");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        oldData.put("key2", "value2");
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.remove(this.fqn, (Object)"key2");
        HashMap<String, String> removedData = new HashMap<String, String>();
        removedData.put("key2", "value2");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.REMOVE_DATA, oldData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.REMOVE_DATA, removedData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testPutMap() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        oldData.put("key2", "value2");
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, oldData);
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.PUT_MAP, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.PUT_MAP, oldData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testMove() {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        Fqn newParent = Fqn.fromString((String)"/a");
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        this.cache.put(newParent, (Object)"key", (Object)"value");
        Node n1 = this.cache.getRoot().getChild(this.fqn);
        Node n2 = this.cache.getRoot().getChild(newParent);
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.move(n1.getFqn(), n2.getFqn());
        Fqn newFqn = Fqn.fromRelativeElements((Fqn)newParent, (Object[])new Object[]{this.fqn.getLastElement()});
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, newFqn, false, null, Event.Type.NODE_MOVED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, newFqn, false, null, Event.Type.NODE_MOVED));
        if (this.optLocking) {
            expected.add(new EventImpl(false, this.cache, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testTxNonexistentRemove() throws Exception {
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.removeNode("/does/not/exist");
        this.tm.commit();
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testTxCreationCommit() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, Collections.emptyMap(), this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        this.tm.commit();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(this.fqn, (Object)"key"));
    }

    public void testTxCreationRollback() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, Collections.emptyMap(), this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        this.tm.rollback();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testTxOnlyModification() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.put(this.fqn, (Object)"key", (Object)"value2");
        HashMap<String, String> newData = new HashMap<String, String>();
        newData.put("key", "value2");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, oldData, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, newData, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        this.tm.commit();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testTxOnlyRemoval() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(this.fqn, (Object)"key"));
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.removeNode(this.fqn);
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, null, oldData, this.fqn, tx, true, null, false, null, Event.Type.NODE_REMOVED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_REMOVED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        this.tm.commit();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache.getRoot().getChild(this.fqn));
    }

    public void testTxRemoveData() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        this.cache.put(this.fqn, (Object)"key2", (Object)"value2");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        oldData.put("key2", "value2");
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.remove(this.fqn, (Object)"key2");
        HashMap<String, String> removedData = new HashMap<String, String>();
        removedData.put("key2", "value2");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.REMOVE_DATA, oldData, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.REMOVE_DATA, removedData, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        this.tm.commit();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testTxMove() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        Fqn newParent = Fqn.fromString((String)"/a");
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        this.cache.put(newParent, (Object)"key", (Object)"value");
        Node n1 = this.cache.getRoot().getChild(this.fqn);
        Node n2 = this.cache.getRoot().getChild(newParent);
        this.eventLog.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.move(n1.getFqn(), n2.getFqn());
        Fqn newFqn = Fqn.fromRelativeElements((Fqn)newParent, (Object[])new Object[]{this.fqn.getLastElement()});
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, tx, true, newFqn, false, null, Event.Type.NODE_MOVED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, tx, true, newFqn, false, null, Event.Type.NODE_MOVED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        this.tm.commit();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }
}

