/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.HashMap;
import javax.transaction.Transaction;
import org.easymock.EasyMock;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.notifications.NotifierImpl;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.CacheBlocked;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.CacheUnblocked;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.TransactionCompleted;
import org.jboss.cache.notifications.annotation.TransactionRegistered;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.BuddyGroupChangedEvent;
import org.jboss.cache.notifications.event.CacheBlockedEvent;
import org.jboss.cache.notifications.event.CacheStartedEvent;
import org.jboss.cache.notifications.event.CacheStoppedEvent;
import org.jboss.cache.notifications.event.CacheUnblockedEvent;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.NodeActivatedEvent;
import org.jboss.cache.notifications.event.NodeCreatedEvent;
import org.jboss.cache.notifications.event.NodeEvictedEvent;
import org.jboss.cache.notifications.event.NodeLoadedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeMovedEvent;
import org.jboss.cache.notifications.event.NodePassivatedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.NodeVisitedEvent;
import org.jboss.cache.notifications.event.TransactionCompletedEvent;
import org.jboss.cache.notifications.event.TransactionRegisteredEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jgroups.View;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class NotifierTest {
    private NotifierImpl notifier;
    private Cache cache;
    private InvocationContext ctx;
    private AllEventsListener allEventsListener;
    private Fqn fqn = Fqn.fromString((String)"/a/b/c");

    @BeforeMethod
    public void setUp() {
        this.cache = (Cache)EasyMock.createNiceMock(Cache.class);
        this.notifier = new NotifierImpl(this.cache);
        this.ctx = new InvocationContext();
        this.allEventsListener = new AllEventsListener();
        this.notifier.addCacheListener((Object)this.allEventsListener);
    }

    public void testNotifyNodeCreated() {
        assert (this.allEventsListener.nodeCreatedEvent == null);
        this.notifier.notifyNodeCreated(this.fqn, true, this.ctx);
        assert (this.allEventsListener.nodeCreatedEvent != null);
        assert (this.allEventsListener.nodeCreatedEvent.getType() == Event.Type.NODE_CREATED);
    }

    public void testShouldNotifyOnNodeModified() {
        assert (this.notifier.shouldNotifyOnNodeModified());
        this.notifier.destroy();
        assert (!this.notifier.shouldNotifyOnNodeModified());
    }

    public void testNotifyNodeModified() {
        assert (this.allEventsListener.nodeModifiedEvent == null);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("k", "v");
        this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.PUT_DATA, expected, this.ctx);
        assert (this.notifier.getNodeModifiedListeners().size() == 1);
        assert (this.allEventsListener.nodeModifiedEvent != null);
        assert (((Object)this.allEventsListener.nodeModifiedEvent.getData()).equals(expected));
        assert (this.allEventsListener.nodeModifiedEvent.getModificationType() == NodeModifiedEvent.ModificationType.PUT_DATA);
    }

    public void testNotifyNodeRemoved() {
        assert (this.allEventsListener.nodeRemoveEvent == null);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("k", "v");
        this.notifier.notifyNodeRemoved(this.fqn, true, data, this.ctx);
        assert (this.allEventsListener.nodeRemoveEvent != null);
        assert (((Object)this.allEventsListener.nodeRemoveEvent.getData()).equals(data));
        assert (this.allEventsListener.nodeRemoveEvent.getType() == Event.Type.NODE_REMOVED);
    }

    public void testNotifyNodeVisited() {
        assert (this.allEventsListener.nodeVisistedEvent == null);
        this.notifier.notifyNodeVisited(this.fqn, true, this.ctx);
        assert (this.allEventsListener.nodeVisistedEvent != null);
        assert (this.allEventsListener.nodeVisistedEvent.getType() == Event.Type.NODE_VISITED);
    }

    public void testNotifyNodeMoved() {
        assert (this.allEventsListener.nodeMovedEvent == null);
        Fqn second = Fqn.fromString((String)"/a/s/f");
        this.notifier.notifyNodeMoved(this.fqn, second, true, this.ctx);
        assert (this.allEventsListener.nodeMovedEvent != null);
        assert (this.allEventsListener.nodeMovedEvent.getFqn().equals((Object)this.fqn));
        assert (this.allEventsListener.nodeMovedEvent.getTargetFqn().equals((Object)second));
        assert (this.allEventsListener.nodeMovedEvent.getType() == Event.Type.NODE_MOVED);
    }

    public void testNotifyNodeEvicted() {
        assert (this.allEventsListener.nodeEvictedEvent == null);
        this.notifier.notifyNodeEvicted(this.fqn, true, this.ctx);
        assert (this.allEventsListener.nodeEvictedEvent != null);
        assert (this.allEventsListener.nodeEvictedEvent.getFqn().equals((Object)this.fqn));
        assert (this.allEventsListener.nodeEvictedEvent.getType() == Event.Type.NODE_EVICTED);
    }

    public void testNotifyNodeLoaded() {
        assert (this.allEventsListener.nodeLoadedEvent == null);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("key", "value");
        this.notifier.notifyNodeLoaded(this.fqn, true, expected, this.ctx);
        assert (this.allEventsListener.nodeLoadedEvent != null);
        assert (this.allEventsListener.nodeLoadedEvent.getFqn().equals((Object)this.fqn));
        assert (((Object)this.allEventsListener.nodeLoadedEvent.getData()).equals(expected));
        assert (this.allEventsListener.nodeLoadedEvent.getType() == Event.Type.NODE_LOADED);
    }

    public void testNotifyNodeActivated() {
        assert (this.allEventsListener.nodeActivatedEvent == null);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("key", "value");
        this.notifier.notifyNodeActivated(this.fqn, true, expected, this.ctx);
        assert (this.allEventsListener.nodeActivatedEvent != null);
        assert (this.allEventsListener.nodeActivatedEvent.getFqn().equals((Object)this.fqn));
        assert (((Object)this.allEventsListener.nodeActivatedEvent.getData()).equals(expected));
        assert (this.allEventsListener.nodeActivatedEvent.getType() == Event.Type.NODE_ACTIVATED);
    }

    public void testNotifyNodePassivated() {
        assert (this.allEventsListener.nodePassivatedEvent == null);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("key", "value");
        this.notifier.notifyNodePassivated(this.fqn, true, expected, this.ctx);
        assert (this.allEventsListener.nodePassivatedEvent != null);
        assert (this.allEventsListener.nodePassivatedEvent.getFqn().equals((Object)this.fqn));
        assert (((Object)this.allEventsListener.nodePassivatedEvent.getData()).equals(expected));
        assert (this.allEventsListener.nodePassivatedEvent.getType() == Event.Type.NODE_PASSIVATED);
    }

    public void testNotifyCacheStarted() {
        assert (this.allEventsListener.cacheStartedEvent == null);
        this.notifier.notifyCacheStarted();
        assert (this.allEventsListener.cacheStartedEvent != null);
        assert (this.allEventsListener.cacheStartedEvent.getType() == Event.Type.CACHE_STARTED);
    }

    public void testNotifyCacheStopped() {
        assert (this.allEventsListener.cacheStoppedEvent == null);
        this.notifier.notifyCacheStopped();
        assert (this.allEventsListener.cacheStoppedEvent != null);
        assert (this.allEventsListener.cacheStoppedEvent.getType() == Event.Type.CACHE_STOPPED);
    }

    public void testNotifyViewChange() {
        assert (this.allEventsListener.viewChanged == null);
        View view = new View();
        this.notifier.notifyViewChange(view, this.ctx);
        assert (this.allEventsListener.viewChanged != null);
        assert (this.allEventsListener.viewChanged.getNewView().equals((Object)view));
        assert (this.allEventsListener.viewChanged.getType() == Event.Type.VIEW_CHANGED);
    }

    public void testNotifyBuddyGroupChange() {
        assert (this.allEventsListener.buddyGroupChangedEvent == null);
        BuddyGroup buddyGroup = new BuddyGroup();
        this.notifier.notifyBuddyGroupChange(buddyGroup, true);
        assert (this.allEventsListener.buddyGroupChangedEvent != null);
        assert (this.allEventsListener.buddyGroupChangedEvent.getBuddyGroup().equals(buddyGroup));
        assert (this.allEventsListener.buddyGroupChangedEvent.getType() == Event.Type.BUDDY_GROUP_CHANGED);
    }

    public void testNotifyTransactionCompleted() {
        assert (this.allEventsListener.transactionCompleted == null);
        Transaction tx = (Transaction)EasyMock.createNiceMock(Transaction.class);
        this.notifier.notifyTransactionCompleted(tx, false, this.ctx);
        assert (this.allEventsListener.transactionCompleted != null);
        assert (this.allEventsListener.transactionCompleted.getTransaction() == tx);
        assert (!this.allEventsListener.transactionCompleted.isSuccessful());
        assert (this.allEventsListener.transactionCompleted.getType() == Event.Type.TRANSACTION_COMPLETED);
    }

    public void testNotifyTransactionRegistered() {
        assert (this.allEventsListener.transactionRegistered == null);
        Transaction tx = (Transaction)EasyMock.createNiceMock(Transaction.class);
        this.notifier.notifyTransactionRegistered(tx, this.ctx);
        assert (this.allEventsListener.transactionRegistered != null);
        assert (this.allEventsListener.transactionRegistered.getTransaction() == tx);
        assert (this.allEventsListener.transactionRegistered.getType() == Event.Type.TRANSACTION_REGISTERED);
    }

    public void testNotifyCacheBlocked() {
        assert (this.allEventsListener.cacheBlockedEvent == null);
        this.notifier.notifyCacheBlocked(false);
        assert (this.allEventsListener.cacheBlockedEvent != null);
        assert (!this.allEventsListener.cacheBlockedEvent.isPre());
        assert (this.allEventsListener.cacheBlockedEvent.getType() == Event.Type.CACHE_BLOCKED);
    }

    public void testNotifyCacheUnblocked() {
        assert (this.allEventsListener.cacheUnblockedEvent == null);
        this.notifier.notifyCacheUnblocked(false);
        assert (this.allEventsListener.cacheUnblockedEvent != null);
        assert (!this.allEventsListener.cacheUnblockedEvent.isPre());
        assert (this.allEventsListener.cacheUnblockedEvent.getType() == Event.Type.CACHE_UNBLOCKED);
    }

    @CacheListener
    public static class AllEventsListener {
        CacheStartedEvent cacheStartedEvent;
        CacheStoppedEvent cacheStoppedEvent;
        CacheBlockedEvent cacheBlockedEvent;
        CacheUnblockedEvent cacheUnblockedEvent;
        NodeCreatedEvent nodeCreatedEvent;
        NodeRemovedEvent nodeRemoveEvent;
        NodeVisitedEvent nodeVisistedEvent;
        NodeModifiedEvent nodeModifiedEvent;
        NodeMovedEvent nodeMovedEvent;
        NodeActivatedEvent nodeActivatedEvent;
        NodePassivatedEvent nodePassivatedEvent;
        NodeLoadedEvent nodeLoadedEvent;
        NodeEvictedEvent nodeEvictedEvent;
        TransactionRegisteredEvent transactionRegistered;
        TransactionCompletedEvent transactionCompleted;
        ViewChangedEvent viewChanged;
        BuddyGroupChangedEvent buddyGroupChangedEvent;

        @CacheStarted
        public void onCacheStarted(CacheStartedEvent event) {
            this.cacheStartedEvent = event;
        }

        @CacheStopped
        public void onCacheStopped(CacheStoppedEvent event) {
            this.cacheStoppedEvent = event;
        }

        @CacheBlocked
        public void onCacheBlocked(CacheBlockedEvent event) {
            this.cacheBlockedEvent = event;
        }

        @CacheUnblocked
        public void onCacheUnblocked(CacheUnblockedEvent event) {
            this.cacheUnblockedEvent = event;
        }

        @NodeCreated
        public void onNodeCreated(NodeCreatedEvent event) {
            this.nodeCreatedEvent = event;
        }

        @NodeRemoved
        public void onNodeRemoved(NodeRemovedEvent event) {
            this.nodeRemoveEvent = event;
        }

        @NodeVisited
        public void onNodeVisited(NodeVisitedEvent event) {
            this.nodeVisistedEvent = event;
        }

        @NodeModified
        public void onNodeModified(NodeModifiedEvent event) {
            this.nodeModifiedEvent = event;
        }

        @NodeMoved
        public void onNodeMoved(NodeMovedEvent event) {
            this.nodeMovedEvent = event;
        }

        @NodeActivated
        public void onNodeActivated(NodeActivatedEvent event) {
            this.nodeActivatedEvent = event;
        }

        @NodePassivated
        public void onNodePassivated(NodePassivatedEvent event) {
            this.nodePassivatedEvent = event;
        }

        @NodeLoaded
        public void onNodeLoaded(NodeLoadedEvent event) {
            this.nodeLoadedEvent = event;
        }

        @NodeEvicted
        public void onNodeEvicted(NodeEvictedEvent event) {
            this.nodeEvictedEvent = event;
        }

        @TransactionRegistered
        public void onTransactionRegistered(TransactionRegisteredEvent event) {
            this.transactionRegistered = event;
        }

        @TransactionCompleted
        public void onTransactionCompleted(TransactionCompletedEvent event) {
            this.transactionCompleted = event;
        }

        @ViewChanged
        public void onViewChanged(ViewChangedEvent event) {
            this.viewChanged = event;
        }

        @BuddyGroupChanged
        public void onBuddyGroupChanged(BuddyGroupChangedEvent event) {
            this.buddyGroupChangedEvent = event;
        }
    }
}

