/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.util.ArrayList;
import java.util.HashMap;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public class MessageHelper {
    public static final char DELIMITER = '\u0001';
    public static final int GENERIC_SUITE_COUNT = 1;
    public static final int SUITE = 10;
    public static final int SUITE_START = 11;
    public static final int SUITE_FINISH = 12;
    public static final int TEST = 100;
    public static final int TEST_START = 101;
    public static final int TEST_FINISH = 102;
    public static final int TEST_RESULT = 1000;
    public static final int PASSED_TEST = 1001;
    public static final int FAILED_TEST = 1002;
    public static final int SKIPPED_TEST = 1003;
    public static final int FAILED_ON_PERCENTAGE_TEST = 1004;
    public static final int TEST_STARTED = 1016;
    public static final String STOP_MSG = ">STOP";
    public static final String ACK_MSG = ">ACK";

    public static int getMessageType(String message) {
        int idx = message.indexOf(1);
        return idx == -1 ? Integer.parseInt(message) : Integer.parseInt(message.substring(0, idx));
    }

    public static GenericMessage unmarshallGenericMessage(String message) {
        String[] messageParts = MessageHelper.parseMessage(message);
        if (messageParts.length == 1) {
            return new GenericMessage(Integer.parseInt(messageParts[0]));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 1; i < messageParts.length; i += 2) {
            props.put(messageParts[i], messageParts[i + 1]);
        }
        return new GenericMessage(Integer.parseInt(messageParts[0]), props);
    }

    public static SuiteMessage createSuiteMessage(String message) {
        int type = MessageHelper.getMessageType(message);
        String[] messageParts = MessageHelper.parseMessage(message);
        return new SuiteMessage(messageParts[1], 11 == type, Integer.parseInt(messageParts[2]));
    }

    public static TestMessage createTestMessage(String message) {
        int type = MessageHelper.getMessageType(message);
        String[] messageParts = MessageHelper.parseMessage(message);
        return new TestMessage(101 == type, messageParts[1], messageParts[2], Integer.parseInt(messageParts[3]), Integer.parseInt(messageParts[4]), Integer.parseInt(messageParts[5]), Integer.parseInt(messageParts[6]), Integer.parseInt(messageParts[7]));
    }

    public static TestResultMessage unmarshallTestResultMessage(String message) {
        String[] messageParts = MessageHelper.parseMessage(message);
        return new TestResultMessage(Integer.parseInt(messageParts[0]), messageParts[1], messageParts[2], messageParts[3], messageParts[4], Long.parseLong(messageParts[5]), Long.parseLong(messageParts[6]), MessageHelper.replaceNewLineReplacer(messageParts[7]));
    }

    public static String replaceNewLine(String message) {
        if (null == message) {
            return message;
        }
        return message.replace('\n', '\u0002').replace('\r', '\u0003');
    }

    public static String replaceNewLineReplacer(String message) {
        if (null == message) {
            return message;
        }
        return message.replace('\u0002', '\n').replace('\u0003', '\r');
    }

    private static String[] parseMessage(String message) {
        if (null == message) {
            return new String[0];
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < message.length(); ++i) {
            if ('\u0001' != message.charAt(i)) continue;
            tokens.add(message.substring(start, i));
            start = i + 1;
        }
        if (start < message.length()) {
            tokens.add(message.substring(start, message.length()));
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

