/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.testng.reporters.XMLStringBuffer;

public abstract class LaunchSuite {
    protected boolean m_temporary;

    protected LaunchSuite(boolean isTemp) {
        this.m_temporary = isTemp;
    }

    public boolean isTemporary() {
        return this.m_temporary;
    }

    public abstract File save(File var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassListSuite
    extends CustomizedSuite {
        protected Collection<String> m_packageNames;
        protected Collection<String> m_classNames;
        protected Collection<String> m_groupNames;
        protected int m_logLevel;

        ClassListSuite(String projectName, Collection<String> packageNames, Collection<String> classNames, Collection<String> groupNames, Map<String, String> parameters, String annotationType, int logLevel) {
            super(projectName, "Custom suite", parameters, annotationType);
            this.m_packageNames = packageNames;
            this.m_classNames = classNames;
            this.m_groupNames = groupNames;
            this.m_logLevel = logLevel;
        }

        @Override
        protected void initContentBuffer(XMLStringBuffer suiteBuffer) {
            Properties testAttrs = new Properties();
            testAttrs.setProperty("name", this.m_projectName);
            if (this.m_annotationType != null) {
                testAttrs.setProperty("annotations", this.m_annotationType);
            }
            testAttrs.setProperty("verbose", String.valueOf(this.m_logLevel));
            suiteBuffer.push("test", testAttrs);
            if (null != this.m_groupNames) {
                suiteBuffer.push("groups");
                suiteBuffer.push("run");
                for (String m_groupName : this.m_groupNames) {
                    Properties includeAttrs = new Properties();
                    includeAttrs.setProperty("name", m_groupName);
                    suiteBuffer.addEmptyElement("include", includeAttrs);
                }
                suiteBuffer.pop("run");
                suiteBuffer.pop("groups");
            }
            if (this.m_packageNames != null && this.m_packageNames.size() > 0) {
                suiteBuffer.push("packages");
                for (String m_packageName : this.m_packageNames) {
                    Properties packageAttrs = new Properties();
                    packageAttrs.setProperty("name", m_packageName);
                    suiteBuffer.addEmptyElement("package", packageAttrs);
                }
                suiteBuffer.pop("packages");
            }
            if (this.m_classNames != null && this.m_classNames.size() > 0) {
                suiteBuffer.push("classes");
                for (String m_className : this.m_classNames) {
                    Properties classAttrs = new Properties();
                    classAttrs.setProperty("name", m_className);
                    suiteBuffer.addEmptyElement("class", classAttrs);
                }
                suiteBuffer.pop("classes");
            }
            suiteBuffer.pop("test");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodsSuite
    extends CustomizedSuite {
        protected Collection<String> m_methodNames;
        protected String m_className;
        protected int m_logLevel;

        MethodsSuite(String projectName, String className, Collection<String> methodNames, Map<String, String> parameters, String annotationType, int logLevel) {
            super(projectName, className, parameters, annotationType);
            this.m_className = className;
            this.m_methodNames = methodNames;
            this.m_logLevel = logLevel;
        }

        @Override
        protected void initContentBuffer(XMLStringBuffer suiteBuffer) {
            Properties testAttrs = new Properties();
            testAttrs.setProperty("name", this.m_className);
            if (this.m_annotationType != null) {
                testAttrs.setProperty("annotations", this.m_annotationType);
            }
            testAttrs.setProperty("verbose", String.valueOf(this.m_logLevel));
            suiteBuffer.push("test", testAttrs);
            suiteBuffer.push("classes");
            Properties classAttrs = new Properties();
            classAttrs.setProperty("name", this.m_className);
            if (null != this.m_methodNames && this.m_methodNames.size() > 0) {
                suiteBuffer.push("class", classAttrs);
                suiteBuffer.push("methods");
                for (String m_methodName : this.m_methodNames) {
                    Properties methodAttrs = new Properties();
                    methodAttrs.setProperty("name", m_methodName);
                    suiteBuffer.addEmptyElement("include", methodAttrs);
                }
                suiteBuffer.pop("methods");
                suiteBuffer.pop("class");
            } else {
                suiteBuffer.addEmptyElement("class", classAttrs);
            }
            suiteBuffer.pop("classes");
            suiteBuffer.pop("test");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CustomizedSuite
    extends LaunchSuite {
        protected String m_projectName;
        protected String m_suiteName;
        protected String m_annotationType;
        protected Map<String, String> m_parameters;
        private XMLStringBuffer m_suiteBuffer;

        private CustomizedSuite(String projectName, String className, Map<String, String> parameters, String annotationType) {
            super(true);
            this.m_projectName = projectName;
            this.m_suiteName = className;
            this.m_parameters = parameters;
            this.m_annotationType = "1.4".equals(annotationType) || "javadoc".equals(annotationType) ? "javadoc" : "JDK5";
        }

        protected XMLStringBuffer createContentBuffer() {
            XMLStringBuffer suiteBuffer = new XMLStringBuffer("");
            suiteBuffer.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
            Properties attrs = new Properties();
            attrs.setProperty("name", this.m_suiteName);
            suiteBuffer.push("suite", attrs);
            if (this.m_parameters != null) {
                for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
                    Properties paramAttrs = new Properties();
                    paramAttrs.setProperty("name", entry.getKey());
                    paramAttrs.setProperty("value", entry.getValue());
                    suiteBuffer.push("parameter", paramAttrs);
                    suiteBuffer.pop("parameter");
                }
            }
            this.initContentBuffer(suiteBuffer);
            suiteBuffer.pop("suite");
            return suiteBuffer;
        }

        private XMLStringBuffer getSuiteBuffer() {
            if (null == this.m_suiteBuffer) {
                this.m_suiteBuffer = this.createContentBuffer();
            }
            return this.m_suiteBuffer;
        }

        protected abstract void initContentBuffer(XMLStringBuffer var1);

        @Override
        public File save(File directory) {
            File suiteFile = new File(directory, "temp-testng-customsuite.xml");
            this.saveSuiteContent(suiteFile, this.getSuiteBuffer());
            return suiteFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveSuiteContent(File file, XMLStringBuffer content) {
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                fw = new FileWriter(file);
                bw = new BufferedWriter(fw);
                bw.write(content.getStringBuffer().toString());
                bw.flush();
            }
            catch (IOException ioe) {
            }
            finally {
                if (null != bw) {
                    try {
                        bw.close();
                    }
                    catch (IOException ioe) {}
                }
                if (null != fw) {
                    try {
                        fw.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    public static class ExistingSuite
    extends LaunchSuite {
        private File m_suitePath;

        public ExistingSuite(File path) {
            super(false);
            this.m_suitePath = path;
        }

        public File save(File directory) {
            return this.m_suitePath;
        }
    }
}

