/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.ExponentialInterval;
import org.jgroups.stack.Interval;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Buffer;
import org.jgroups.util.Digest;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NAKACK
extends Protocol
implements Retransmitter.RetransmitCommand,
NakReceiverWindow.Listener {
    private long[] retransmit_timeouts = new long[]{600L, 1200L, 2400L, 4800L};
    private boolean is_server = false;
    private Address local_addr = null;
    private final List<Address> members = new CopyOnWriteArrayList<Address>();
    private View view;
    private long seqno = 0L;
    private final Lock seqno_lock = new ReentrantLock();
    private int gc_lag = 20;
    private Map<Thread, ReentrantLock> locks;
    private static final long INITIAL_SEQNO = 0L;
    private boolean use_mcast_xmit = true;
    private boolean use_mcast_xmit_req = false;
    private boolean xmit_from_random_member = false;
    private long exponential_backoff = 0L;
    private boolean use_stats_for_retransmission = false;
    private boolean discard_delivered_msgs = false;
    private boolean eager_lock_release = true;
    private int max_xmit_buf_size = 0;
    private final ConcurrentMap<Address, NakReceiverWindow> xmit_table = new ConcurrentHashMap<Address, NakReceiverWindow>(11);
    private boolean leaving = false;
    private boolean started = false;
    private TimeScheduler timer = null;
    private static final String name = "NAKACK";
    private long xmit_reqs_received;
    private long xmit_reqs_sent;
    private long xmit_rsps_received;
    private long xmit_rsps_sent;
    private long missing_msgs_received;
    private HashMap<Address, StatsEntry> sent = new HashMap();
    private HashMap<Address, StatsEntry> received = new HashMap();
    private int stats_list_size = 20;
    private BoundedList<MissingMessage> receive_history;
    private BoundedList<XmitRequest> send_history;
    private final ConcurrentMap<Address, ConcurrentMap<Long, Long>> xmit_stats = new ConcurrentHashMap<Address, ConcurrentMap<Long, Long>>();
    private int xmit_history_max_size = 50;
    private final ConcurrentMap<Address, BoundedList<Long>> xmit_times_history = new ConcurrentHashMap<Address, BoundedList<Long>>();
    private final Map<Address, Double> smoothed_avg_xmit_times = new HashMap<Address, Double>();
    private static final double WEIGHT = 0.9;
    private static final double INITIAL_SMOOTHED_AVG = 30.0;
    private ConcurrentMap<Long, XmitTimeStat> xmit_time_stats = null;
    private long xmit_time_stats_start;
    private final Set<Long> oob_loopback_msgs = Collections.synchronizedSet(new HashSet());
    private final Lock rebroadcast_lock = new ReentrantLock();
    private final Condition rebroadcast_done = this.rebroadcast_lock.newCondition();
    private volatile boolean rebroadcasting = false;
    private final Lock rebroadcast_digest_lock = new ReentrantLock();
    private Digest rebroadcast_digest = null;
    private long max_rebroadcast_timeout = 2000L;
    private static final int NUM_REBROADCAST_MSGS = 3;
    private final BoundedList<Digest> stability_msgs = new BoundedList(10);
    protected boolean print_stability_history_on_failed_xmit = false;

    @Override
    public String getName() {
        return name;
    }

    public long getXmitRequestsReceived() {
        return this.xmit_reqs_received;
    }

    public long getXmitRequestsSent() {
        return this.xmit_reqs_sent;
    }

    public long getXmitResponsesReceived() {
        return this.xmit_rsps_received;
    }

    public long getXmitResponsesSent() {
        return this.xmit_rsps_sent;
    }

    public long getMissingMessagesReceived() {
        return this.missing_msgs_received;
    }

    public int getPendingRetransmissionRequests() {
        int num = 0;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            num += win.getPendingXmits();
        }
        return num;
    }

    public int getXmitTableSize() {
        int num = 0;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            num += win.size();
        }
        return num;
    }

    public int getReceivedTableSize() {
        return this.getPendingRetransmissionRequests();
    }

    @Override
    public void resetStats() {
        this.missing_msgs_received = 0L;
        this.xmit_rsps_sent = 0L;
        this.xmit_rsps_received = 0L;
        this.xmit_reqs_sent = 0L;
        this.xmit_reqs_received = 0L;
        this.sent.clear();
        this.received.clear();
        if (this.receive_history != null) {
            this.receive_history.clear();
        }
        if (this.send_history != null) {
            this.send_history.clear();
        }
    }

    @Override
    public void init() throws Exception {
        if (this.stats) {
            this.send_history = new BoundedList(this.stats_list_size);
            this.receive_history = new BoundedList(this.stats_list_size);
        }
    }

    public int getGcLag() {
        return this.gc_lag;
    }

    public void setGcLag(int gc_lag) {
        this.gc_lag = gc_lag;
    }

    public boolean isUseMcastXmit() {
        return this.use_mcast_xmit;
    }

    public void setUseMcastXmit(boolean use_mcast_xmit) {
        this.use_mcast_xmit = use_mcast_xmit;
    }

    public boolean isXmitFromRandomMember() {
        return this.xmit_from_random_member;
    }

    public void setXmitFromRandomMember(boolean xmit_from_random_member) {
        this.xmit_from_random_member = xmit_from_random_member;
    }

    public boolean isDiscardDeliveredMsgs() {
        return this.discard_delivered_msgs;
    }

    public void setDiscardDeliveredMsgs(boolean discard_delivered_msgs) {
        boolean old = this.discard_delivered_msgs;
        this.discard_delivered_msgs = discard_delivered_msgs;
        if (old != this.discard_delivered_msgs) {
            for (NakReceiverWindow win : this.xmit_table.values()) {
                win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
            }
        }
    }

    public int getMaxXmitBufSize() {
        return this.max_xmit_buf_size;
    }

    public void setMaxXmitBufSize(int max_xmit_buf_size) {
        this.max_xmit_buf_size = max_xmit_buf_size;
    }

    public long getMaxXmitSize() {
        return -1L;
    }

    public void setMaxXmitSize(long max_xmit_size) {
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeouts = tmp;
            }
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = Integer.parseInt(str);
            if (this.gc_lag < 0) {
                this.log.error((Object)"gc_lag cannot be negative, setting it to 0");
            }
            props.remove("gc_lag");
        }
        if ((str = props.getProperty("max_xmit_size")) != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"max_xmit_size was deprecated in 2.6 and will be ignored");
            }
            props.remove("max_xmit_size");
        }
        if ((str = props.getProperty("use_mcast_xmit")) != null) {
            this.use_mcast_xmit = Boolean.valueOf(str);
            props.remove("use_mcast_xmit");
        }
        if ((str = props.getProperty("use_mcast_xmit_req")) != null) {
            this.use_mcast_xmit_req = Boolean.valueOf(str);
            props.remove("use_mcast_xmit_req");
        }
        if ((str = props.getProperty("exponential_backoff")) != null) {
            this.exponential_backoff = Long.parseLong(str);
            props.remove("exponential_backoff");
        }
        if ((str = props.getProperty("use_stats_for_retransmission")) != null) {
            this.use_stats_for_retransmission = Boolean.valueOf(str);
            props.remove("use_stats_for_retransmission");
        }
        if ((str = props.getProperty("discard_delivered_msgs")) != null) {
            this.discard_delivered_msgs = Boolean.valueOf(str);
            props.remove("discard_delivered_msgs");
        }
        if ((str = props.getProperty("xmit_from_random_member")) != null) {
            this.xmit_from_random_member = Boolean.valueOf(str);
            props.remove("xmit_from_random_member");
        }
        if ((str = props.getProperty("max_xmit_buf_size")) != null) {
            this.max_xmit_buf_size = Integer.parseInt(str);
            props.remove("max_xmit_buf_size");
        }
        if ((str = props.getProperty("stats_list_size")) != null) {
            this.stats_list_size = Integer.parseInt(str);
            props.remove("stats_list_size");
        }
        if ((str = props.getProperty("xmit_history_max_size")) != null) {
            this.xmit_history_max_size = Integer.parseInt(str);
            props.remove("xmit_history_max_size");
        }
        if ((str = props.getProperty("enable_xmit_time_stats")) != null) {
            boolean enable_xmit_time_stats = Boolean.valueOf(str);
            props.remove("enable_xmit_time_stats");
            if (enable_xmit_time_stats) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"enable_xmit_time_stats is experimental, and may be removed in any release");
                }
                this.xmit_time_stats = new ConcurrentHashMap<Long, XmitTimeStat>();
                this.xmit_time_stats_start = System.currentTimeMillis();
            }
        }
        if ((str = props.getProperty("max_rebroadcast_timeout")) != null) {
            this.max_rebroadcast_timeout = Long.parseLong(str);
            props.remove("max_rebroadcast_timeout");
        }
        if ((str = props.getProperty("eager_lock_release")) != null) {
            this.eager_lock_release = Boolean.valueOf(str);
            props.remove("eager_lock_release");
        }
        if (this.xmit_from_random_member && this.discard_delivered_msgs) {
            this.discard_delivered_msgs = false;
            this.log.warn((Object)"xmit_from_random_member set to true: changed discard_delivered_msgs to false");
        }
        if ((str = props.getProperty("print_stability_history_on_failed_xmit")) != null) {
            this.print_stability_history_on_failed_xmit = Boolean.valueOf(str);
            props.remove("print_stability_history_on_failed_xmit");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, Object>();
        }
        retval.put("xmit_reqs_received", new Long(this.xmit_reqs_received));
        retval.put("xmit_reqs_sent", new Long(this.xmit_reqs_sent));
        retval.put("xmit_rsps_received", new Long(this.xmit_rsps_received));
        retval.put("xmit_rsps_sent", new Long(this.xmit_rsps_sent));
        retval.put("missing_msgs_received", new Long(this.missing_msgs_received));
        retval.put("msgs", this.printMessages());
        return retval;
    }

    @Override
    public String printStats() {
        StatsEntry val;
        Object key;
        StringBuilder sb = new StringBuilder();
        sb.append("sent:\n");
        for (Map.Entry<Address, StatsEntry> entry : this.sent.entrySet()) {
            key = entry.getKey();
            if (key == null) {
                key = "<mcast dest>";
            }
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        for (Map.Entry<Address, StatsEntry> entry : this.received.entrySet()) {
            key = entry.getKey();
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nXMIT_REQS sent:\n");
        for (XmitRequest tmp : this.send_history) {
            sb.append(tmp).append("\n");
        }
        sb.append("\nMissing messages received\n");
        for (MissingMessage missing : this.receive_history) {
            sb.append(missing).append("\n");
        }
        sb.append("\nStability messages received\n");
        sb.append(this.printStabilityMessages()).append("\n");
        return sb.toString();
    }

    public String printStabilityMessages() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.printListWithDelimiter(this.stability_msgs, "\n"));
        return sb.toString();
    }

    public String printStabilityHistory() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Digest digest : this.stability_msgs) {
            sb.append(i++).append(": ").append(digest).append("\n");
        }
        return sb.toString();
    }

    public String printLossRates() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            sb.append(entry.getKey()).append(": ").append(win.printLossRate()).append("\n");
        }
        return sb.toString();
    }

    public double getAverageLossRate() {
        double retval = 0.0;
        int count = 0;
        if (this.xmit_table.isEmpty()) {
            return 0.0;
        }
        for (NakReceiverWindow win : this.xmit_table.values()) {
            retval += win.getLossRate();
            ++count;
        }
        return retval / (double)count;
    }

    public double getAverageSmoothedLossRate() {
        double retval = 0.0;
        int count = 0;
        if (this.xmit_table.isEmpty()) {
            return 0.0;
        }
        for (NakReceiverWindow win : this.xmit_table.values()) {
            retval += win.getSmoothedLossRate();
            ++count;
        }
        return retval / (double)count;
    }

    @Override
    public Vector<Integer> providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>(5);
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(53));
        return retval;
    }

    @Override
    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        this.locks = this.stack.getLocks();
        this.started = true;
        if (this.xmit_time_stats != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    String filename = "xmit-stats-" + NAKACK.this.local_addr + ".log";
                    System.out.println("-- dumping runtime xmit stats to " + filename);
                    try {
                        NAKACK.this.dumpXmitStats(filename);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public void stop() {
        this.started = false;
        this.reset();
        this.oob_loopback_msgs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null && !dest.isMulticastAddress()) break;
                this.send(evt, msg);
                return null;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return null;
            }
            case 39: {
                return this.getDigest();
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return null;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return null;
            }
            case 15: {
                View tmp_view = (View)evt.getArg();
                Vector<Address> mbrs = tmp_view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                break;
            }
            case 6: {
                View tmp_view = (View)evt.getArg();
                Vector<Address> mbrs = tmp_view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                this.adjustReceivers(this.members);
                this.is_server = true;
                LinkedHashSet<Address> tmp = new LinkedHashSet<Address>(this.members);
                tmp.add(null);
                this.sent.keySet().retainAll(tmp);
                this.received.keySet().retainAll(tmp);
                this.view = tmp_view;
                this.xmit_stats.keySet().retainAll(tmp);
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 4: {
                this.leaving = true;
                this.reset();
                break;
            }
            case 78: {
                this.rebroadcasting = true;
                this.rebroadcast_digest = (Digest)evt.getArg();
                try {
                    this.rebroadcastMessages();
                }
                finally {
                    this.rebroadcasting = false;
                    this.rebroadcast_digest_lock.lock();
                    try {
                        this.rebroadcast_digest = null;
                    }
                    finally {
                        this.rebroadcast_digest_lock.unlock();
                    }
                }
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                NakAckHeader hdr = (NakAckHeader)msg.getHeader(name);
                if (hdr == null) break;
                if (!this.is_server) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"message was discarded (not yet server)");
                    }
                    return null;
                }
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return null;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)("XMIT_REQ: range of xmit msg is null; discarding request from " + msg.getSrc()));
                            }
                            return null;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high, hdr.sender);
                        return null;
                    }
                    case 3: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("received missing message " + msg.getSrc() + ":" + hdr.seqno));
                        }
                        this.handleXmitRsp(msg);
                        return null;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("NakAck header type " + hdr.type + " not known !"));
                }
                return null;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 9: {
                if (!this.rebroadcasting) break;
                this.cancelRebroadcasting();
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Event evt, Message msg) {
        block13: {
            long msg_id;
            if (msg == null) {
                throw new NullPointerException("msg is null; event is " + evt);
            }
            if (!this.started) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("[" + this.local_addr + "] discarded message as start() has not been called, message: " + msg));
                }
                return;
            }
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(this.local_addr);
            msg.setSrc(this.local_addr);
            this.seqno_lock.lock();
            try {
                try {
                    msg_id = this.seqno + 1L;
                    msg.putHeader(name, new NakAckHeader(1, msg_id));
                    win.add(msg_id, msg);
                    this.seqno = msg_id;
                }
                catch (Throwable t) {
                    throw new RuntimeException("failure adding msg " + msg + " to the retransmit table for " + this.local_addr, t);
                }
            }
            finally {
                this.seqno_lock.unlock();
            }
            try {
                if (msg.isFlagSet((byte)1)) {
                    this.oob_loopback_msgs.add(msg_id);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("sending " + this.local_addr + "#" + msg_id));
                }
                this.down_prot.down(evt);
            }
            catch (Throwable t) {
                if (!this.log.isWarnEnabled()) break block13;
                this.log.warn((Object)"failure passing message down", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Message msg, NakAckHeader hdr) {
        boolean added;
        NakReceiverWindow win;
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender of message is null");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuilder().append('[').append(this.local_addr).append(": received ").append(sender).append('#').append(hdr.seqno));
        }
        if ((win = (NakReceiverWindow)this.xmit_table.get(sender)) == null) {
            if (this.leaving) {
                return;
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)(this.local_addr + "] discarded message from non-member " + sender + ", my view is " + this.view));
            }
            return;
        }
        boolean loopback = this.local_addr.equals(sender);
        boolean bl = added = loopback || win.add(hdr.seqno, msg);
        if (msg.isFlagSet((byte)1) && added && (!loopback || this.oob_loopback_msgs.remove(hdr.seqno))) {
            this.up_prot.up(new Event(1, msg));
        }
        ReentrantLock lock = win.getLock();
        lock.lock();
        try {
            Message msg_to_deliver;
            if (this.eager_lock_release) {
                this.locks.put(Thread.currentThread(), lock);
            }
            while ((msg_to_deliver = win.remove()) != null) {
                if (msg_to_deliver.isFlagSet((byte)1)) continue;
                this.up_prot.up(new Event(1, msg_to_deliver));
            }
        }
        finally {
            if (this.eager_lock_release) {
                this.locks.remove(Thread.currentThread());
            }
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    private void handleXmitReq(Address xmit_requester, long first_seqno, long last_seqno, Address original_sender) {
        NakReceiverWindow win;
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(": received xmit request from ").append(xmit_requester).append(" for ");
            sb.append(original_sender).append(" [").append(first_seqno).append(" - ").append(last_seqno).append("]");
            this.log.trace((Object)sb.toString());
        }
        if (first_seqno > last_seqno) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("first_seqno (" + first_seqno + ") > last_seqno (" + last_seqno + "): not able to retransmit"));
            }
            return;
        }
        if (this.stats) {
            this.xmit_reqs_received += last_seqno - first_seqno + 1L;
            NAKACK.updateStats(this.received, xmit_requester, 1, 0, 0);
        }
        if (this.xmit_time_stats != null) {
            long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
            XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
            if (stat == null) {
                stat = new XmitTimeStat();
                this.xmit_time_stats.putIfAbsent(key, stat);
            }
            stat.xmit_reqs_received.addAndGet((int)(last_seqno - first_seqno + 1L));
            stat.xmit_rsps_sent.addAndGet((int)(last_seqno - first_seqno + 1L));
        }
        if ((win = (NakReceiverWindow)this.xmit_table.get(original_sender)) == null) {
            if (this.log.isErrorEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                sb.append(") ").append(original_sender).append(" not found in retransmission table: ").append(this.printMessages());
                if (this.print_stability_history_on_failed_xmit) {
                    sb.append(" (stability history:\n").append(this.printStabilityHistory());
                }
                this.log.error((Object)sb);
            }
            return;
        }
        for (long i = first_seqno; i <= last_seqno; ++i) {
            Message msg = win.get(i);
            if (msg == null || msg == NakReceiverWindow.NULL_MSG) {
                if (!this.log.isWarnEnabled() || this.local_addr.equals(xmit_requester)) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                sb.append(") message ").append(original_sender).append("::").append(i);
                sb.append(" not found in retransmission table of ").append(this.printMessages());
                if (this.print_stability_history_on_failed_xmit) {
                    sb.append(" (stability history:\n").append(this.printStabilityHistory());
                }
                this.log.warn((Object)sb);
                continue;
            }
            this.sendXmitRsp(xmit_requester, msg, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRebroadcasting() {
        this.rebroadcast_lock.lock();
        try {
            this.rebroadcasting = false;
            this.rebroadcast_done.signalAll();
        }
        finally {
            this.rebroadcast_lock.unlock();
        }
    }

    private static void updateStats(HashMap<Address, StatsEntry> map, Address key, int req, int rsp, int missing) {
        StatsEntry entry = map.get(key);
        if (entry == null) {
            entry = new StatsEntry();
            map.put(key, entry);
        }
        entry.xmit_reqs += (long)req;
        entry.xmit_rsps += (long)rsp;
        entry.missing_msgs_rcvd += (long)missing;
    }

    private void sendXmitRsp(Address dest, Message msg, long seqno) {
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message is null, cannot send retransmission");
            }
            return;
        }
        if (this.use_mcast_xmit) {
            dest = null;
        }
        if (this.stats) {
            ++this.xmit_rsps_sent;
            NAKACK.updateStats(this.sent, dest, 0, 1, 0);
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        try {
            Buffer buf = Util.messageToByteBuffer(msg);
            Message xmit_msg = new Message(dest, null, buf.getBuf(), buf.getOffset(), buf.getLength());
            xmit_msg.putHeader(name, new NakAckHeader(3, seqno));
            this.down_prot.down(new Event(1, xmit_msg));
        }
        catch (IOException ex) {
            this.log.error((Object)"failed marshalling xmit list", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleXmitRsp(Message msg) {
        block11: {
            if (msg == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"message is null");
                }
                return;
            }
            try {
                boolean cancel_rebroadcasting;
                Message wrapped_msg = Util.byteBufferToMessage(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                if (this.xmit_time_stats != null) {
                    long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
                    XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
                    if (stat == null) {
                        stat = new XmitTimeStat();
                        this.xmit_time_stats.putIfAbsent(key, stat);
                    }
                    stat.xmit_rsps_received.incrementAndGet();
                }
                if (this.stats) {
                    ++this.xmit_rsps_received;
                    NAKACK.updateStats(this.received, msg.getSrc(), 0, 1, 0);
                }
                this.up(new Event(1, wrapped_msg));
                if (!this.rebroadcasting) break block11;
                Digest tmp = this.getDigest();
                this.rebroadcast_digest_lock.lock();
                try {
                    cancel_rebroadcasting = tmp.isGreaterThanOrEqual(this.rebroadcast_digest);
                }
                finally {
                    this.rebroadcast_digest_lock.unlock();
                }
                if (cancel_rebroadcasting) {
                    this.cancelRebroadcasting();
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block11;
                this.log.error((Object)"failed reading retransmitted message", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebroadcastMessages() {
        long sleep = this.max_rebroadcast_timeout / 3L;
        long wait_time = this.max_rebroadcast_timeout;
        long start = System.currentTimeMillis();
        while (wait_time > 0L) {
            Map<Address, Digest.Entry> their_digest;
            this.rebroadcast_digest_lock.lock();
            try {
                if (this.rebroadcast_digest == null) {
                    return;
                }
                their_digest = this.rebroadcast_digest.getSenders();
            }
            finally {
                this.rebroadcast_digest_lock.unlock();
            }
            Digest my_digest = this.getDigest();
            boolean xmitted = false;
            for (Map.Entry<Address, Digest.Entry> entry : their_digest.entrySet()) {
                long my_high;
                long their_high;
                Address sender = entry.getKey();
                Digest.Entry their_entry = entry.getValue();
                Digest.Entry my_entry = my_digest.get(sender);
                if (my_entry == null || (their_high = their_entry.getHighest()) <= (my_high = my_entry.getHighest())) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("sending XMIT request to " + sender + " for messages " + my_high + " - " + their_high));
                }
                this.retransmit(my_high, their_high, sender, true);
                xmitted = true;
            }
            if (!xmitted) {
                return;
            }
            this.rebroadcast_lock.lock();
            try {
                my_digest = this.getDigest();
                this.rebroadcast_digest_lock.lock();
                try {
                    if (!this.rebroadcasting || my_digest.isGreaterThanOrEqual(this.rebroadcast_digest)) {
                        this.rebroadcast_digest_lock.unlock();
                        this.rebroadcast_lock.unlock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    this.rebroadcast_digest_lock.unlock();
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            this.rebroadcast_digest_lock.unlock();
            this.rebroadcast_done.await(sleep, TimeUnit.MILLISECONDS);
            wait_time -= System.currentTimeMillis() - start;
        }
    }

    private void adjustReceivers(List<Address> new_members) {
        NakReceiverWindow win;
        Iterator it = this.xmit_table.keySet().iterator();
        while (it.hasNext()) {
            Address sender = (Address)it.next();
            if (new_members.contains(sender)) continue;
            if (this.local_addr != null && this.local_addr.equals(sender)) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("will not remove myself (" + sender + ") from xmit_table, received incorrect new membership of " + new_members));
                continue;
            }
            win = (NakReceiverWindow)this.xmit_table.get(sender);
            win.reset();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("removing " + sender + " from xmit_table (not member anymore)"));
            }
            it.remove();
        }
        for (Address sender : new_members) {
            if (this.xmit_table.containsKey(sender)) continue;
            win = this.createNakReceiverWindow(sender, 0L, 0L);
            this.xmit_table.put(sender, win);
        }
    }

    private Digest getDigest() {
        HashMap<Address, Digest.Entry> map = new HashMap<Address, Digest.Entry>(this.members.size());
        for (Address sender : this.members) {
            Digest.Entry entry = this.getEntry(sender);
            if (entry == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"range is null");
                continue;
            }
            map.put(sender, entry);
        }
        return new Digest(map);
    }

    private void setDigest(Digest digest) {
        if (digest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"digest or digest.senders is null");
            }
            return;
        }
        if (this.local_addr != null && digest.contains(this.local_addr)) {
            this.clear();
        } else {
            Iterator it = this.xmit_table.keySet().iterator();
            while (it.hasNext()) {
                Address key = (Address)it.next();
                if (this.local_addr != null && this.local_addr.equals(key)) continue;
                it.remove();
            }
        }
        for (Map.Entry<Address, Digest.Entry> entry : digest.getSenders().entrySet()) {
            Address sender = entry.getKey();
            Digest.Entry val = entry.getValue();
            if (sender == null || val == null) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"sender or value is null");
                continue;
            }
            long initial_seqno = val.getHighestDeliveredSeqno();
            NakReceiverWindow win = this.createNakReceiverWindow(sender, initial_seqno, val.getLow());
            this.xmit_table.put(sender, win);
        }
        if (!this.xmit_table.containsKey(this.local_addr) && this.log.isWarnEnabled()) {
            this.log.warn((Object)("digest does not contain local address (local_addr=" + this.local_addr + ", digest=" + digest));
        }
    }

    private void mergeDigest(Digest digest) {
        if (digest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"digest or digest.senders is null");
            }
            return;
        }
        for (Map.Entry<Address, Digest.Entry> entry : digest.getSenders().entrySet()) {
            Address sender = entry.getKey();
            Digest.Entry val = entry.getValue();
            if (sender == null || val == null) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)"sender or value is null");
                continue;
            }
            long highest_delivered_seqno = val.getHighestDeliveredSeqno();
            long low_seqno = val.getLow();
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(sender);
            if (win != null) continue;
            win = this.createNakReceiverWindow(sender, highest_delivered_seqno, low_seqno);
            this.xmit_table.putIfAbsent(sender, win);
        }
        if (!this.xmit_table.containsKey(this.local_addr) && this.log.isWarnEnabled()) {
            this.log.warn((Object)("digest does not contain local address (local_addr=" + this.local_addr + ", digest=" + digest));
        }
    }

    private NakReceiverWindow createNakReceiverWindow(Address sender, long initial_seqno, long lowest_seqno) {
        NakReceiverWindow win = new NakReceiverWindow(this.local_addr, sender, this, initial_seqno, lowest_seqno, this.timer);
        if (this.use_stats_for_retransmission) {
            win.setRetransmitTimeouts(new ActualInterval(sender));
        } else if (this.exponential_backoff > 0L) {
            win.setRetransmitTimeouts(new ExponentialInterval(this.exponential_backoff));
        } else {
            win.setRetransmitTimeouts(new StaticInterval(this.retransmit_timeouts));
        }
        win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
        win.setMaxXmitBufSize(this.max_xmit_buf_size);
        if (this.stats) {
            win.setListener(this);
        }
        return win;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpXmitStats(String filename) throws IOException {
        FileWriter out = new FileWriter(filename);
        try {
            TreeMap<Long, XmitTimeStat> map = new TreeMap<Long, XmitTimeStat>(this.xmit_time_stats);
            out.write("time (secs)  gaps-detected  xmit-reqs-sent  xmit-reqs-received  xmit-rsps-sent  xmit-rsps-received  missing-msgs-received\n\n");
            for (Map.Entry<Long, XmitTimeStat> entry : map.entrySet()) {
                StringBuilder sb = new StringBuilder();
                XmitTimeStat stat = entry.getValue();
                sb.append(entry.getKey()).append("  ");
                sb.append(stat.gaps_detected).append("  ");
                sb.append(stat.xmit_reqs_sent).append("  ");
                sb.append(stat.xmit_reqs_received).append("  ");
                sb.append(stat.xmit_rsps_sent).append("  ");
                sb.append(stat.xmit_rsps_received).append("  ");
                sb.append(stat.missing_msgs_received).append("\n");
                out.write(sb.toString());
            }
        }
        finally {
            ((Writer)out).close();
        }
    }

    private Digest.Entry getEntry(Address sender) {
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender is null");
            }
            return null;
        }
        NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(sender);
        if (win == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("sender " + sender + " not found in xmit_table"));
            }
            return null;
        }
        long low = win.getLowestSeen();
        long highest_delivered = win.getHighestDelivered();
        long highest_received = win.getHighestReceived();
        return new Digest.Entry(low, highest_delivered, highest_received);
    }

    private void stable(Digest digest) {
        if (this.members == null || this.local_addr == null || digest == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"members, local_addr or digest are null !");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("received stable digest " + digest));
        }
        this.stability_msgs.add(digest);
        for (Map.Entry<Address, Digest.Entry> entry : digest.getSenders().entrySet()) {
            Address sender = entry.getKey();
            if (sender == null) continue;
            Digest.Entry val = entry.getValue();
            long high_seqno_delivered = val.getHighestDeliveredSeqno();
            long high_seqno_received = val.getHighestReceivedSeqno();
            NakReceiverWindow recv_win = (NakReceiverWindow)this.xmit_table.get(sender);
            if (recv_win != null) {
                long my_highest_rcvd = recv_win.getHighestReceived();
                long stability_highest_rcvd = high_seqno_received;
                if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + sender + '#' + stability_highest_rcvd));
                    }
                    this.retransmit(stability_highest_rcvd, stability_highest_rcvd, sender);
                }
            }
            if ((high_seqno_delivered -= (long)this.gc_lag) < 0L) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("deleting msgs <= " + high_seqno_delivered + " from " + sender));
            }
            if (recv_win == null) continue;
            recv_win.stable(high_seqno_delivered);
        }
    }

    @Override
    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        this.retransmit(first_seqno, last_seqno, sender, false);
    }

    protected void retransmit(long first_seqno, long last_seqno, Address sender, boolean multicast_xmit_request) {
        Address random_member;
        Address dest = sender;
        if (multicast_xmit_request || this.use_mcast_xmit_req) {
            dest = null;
        } else if (this.xmit_from_random_member && !this.local_addr.equals(sender) && (random_member = (Address)Util.pickRandomElement(this.members)) != null && !this.local_addr.equals(random_member)) {
            dest = random_member;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("picked random member " + dest + " to send XMIT request to"));
            }
        }
        NakAckHeader hdr = new NakAckHeader(2, first_seqno, last_seqno, sender);
        Message retransmit_msg = new Message(dest, null, null);
        retransmit_msg.setFlag((byte)1);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.local_addr + ": sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + dest));
        }
        retransmit_msg.putHeader(name, hdr);
        ConcurrentHashMap<Long, Long> tmp = (ConcurrentHashMap<Long, Long>)this.xmit_stats.get(sender);
        if (tmp == null) {
            tmp = new ConcurrentHashMap<Long, Long>();
            this.xmit_stats.putIfAbsent(sender, tmp);
        }
        for (long seq = first_seqno; seq < last_seqno; ++seq) {
            tmp.putIfAbsent(seq, System.currentTimeMillis());
        }
        if (this.xmit_time_stats != null) {
            long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
            XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
            if (stat == null) {
                stat = new XmitTimeStat();
                this.xmit_time_stats.putIfAbsent(key, stat);
            }
            stat.xmit_reqs_sent.addAndGet((int)(last_seqno - first_seqno + 1L));
        }
        this.down_prot.down(new Event(1, retransmit_msg));
        if (this.stats) {
            this.xmit_reqs_sent += last_seqno - first_seqno + 1L;
            NAKACK.updateStats(this.sent, dest, 1, 0, 0);
            XmitRequest req = new XmitRequest(sender, first_seqno, last_seqno, dest);
            this.send_history.add(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void missingMessageReceived(long seqno, Address original_sender) {
        Long timestamp;
        ConcurrentMap tmp = (ConcurrentMap)this.xmit_stats.get(original_sender);
        if (tmp != null && (timestamp = (Long)tmp.remove(seqno)) != null) {
            long diff = System.currentTimeMillis() - timestamp;
            BoundedList<Long> list = (BoundedList<Long>)this.xmit_times_history.get(original_sender);
            if (list == null) {
                list = new BoundedList<Long>(this.xmit_history_max_size);
                this.xmit_times_history.putIfAbsent(original_sender, list);
            }
            list.add(diff);
            Map<Address, Double> map = this.smoothed_avg_xmit_times;
            synchronized (map) {
                Double smoothed_avg = this.smoothed_avg_xmit_times.get(original_sender);
                if (smoothed_avg == null) {
                    smoothed_avg = 30.0;
                }
                smoothed_avg = (smoothed_avg * 0.9 + (double)diff) / 2.0;
                smoothed_avg = smoothed_avg * 1.1;
                this.smoothed_avg_xmit_times.put(original_sender, smoothed_avg);
            }
        }
        if (this.xmit_time_stats != null) {
            long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
            XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
            if (stat == null) {
                stat = new XmitTimeStat();
                this.xmit_time_stats.putIfAbsent(key, stat);
            }
            stat.missing_msgs_received.incrementAndGet();
        }
        if (this.stats) {
            ++this.missing_msgs_received;
            NAKACK.updateStats(this.received, original_sender, 0, 0, 1);
            MissingMessage missing = new MissingMessage(original_sender, seqno);
            this.receive_history.add(missing);
        }
    }

    @Override
    public void messageGapDetected(long from, long to, Address src) {
        if (this.xmit_time_stats != null) {
            long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
            XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
            if (stat == null) {
                stat = new XmitTimeStat();
                this.xmit_time_stats.putIfAbsent(key, stat);
            }
            stat.gaps_detected.addAndGet((int)(to - from + 1L));
        }
    }

    private void clear() {
        for (NakReceiverWindow win : this.xmit_table.values()) {
            win.reset();
        }
        this.xmit_table.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        this.seqno_lock.lock();
        try {
            this.seqno = 0L;
        }
        finally {
            this.seqno_lock.unlock();
        }
        for (NakReceiverWindow win : this.xmit_table.values()) {
            win.destroy();
        }
        this.xmit_table.clear();
    }

    public String printMessages() {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Object w = entry.getValue();
            ret.append(addr).append(": ").append(w.toString()).append('\n');
        }
        return ret.toString();
    }

    public String printRetransmissionAvgs() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_times_history.entrySet()) {
            Address sender = (Address)entry.getKey();
            BoundedList list = (BoundedList)entry.getValue();
            long tmp = 0L;
            int i = 0;
            for (Long val : list) {
                tmp += val.longValue();
                ++i;
            }
            double avg = i > 0 ? (double)(tmp / (long)i) : -1.0;
            sb.append(sender).append(": ").append(avg).append("\n");
        }
        return sb.toString();
    }

    public String printSmoothedRetransmissionAvgs() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Double> entry : this.smoothed_avg_xmit_times.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public String printRetransmissionTimes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_times_history.entrySet()) {
            Address sender = (Address)entry.getKey();
            BoundedList list = (BoundedList)entry.getValue();
            sb.append(sender).append(": ").append(list).append("\n");
        }
        return sb.toString();
    }

    public double getTotalAverageRetransmissionTime() {
        long total = 0L;
        int i = 0;
        for (BoundedList list : this.xmit_times_history.values()) {
            for (Long val : list) {
                total += val.longValue();
                ++i;
            }
        }
        return i > 0 ? (double)(total / (long)i) : -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalAverageSmoothedRetransmissionTime() {
        double total = 0.0;
        int cnt = 0;
        Map<Address, Double> map = this.smoothed_avg_xmit_times;
        synchronized (map) {
            for (Double val : this.smoothed_avg_xmit_times.values()) {
                if (val == null) continue;
                total += val.doubleValue();
                ++cnt;
            }
        }
        return cnt > 0 ? total / (double)cnt : -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSmoothedAverageRetransmissionTime(Address sender) {
        Map<Address, Double> map = this.smoothed_avg_xmit_times;
        synchronized (map) {
            Double retval = this.smoothed_avg_xmit_times.get(sender);
            if (retval == null) {
                retval = 30.0;
                this.smoothed_avg_xmit_times.put(sender, retval);
            }
            return retval;
        }
    }

    static class MissingMessage {
        Address original_sender;
        long seq;
        long timestamp = System.currentTimeMillis();

        MissingMessage(Address original_sender, long seqno) {
            this.original_sender = original_sender;
            this.seq = seqno;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(new Date(this.timestamp)).append(": ").append(this.original_sender).append(" #").append(this.seq);
            return sb.toString();
        }
    }

    static class XmitRequest {
        Address original_sender;
        long low;
        long high;
        long timestamp = System.currentTimeMillis();
        Address xmit_dest;

        XmitRequest(Address original_sender, long low, long high, Address xmit_dest) {
            this.original_sender = original_sender;
            this.xmit_dest = xmit_dest;
            this.low = low;
            this.high = high;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(new Date(this.timestamp)).append(": ").append(this.original_sender).append(" #[").append(this.low);
            sb.append("-").append(this.high).append("]");
            sb.append(" (XMIT_REQ sent to ").append(this.xmit_dest).append(")");
            return sb.toString();
        }
    }

    static class StatsEntry {
        long xmit_reqs;
        long xmit_rsps;
        long missing_msgs_rcvd;

        StatsEntry() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.xmit_reqs).append(" xmit_reqs").append(", ").append(this.xmit_rsps).append(" xmit_rsps");
            sb.append(", ").append(this.missing_msgs_rcvd).append(" missing msgs");
            return sb.toString();
        }
    }

    private class ActualInterval
    implements Interval {
        private final Address sender;

        public ActualInterval(Address sender) {
            this.sender = sender;
        }

        public long next() {
            return (long)NAKACK.this.getSmoothedAverageRetransmissionTime(this.sender);
        }

        public Interval copy() {
            return this;
        }
    }

    private static class XmitTimeStat {
        final AtomicInteger gaps_detected = new AtomicInteger(0);
        final AtomicInteger xmit_reqs_sent = new AtomicInteger(0);
        final AtomicInteger xmit_reqs_received = new AtomicInteger(0);
        final AtomicInteger xmit_rsps_sent = new AtomicInteger(0);
        final AtomicInteger xmit_rsps_received = new AtomicInteger(0);
        final AtomicInteger missing_msgs_received = new AtomicInteger(0);

        private XmitTimeStat() {
        }
    }
}

