/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.UnblockEvent;
import org.jgroups.View;
import org.jgroups.mux.MuxChannel;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class FlushTest
extends ChannelTestBase {
    private JChannel c1;
    private JChannel c2;

    public FlushTest() {
    }

    public FlushTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public void tearDown() throws Exception {
        if (this.c2 != null) {
            this.c2.close();
            FlushTest.assertFalse((boolean)this.c2.isOpen());
            FlushTest.assertFalse((boolean)this.c2.isConnected());
            this.c2 = null;
        }
        if (this.c1 != null) {
            this.c1.close();
            FlushTest.assertFalse((boolean)this.c1.isOpen());
            FlushTest.assertFalse((boolean)this.c1.isConnected());
            this.c1 = null;
        }
        Util.sleep(500L);
        super.tearDown();
    }

    public boolean useBlocking() {
        return true;
    }

    public void testSingleChannel() throws Exception {
        Semaphore s = new Semaphore(1);
        ChannelTestBase.MemberRetrievable[] receivers = new FlushTestReceiver[]{new FlushTestReceiver("c1", s, 0, 1)};
        receivers[0].start();
        s.release(1);
        FlushTest.blockUntilViewsReceived(receivers, 60000L);
        Util.sleep(1000L);
        s.tryAcquire(1, 60L, TimeUnit.SECONDS);
        ((ChannelTestBase.ChannelApplication)receivers[0]).cleanup();
        Util.sleep(1000L);
        this.checkEventSequence((ChannelTestBase.PushChannelApplication)receivers[0], FlushTest.isMuxChannelUsed());
    }

    public void testJoinFollowedByUnicast() throws ChannelException {
        this.c1 = this.createChannel();
        this.c1.setReceiver(new SimpleReplier(this.c1, true));
        this.c1.connect("test");
        Address target = this.c1.getLocalAddress();
        Message unicast_msg = new Message(target);
        this.c2 = this.createChannel();
        this.c2.setReceiver(new SimpleReplier(this.c2, false));
        this.c2.connect("test");
        this.c2.send(unicast_msg);
    }

    public void testStateTransferFollowedByUnicast() throws ChannelException {
        this.c1 = this.createChannel();
        this.c1.setReceiver(new SimpleReplier(this.c1, true));
        this.c1.connect("test");
        Address target = this.c1.getLocalAddress();
        Message unicast_msg = new Message(target);
        this.c2 = this.createChannel();
        this.c2.setReceiver(new SimpleReplier(this.c2, false));
        this.c2.connect("test");
        this.log.info((Object)"\n** Getting the state **");
        this.c2.getState(null, 10000L);
        this.c2.send(unicast_msg);
    }

    public void testPartialFlush() throws Exception {
        this.c1 = this.createChannel();
        this.c1.setReceiver(new SimpleReplier(this.c1, true));
        this.c1.connect("test");
        this.c2 = this.createChannel();
        this.c2.setReceiver(new SimpleReplier(this.c2, false));
        this.c2.connect("test");
        ArrayList<Address> members = new ArrayList<Address>();
        members.add(this.c2.getLocalAddress());
        boolean flushedOk = this.c2.startFlush(members, false);
        FlushTest.assertTrue((String)"Partial flush worked", (boolean)flushedOk);
        this.c2.stopFlush(members);
    }

    public void testBlockingNoStateTransfer() {
        String[] names = null;
        if (FlushTest.isMuxChannelUsed()) {
            int muxFactoryCount = 2;
            names = this.createMuxApplicationNames(1, muxFactoryCount);
            this._testChannels(names, muxFactoryCount, 1, muxFactoryCount);
        } else {
            names = this.createApplicationNames(4);
            this._testChannels(names, 1, 4);
        }
    }

    public void testBlockingSharedMuxFactory() {
        String[] names = null;
        int muxFactoryCount = 1;
        if (FlushTest.isMuxChannelUsed()) {
            names = this.createMuxApplicationNames(4, muxFactoryCount);
            this._testChannels(names, muxFactoryCount, 1, new ChannelAssertable(1));
        }
    }

    public void testBlockingUnsharedMuxFactoryMultipleService() {
        String[] names = null;
        int muxFactoryCount = 2;
        if (FlushTest.isMuxChannelUsed()) {
            names = this.createMuxApplicationNames(2, muxFactoryCount);
            this._testChannels(names, muxFactoryCount, 1, new ChannelAssertable(2));
        }
    }

    public void testBlockingWithStateTransfer() {
        String[] names = null;
        if (FlushTest.isMuxChannelUsed()) {
            int muxFactoryCount = 2;
            names = this.createMuxApplicationNames(1, muxFactoryCount);
            this._testChannels(names, muxFactoryCount, 2, muxFactoryCount);
        } else {
            names = this.createApplicationNames(4);
            this._testChannels(names, 2, 4);
        }
    }

    public void testBlockingWithConnectAndStateTransfer() {
        String[] names = null;
        if (FlushTest.isMuxChannelUsed()) {
            int muxFactoryCount = 2;
            names = this.createMuxApplicationNames(1, muxFactoryCount);
            this._testChannels(names, muxFactoryCount, 3, muxFactoryCount);
        } else {
            names = this.createApplicationNames(4);
            this._testChannels(names, 3, 4);
        }
    }

    public void testBlockingWithStateTransferAndMultipleServiceMuxChannel() {
        String[] names = null;
        if (FlushTest.isMuxChannelUsed()) {
            names = this.createMuxApplicationNames(2, 2);
            this._testChannels(names, 2, 2, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testChannels(String[] names, int muxFactoryCount, int connectType, Assertable a) {
        int count = names.length;
        ArrayList<FlushTestReceiver> channels = new ArrayList<FlushTestReceiver>(count);
        try {
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            for (int i = 0; i < count; ++i) {
                FlushTestReceiver channel = new FlushTestReceiver(names[i], semaphore, 0, connectType);
                channels.add(channel);
                channel.start();
                semaphore.release(1);
                Util.sleep(1000L);
            }
            if (FlushTest.isMuxChannelUsed()) {
                FlushTest.blockUntilViewsReceived(channels, muxFactoryCount, 10000L);
            } else {
                FlushTest.blockUntilViewsReceived(channels, 10000L);
            }
            if (connectType == 2) {
                for (FlushTestReceiver app : channels) {
                    app.clear();
                }
                semaphore.release(count);
            }
            Util.sleep(1000L);
            semaphore.tryAcquire(count, 60L, TimeUnit.SECONDS);
            a.verify(channels);
            FlushTestReceiver randomRecv = (FlushTestReceiver)channels.remove(RANDOM.nextInt(count));
            this.log.info((Object)("Closing random member " + randomRecv.getName() + " at " + randomRecv.getLocalAddress()));
            ChannelCloseAssertable closeAssert = new ChannelCloseAssertable(randomRecv);
            randomRecv.cleanup();
            Util.sleep(5000L);
            closeAssert.verify(channels);
        }
        catch (Exception ex) {
            this.log.warn((Object)"Exception encountered during test", (Throwable)ex);
            FlushTest.fail((String)("Exception encountered during test execution: " + ex));
        }
        finally {
            for (FlushTestReceiver app : channels) {
                app.cleanup();
                Util.sleep(2000L);
            }
            for (FlushTestReceiver receiver : channels) {
                if (connectType == 2 || connectType == 3) {
                    this.checkEventStateTransferSequence(receiver);
                    continue;
                }
                this.checkEventSequence(receiver, FlushTest.isMuxChannelUsed());
            }
        }
    }

    public void _testChannels(String[] names, int connectMethod, int viewSize) {
        this._testChannels(names, this.getMuxFactoryCount(), connectMethod, new ChannelAssertable(viewSize));
    }

    public void _testChannels(String[] names, int muxFactoryCount, int connectMethod, int viewSize) {
        this._testChannels(names, muxFactoryCount, connectMethod, new ChannelAssertable(viewSize));
    }

    protected JChannel createChannel() throws ChannelException {
        JChannel ret = new JChannel(CHANNEL_CONFIG);
        ret.setOpt(0, Boolean.TRUE);
        Protocol flush = ret.getProtocolStack().findProtocol("FLUSH");
        if (flush != null) {
            Properties p = new Properties();
            p.setProperty("timeout", "0");
            flush.setProperties(p);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("flush_timeout", new Long(0L));
            flush.getUpProtocol().up(new Event(56, map));
            flush.getDownProtocol().down(new Event(56, map));
        }
        return ret;
    }

    public static Test suite() {
        return new TestSuite(FlushTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FlushTest.suite());
    }

    private class SimpleReplier
    extends ExtendedReceiverAdapter {
        Channel channel;
        boolean handle_requests = false;

        public SimpleReplier(Channel channel, boolean handle_requests) {
            this.channel = channel;
            this.handle_requests = handle_requests;
        }

        public void receive(Message msg) {
            Message reply = new Message(msg.getSrc());
            try {
                FlushTest.this.log.info((Object)("-- MySimpleReplier[" + this.channel.getLocalAddress() + "]: received message from " + msg.getSrc()));
                if (this.handle_requests) {
                    FlushTest.this.log.info((Object)", sending reply");
                    this.channel.send(reply);
                } else {
                    System.out.println("\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void viewAccepted(View new_view) {
            FlushTest.this.log.info((Object)("-- MySimpleReplier[" + this.channel.getLocalAddress() + "]: viewAccepted(" + new_view + ")"));
        }

        public void block() {
            FlushTest.this.log.info((Object)("-- MySimpleReplier[" + this.channel.getLocalAddress() + "]: block()"));
        }

        public void unblock() {
            FlushTest.this.log.info((Object)("-- MySimpleReplier[" + this.channel.getLocalAddress() + "]: unblock()"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FlushTestReceiver
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        List<Object> events;
        private int connectMethod;
        public static final int CONNECT_ONLY = 1;
        public static final int CONNECT_AND_SEPARATE_GET_STATE = 2;
        public static final int CONNECT_AND_GET_STATE = 3;
        int msgCount;

        protected FlushTestReceiver(String name, Semaphore semaphore, int msgCount, int connectMethod) throws Exception {
            super(name, semaphore);
            this.msgCount = 0;
            this.connectMethod = connectMethod;
            this.msgCount = msgCount;
            this.events = Collections.synchronizedList(new LinkedList());
            if (connectMethod == 1 || connectMethod == 2) {
                this.channel.connect("test");
            }
            if (connectMethod == 3) {
                this.channel.connect("test", null, null, 25000L);
            }
        }

        public void clear() {
            this.events.clear();
        }

        @Override
        public List<Object> getEvents() {
            return new LinkedList<Object>(this.events);
        }

        @Override
        public void block() {
            this.events.add(new BlockEvent());
        }

        @Override
        public void unblock() {
            this.events.add(new UnblockEvent());
        }

        @Override
        public void viewAccepted(View new_view) {
            this.events.add(new_view);
        }

        @Override
        public byte[] getState() {
            this.events.add(new GetStateEvent(null, null));
            return new byte[]{98, 101, 108, 97};
        }

        @Override
        public void setState(byte[] state) {
            this.events.add(new SetStateEvent(null, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getState(OutputStream ostream) {
            this.events.add(new GetStateEvent(null, null));
            byte[] payload = new byte[]{98, 101, 108, 97};
            try {
                ostream.write(payload);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Util.close(ostream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(InputStream istream) {
            this.events.add(new SetStateEvent(null, null));
            byte[] payload = new byte[4];
            try {
                istream.read(payload);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Util.close(istream);
            }
        }

        @Override
        protected void useChannel() throws Exception {
            if (this.connectMethod == 2) {
                this.channel.getState(null, 25000L);
            }
            if (this.msgCount > 0) {
                for (int i = 0; i < this.msgCount; ++i) {
                    this.channel.send(new Message());
                    Util.sleep(100L);
                }
            }
        }
    }

    private static interface Assertable {
        public void verify(Object var1);
    }

    private class ChannelAssertable
    implements Assertable {
        int expectedViewSize = 0;

        public ChannelAssertable(int expectedViewSize) {
            this.expectedViewSize = expectedViewSize;
        }

        public void verify(Object verifiable) {
            Channel ch;
            Collection channels = (Collection)verifiable;
            for (FlushTestReceiver receiver : channels) {
                ch = receiver.getChannel();
                Assert.assertEquals((String)"Correct view", (int)ch.getView().getMembers().size(), (int)this.expectedViewSize);
                Assert.assertTrue((String)"Channel open", (boolean)ch.isOpen());
                Assert.assertTrue((String)"Chnanel connected", (boolean)ch.isConnected());
                Assert.assertNotNull((String)"Valid address ", (Object)ch.getLocalAddress());
                Assert.assertTrue((String)"Address included in view ", (boolean)ch.getView().getMembers().contains(ch.getLocalAddress()));
                Assert.assertNotNull((String)"Valid cluster name ", (Object)ch.getClusterName());
            }
            if (this.expectedViewSize > 1 && ChannelTestBase.isMuxChannelUsed()) {
                for (FlushTestReceiver receiver : channels) {
                    ch = (MuxChannel)receiver.getChannel();
                    int servicePairs = 1;
                    for (FlushTestReceiver receiver2 : channels) {
                        MuxChannel ch2 = (MuxChannel)receiver2.getChannel();
                        if (!((MuxChannel)ch).getId().equals(ch2.getId()) || ((MuxChannel)ch).getLocalAddress().equals(ch2.getLocalAddress())) continue;
                        Assert.assertEquals((String)"Correct view for service pair", (Object)((MuxChannel)ch).getView(), (Object)ch2.getView());
                        Assert.assertTrue((String)"Presence in view", (boolean)((MuxChannel)ch).getView().getMembers().contains(((MuxChannel)ch).getLocalAddress()));
                        Assert.assertTrue((String)"Presence in view", (boolean)((MuxChannel)ch).getView().getMembers().contains(ch2.getLocalAddress()));
                        Assert.assertTrue((String)"Presence in view", (boolean)ch2.getView().getMembers().contains(ch2.getLocalAddress()));
                        Assert.assertTrue((String)"Presence in view", (boolean)ch2.getView().getMembers().contains(((MuxChannel)ch).getLocalAddress()));
                        ++servicePairs;
                    }
                    Assert.assertEquals((String)"Correct service count", (int)this.expectedViewSize, (int)servicePairs);
                }
            }
        }
    }

    private class ChannelCloseAssertable
    implements Assertable {
        ChannelTestBase.ChannelApplication app;
        View viewBeforeClose;
        Address appAddress;
        String muxId;

        public ChannelCloseAssertable(ChannelTestBase.ChannelApplication app) {
            this.app = app;
            this.viewBeforeClose = app.getChannel().getView();
            this.appAddress = app.getChannel().getLocalAddress();
            if (app.isUsingMuxChannel()) {
                MuxChannel mch = (MuxChannel)app.getChannel();
                this.muxId = mch.getId();
            }
        }

        public void verify(Object verifiable) {
            Collection channels = (Collection)verifiable;
            Channel ch = this.app.getChannel();
            Assert.assertFalse((String)"Channel open", (boolean)ch.isOpen());
            Assert.assertFalse((String)"Chnanel connected", (boolean)ch.isConnected());
            if (this.viewBeforeClose.getMembers().size() > 1) {
                for (FlushTestReceiver receiver : channels) {
                    boolean pairServiceFound;
                    Channel channel = receiver.getChannel();
                    boolean bl = pairServiceFound = receiver.isUsingMuxChannel() && this.muxId.equals(((MuxChannel)channel).getId());
                    if (!pairServiceFound && receiver.isUsingMuxChannel()) continue;
                    Assert.assertTrue((String)("Removed from view, address " + this.appAddress + " view is " + channel.getView()), (!channel.getView().getMembers().contains(this.appAddress) ? 1 : 0) != 0);
                }
            }
        }
    }
}

