/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.test;

import java.io.Serializable;

/**
 */
// We are using JDK1.5 annotation.
@org.jboss.cache.pojo.annotation.Replicable
public class ArrayObject
{
   // Support array interception and serializable
   @org.jboss.cache.pojo.annotation.Replicable
   public static class Person implements Serializable
   {
      private static final long serialVersionUID = 1L;
      private String name;
      private int age;

      public Person() {
      }

      public Person(String name) {
         this.name = name;
      }

      public String getName()
      {
         return name;
      }
      public void setName(String name)
      {
         this.name = name;
      }
      public int getAge()
      {
         return age;
      }
      public void setAge(int age)
      {
         this.age = age;
      }
   }
   private Person[] team;
   private Person[][][] multiTeam;
   private int[] nums;

   public ArrayObject()
   {
      team = new Person[10];
      multiTeam = new Person[5][5][6];
      nums = new int[] {1,2,3,4,5,6,7,8,9};
   }

   public Person[] getTeam()
   {
      return team;
   }

   public void setTeam(Person[] t)
   {
      team = t;
   }

   public void setNum(int index, int value)
   {
      int nums[] = this.nums;
      nums[index] = value;

      // This will be optimized away if array interception is enabled
      this.nums = nums;
   }

   public int getNum(int index)
   {
      return nums[index];
   }

   public Person getPerson(int index)
   {
      return team[index];
   }

   public void setPerson(int index, Person p)
   {
      Person[] array = team;
      array[index] = p;

      // This will be optimized away if array interception is enabled
      team = array;
   }

   public Person getMultiPerson(int one, int two, int three) {
      return multiTeam[one][two][three];
   }

   public void setMultiPerson(int one, int two, int three, Person person) {
      multiTeam[one][two][three] = person;
   }
}


